/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.clientsideelement.content.SmartContentClientSideElementHelper;
import org.ametys.cms.indexing.solr.SolrIndexHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.RemovableAmetysObject;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.ametys.plugins.repository.trash.TrashElement;
import org.ametys.plugins.repository.trash.TrashElementDAO;
import org.ametys.plugins.repository.trash.TrashableAmetysObject;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.slf4j.Logger;

public abstract class AbstractDeleteUDContentComponent
implements Component,
Serviceable,
Configurable {
    private static final int _REMOVE_REFERENCE_DEFAULT_ACTION_ID = 200;
    protected AmetysObjectResolver _resolver;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected SmartContentClientSideElementHelper _smartHelper;
    protected SolrIndexHelper _solrIndexHelper;
    protected org.ametys.cms.trash.element.TrashElementDAO _trashElementDAO;
    protected int _removeReferenceActionId;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._observationManager = (ObservationManager)smanager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._smartHelper = (SmartContentClientSideElementHelper)smanager.lookup(SmartContentClientSideElementHelper.ROLE);
        this._solrIndexHelper = (SolrIndexHelper)smanager.lookup(SolrIndexHelper.ROLE);
        this._trashElementDAO = (org.ametys.cms.trash.element.TrashElementDAO)smanager.lookup(TrashElementDAO.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration conf = configuration.getChild("removeReferenceActionId");
        this._removeReferenceActionId = conf.getValueAsInteger(200);
    }

    public int trashContentsWithLog(List<Content> contentsToRemove, Map<String, Object> parameters, Map<String, String> rights, Logger logger) {
        return this._deleteContentsWithLog(contentsToRemove, parameters, rights, false, logger);
    }

    public int deleteContentsWithLog(List<Content> contentsToRemove, Map<String, Object> parameters, Map<String, String> rights, Logger logger) {
        return this._deleteContentsWithLog(contentsToRemove, parameters, rights, true, logger);
    }

    private int _deleteContentsWithLog(List<Content> contentsToRemove, Map<String, Object> parameters, Map<String, String> rights, boolean onlyDeletion, Logger logger) {
        int nbDeletedContents = 0;
        List<String> contentIds = contentsToRemove.stream().map(AmetysObject::getId).collect(Collectors.toList());
        logger.info("Trying to delete contents. This can take a while...");
        Map<String, Object> deleteResults = this._deleteContents(contentIds, parameters, rights, onlyDeletion, logger);
        logger.info("Contents deleting process ended.");
        for (String contentId : contentIds) {
            List undeletedContents;
            List lockedContents;
            Map result = (Map)deleteResults.get(contentId);
            if (result == null) continue;
            List deletedContents = (List)result.get("deleted-contents");
            nbDeletedContents += deletedContents.size();
            List referencedContents = (List)result.get("referenced-contents");
            if (referencedContents.size() > 0) {
                logger.info("The following contents cannot be deleted because they are referenced: {}", referencedContents.stream().map(c -> c.getId()).collect(Collectors.toList()));
            }
            if ((lockedContents = (List)result.get("locked-contents")).size() > 0) {
                logger.info("The following contents cannot be deleted because they are locked: {}", lockedContents.stream().map(c -> c.getId()).collect(Collectors.toList()));
            }
            if ((undeletedContents = (List)result.get("undeleted-contents")).size() <= 0) continue;
            logger.info("{} contents were not deleted. See previous logs for more information.", (Object)undeletedContents.size());
        }
        return nbDeletedContents;
    }

    public Map<String, Object> trashContents(List<String> contentsId, Map<String, Object> parameters, Map<String, String> rights, Logger logger) {
        return this._deleteContents(contentsId, parameters, rights, false, logger);
    }

    public Map<String, Object> deleteContents(List<String> contentsId, Map<String, Object> parameters, Map<String, String> rights, Logger logger) {
        return this._deleteContents(contentsId, parameters, rights, true, logger);
    }

    private Map<String, Object> _deleteContents(List<String> contentsId, Map<String, Object> parameters, Map<String, String> rights, boolean onlyDeletion, Logger logger) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ArrayList alreadyDeletedContentIds = new ArrayList();
        for (String contentId : contentsId) {
            if (!alreadyDeletedContentIds.contains(contentId)) {
                Content content = (Content)this._resolver.resolveById(contentId);
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("deleted-contents", new ArrayList());
                result.put("undeleted-contents", new ArrayList());
                result.put("referenced-contents", new ArrayList());
                result.put("unauthorized-contents", new ArrayList());
                result.put("locked-contents", new ArrayList());
                result.put("initial-content", content.getId());
                results.put(contentId, result);
                boolean referenced = this.isContentReferenced(content, logger);
                if (referenced || !this._checkBeforeDeletion(content, rights, result, logger)) {
                    if (referenced) {
                        List referencedContents = (List)result.get("referenced-contents");
                        referencedContents.add(content);
                    }
                    result.put("check-before-deletion-failed", true);
                    continue;
                }
                this._deleteContent(content, parameters, rights, result, onlyDeletion, logger);
                List deletedContents = (List)result.get("deleted-contents");
                if (deletedContents == null) continue;
                alreadyDeletedContentIds.addAll(deletedContents);
                continue;
            }
            logger.info("Content with id '{}' has been already deleted during its parent deletion", (Object)contentId);
            TrashElement trashElement = this._trashElementDAO.find(contentId);
            if (trashElement == null || !((Boolean)trashElement.getValue("hidden")).booleanValue()) continue;
            trashElement.setHidden(false);
            trashElement.saveChanges();
            HashMap<String, String> eventParams = new HashMap<String, String>();
            eventParams.put("trash.element.id", trashElement.getId());
            eventParams.put("ametys-object.id", contentId);
            this._observationManager.notify(new Event("trash.updated", this._currentUserProvider.getUser(), eventParams));
        }
        return results;
    }

    protected void _deleteContent(Content content, Map<String, Object> parameters, Map<String, String> rights, Map<String, Object> results, boolean onlyDeletion, Logger logger) {
        boolean success = this._removeRelations(content, parameters, logger);
        if (success) {
            this._processContentDeletion(content, parameters, rights, results, onlyDeletion, logger);
        } else {
            List undeletedContents = (List)results.get("undeleted-contents");
            undeletedContents.add(content);
            logger.warn("Can not delete content {} ('{}') : at least one relation to contents could not be removed", (Object)content.getTitle(), (Object)content.getId());
        }
    }

    protected void _processContentDeletion(Content content, Map<String, Object> parameters, Map<String, String> rights, Map<String, Object> results, boolean onlyDeletion, Logger logger) {
        Set<DeletionInfo> toDelete = this._getContentIdsToDelete(content, parameters, rights, false, results, logger);
        List referencedContents = (List)results.get("referenced-contents");
        List lockedContents = (List)results.get("locked-contents");
        List unauthorizedContents = (List)results.get("unauthorized-contents");
        if (referencedContents.size() == 0 && lockedContents.size() == 0 && unauthorizedContents.size() == 0) {
            this._finalizeDeleteContents(toDelete, (ModifiableAmetysObject)content.getParent(), results, onlyDeletion, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _finalizeDeleteContents(Set<DeletionInfo> contentIdsToDelete, ModifiableAmetysObject parent, Map<String, Object> results, boolean onlyDeletion, Logger logger) {
        List unauthorizedContents = (List)results.get("unauthorized-contents");
        List lockedContents = (List)results.get("locked-contents");
        if (!unauthorizedContents.isEmpty() || !lockedContents.isEmpty()) {
            return;
        }
        try {
            Content content;
            this._solrIndexHelper.pauseSolrCommitForEvents(new String[]{"content.deleted"});
            HashMap<String, Map<String, Object>> eventParams = new HashMap<String, Map<String, Object>>();
            for (DeletionInfo info : contentIdsToDelete) {
                content = (Content)this._resolver.resolveById(info.contentId());
                Map<String, Object> eventParam = this._getEventParametersForDeletion(content);
                eventParams.put(info.contentId(), eventParam);
                this._observationManager.notify(new Event("content.deleting", this._currentUserProvider.getUser(), eventParam));
            }
            for (DeletionInfo info : contentIdsToDelete) {
                content = (Content)this._resolver.resolveById(info.contentId());
                LockableAmetysObject lockedContent = (LockableAmetysObject)content;
                if (lockedContent.isLocked()) {
                    lockedContent.unlock();
                }
                if (!onlyDeletion && content instanceof TrashableAmetysObject) {
                    TrashableAmetysObject trashableAO = (TrashableAmetysObject)content;
                    this._trashElementDAO.trash(trashableAO, info.hidden(), (String[])info.linkedContents().toArray(String[]::new));
                    continue;
                }
                ((RemovableAmetysObject)content).remove();
            }
            parent.saveChanges();
            for (DeletionInfo info : contentIdsToDelete) {
                this._observationManager.notify(new Event("content.deleted", this._currentUserProvider.getUser(), (Map)eventParams.get(info.contentId())));
                List deletedContents = (List)results.get("deleted-contents");
                deletedContents.add(info.contentId());
            }
        }
        catch (Throwable throwable) {
            this._solrIndexHelper.restartSolrCommitForEvents(new String[]{"content.deleted"});
            throw throwable;
        }
        this._solrIndexHelper.restartSolrCommitForEvents(new String[]{"content.deleted"});
    }

    protected boolean _canDeleteContent(Content content, Map<String, String> rights, Map<String, Object> results) {
        if (!(content instanceof RemovableAmetysObject)) {
            throw new IllegalArgumentException("The content [" + content.getId() + "] is not a RemovableAmetysObject, it can't be deleted.");
        }
        if (!this._hasRight(content, rights)) {
            List norightContents = (List)results.get("unauthorized-contents");
            norightContents.add(content);
            return false;
        }
        if (this._isLocked(content)) {
            List lockedContents = (List)results.get("locked-contents");
            lockedContents.add(content);
            return false;
        }
        return true;
    }

    protected Map<String, Object> _getEventParametersForDeletion(Content content) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("content", content);
        eventParams.put("content.name", content.getName());
        eventParams.put("content.id", content.getId());
        return eventParams;
    }

    protected boolean _isLocked(Content content) {
        return this._smartHelper.isLocked(content);
    }

    protected boolean _hasRight(Content content, Map<String, String> rights) {
        if (rights.isEmpty()) {
            return true;
        }
        return this._smartHelper.hasRight(rights, content);
    }

    public abstract boolean isContentReferenced(Content var1, Logger var2);

    protected abstract boolean _checkBeforeDeletion(Content var1, Map<String, String> var2, Map<String, Object> var3, Logger var4);

    protected abstract boolean _removeRelations(Content var1, Map<String, Object> var2, Logger var3);

    protected abstract Set<DeletionInfo> _getContentIdsToDelete(Content var1, Map<String, Object> var2, Map<String, String> var3, boolean var4, Map<String, Object> var5, Logger var6);

    protected record DeletionInfo(String contentId, Collection<String> linkedContents, boolean hidden) {
    }
}

