/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory;

import java.time.Period;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.user.status.PersonalDataPolicy;
import org.ametys.core.user.status.UserStatusInfo;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.userdirectory.DeleteUserComponent;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class UserContentDataPolicy
extends AbstractLogEnabled
implements PersonalDataPolicy,
Serviceable {
    protected UserDirectoryHelper _userDirectoryHelper;
    protected DeleteUserComponent _userContentDAO;
    private Period _retentionPeriod;

    public void service(ServiceManager manager) throws ServiceException {
        this._userDirectoryHelper = (UserDirectoryHelper)((Object)manager.lookup(UserDirectoryHelper.ROLE));
        this._userContentDAO = (DeleteUserComponent)manager.lookup(DeleteUserComponent.ROLE);
        Long config = (Long)Config.getInstance().getValue("user-directory.user.content.data-policy.retention.period", false, null);
        this._retentionPeriod = config != null && config >= 0L ? Period.ofMonths(config.intValue()) : null;
    }

    public PersonalDataPolicy.AnonymizationResult process(UserStatusInfo userStatusInfo) {
        if (this._retentionPeriod == null) {
            return PersonalDataPolicy.AnonymizationResult.TOO_EARLY;
        }
        if (userStatusInfo.getMissingSinceDate().isBefore(ZonedDateTime.now().minus(this._retentionPeriod))) {
            UserIdentity userIdentity = userStatusInfo.getUserIdentity();
            List<Content> userContents = this._userDirectoryHelper.getUserContents(userIdentity);
            if (userContents.size() > 0) {
                this._userContentDAO.deleteContents(userContents.stream().map(AmetysObject::getId).toList(), Map.of(), Map.of(), this.getLogger());
                ForensicLogger.info((String)"data.policy.gdpr.remove.user.contents", Map.of("handled", Integer.toString(userContents.size()), "identity", userIdentity), (UserIdentity)UserPopulationDAO.SYSTEM_USER_IDENTITY);
                return PersonalDataPolicy.AnonymizationResult.PROCESSED;
            }
            return PersonalDataPolicy.AnonymizationResult.NO_DATA;
        }
        return PersonalDataPolicy.AnonymizationResult.TOO_EARLY;
    }
}

