/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.synchronize;

import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.content.references.OutgoingReferencesExtractor;
import org.ametys.cms.data.ContentSynchronizationResult;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.contentio.synchronize.impl.SQLSynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.workflow.EditSynchronizedContentFunction;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.data.external.ExternalizableDataProvider;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.group.Repeater;
import org.ametys.plugins.repository.data.holder.values.SynchronizationContext;
import org.ametys.plugins.repository.data.holder.values.SynchronizationResult;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.userdirectory.DeleteOrgUnitComponent;
import org.ametys.plugins.userdirectory.OrganisationChartPageHandler;
import org.ametys.plugins.userdirectory.synchronize.SQLUserSearchDAO;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;

public class SQLSynchronizableUDOrgunitCollection
extends SQLSynchronizableContentsCollection {
    public static final String ORGUNIT_REMOTE_ID_INTERNAL_DATA = "orgunit-remote-id";
    public static final String RESULT_NB_SYNCHRONIZED_ORGUNITS_RELATIONS = "nbSynchronizedOrgUnitsRelations";
    private static final String __PARAM_SQL_TABLE_USER = "tableNameUser";
    private static final String __PARAM_SQL_ORGUNIT_JOIN_COLUMN_NAME = "orgUnitJoinColumnName";
    private static final String __PARAM_LOGIN_USER_ATTRIBUTE_NAME = "loginUser";
    private static final String __PARAM_SQL_LOGIN_USER_COLUMN_NAME = "loginColumnName";
    private static final String __PARAM_SQL_ROLE_USER_COLUMN_NAME = "roleColumnName";
    private static final String __PARAM_SQL_ORGUNIT_REMOTE_ID_COLUMN_NAME = "orgunitRemoteIdColumnName";
    private static final String __PARAM_SQL_USER_SORT_COLUMN_NAME = "sortColumnName";
    private static final String __PARAM_SQL_USER_SORT_PREVAIL_NAME = "sortPrevail";
    protected Map<String, String> _orgUnitParents;
    protected Map<String, Map<String, String>> _usersByOrgUnitId;
    protected Map<String, String> _orgUnitRemoteIds;
    protected Integer _nbSynchronizedOrgUnit;
    protected SQLUserSearchDAO _sqlUserDAO;
    protected OrganisationChartPageHandler _orgChartPageHandler;
    protected CurrentUserProvider _userProvider;
    protected OutgoingReferencesExtractor _outgoingReferencesExtractor;
    protected DeleteOrgUnitComponent _deleteOrgUnitComponent;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._sqlUserDAO = (SQLUserSearchDAO)((Object)smanager.lookup(SQLUserSearchDAO.ROLE));
        this._orgChartPageHandler = (OrganisationChartPageHandler)((Object)smanager.lookup(OrganisationChartPageHandler.ROLE));
        this._userProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._outgoingReferencesExtractor = (OutgoingReferencesExtractor)smanager.lookup(OutgoingReferencesExtractor.ROLE);
        this._deleteOrgUnitComponent = (DeleteOrgUnitComponent)smanager.lookup(DeleteOrgUnitComponent.ROLE);
    }

    public boolean handleRightAssignmentContext() {
        return false;
    }

    public String getUserTableName() {
        return (String)this.getParameterValues().get(__PARAM_SQL_TABLE_USER);
    }

    public String getOrgunitJoinColumnNameForUser() {
        return (String)this.getParameterValues().get(__PARAM_SQL_ORGUNIT_JOIN_COLUMN_NAME);
    }

    public String getLoginUserAttributeName() {
        return (String)this.getParameterValues().get(__PARAM_LOGIN_USER_ATTRIBUTE_NAME);
    }

    public String getLoginUserColumnName() {
        return (String)this.getParameterValues().get(__PARAM_SQL_LOGIN_USER_COLUMN_NAME);
    }

    public String getRoleUserColumnName() {
        return (String)this.getParameterValues().get(__PARAM_SQL_ROLE_USER_COLUMN_NAME);
    }

    public String getUserSortColumnName() {
        return (String)this.getParameterValues().get(__PARAM_SQL_USER_SORT_COLUMN_NAME);
    }

    public String getOrgUnitRemoteIdColumnName() {
        return (String)this.getParameterValues().get(__PARAM_SQL_ORGUNIT_REMOTE_ID_COLUMN_NAME);
    }

    public boolean isUserSortPrevail() {
        return Boolean.valueOf((String)this.getParameterValues().get(__PARAM_SQL_USER_SORT_PREVAIL_NAME));
    }

    protected Map<String, Object> _getSearchParameters(Map<String, Object> parameters, int offset, int limit, List<Object> sort, List<String> columns) {
        String orgUnitIdColumnName = this.getOrgUnitRemoteIdColumnName();
        if (!columns.contains(orgUnitIdColumnName)) {
            columns.add(orgUnitIdColumnName);
        }
        return super._getSearchParameters(parameters, offset, limit, sort, columns);
    }

    protected Map<String, Map<String, Object>> internalSearch(Map<String, Object> searchParameters, int offset, int limit, List<Object> sort, Logger logger) {
        Map internalSearch = super.internalSearch(searchParameters, offset, limit, sort, logger);
        String orgUnitRemoteIdColumnName = this.getOrgUnitRemoteIdColumnName();
        for (String orgUnitIdValue : internalSearch.keySet()) {
            String parentColumn;
            Map orgUnitValues = (Map)internalSearch.get(orgUnitIdValue);
            this._orgUnitRemoteIds.put(orgUnitIdValue, orgUnitValues.get(orgUnitRemoteIdColumnName).toString());
            Map mapping = this.getMapping();
            if (!mapping.containsKey("parentOrgUnit") || !orgUnitValues.containsKey(parentColumn = (String)((List)mapping.get("parentOrgUnit")).get(0))) continue;
            String parentId = Optional.of(orgUnitValues).map(v -> v.get(parentColumn)).map(Object::toString).orElse(null);
            this._orgUnitParents.put(orgUnitIdValue, parentId);
        }
        return internalSearch;
    }

    protected void _logSynchronizationResult(Logger logger) {
        super._logSynchronizationResult(logger);
        logger.info("{} contents have been modified to update the parent-child relations.", (Object)this._nbSynchronizedOrgUnit);
    }

    protected boolean _hasSomethingChanged() {
        return super._hasSomethingChanged() || this._nbSynchronizedOrgUnit > 0;
    }

    protected List<ModifiableContent> _internalPopulate(Logger logger, ContainerProgressionTracker progressionTracker) {
        this._orgUnitParents = new HashMap<String, String>();
        this._orgUnitRemoteIds = new HashMap<String, String>();
        this._usersByOrgUnitId = this._getUsersByOrgUnit(logger);
        this._nbSynchronizedOrgUnit = 0;
        List contents = super._internalPopulate(logger, progressionTracker);
        this._setContentsRelationWithParentOrgunit(contents, logger);
        return contents;
    }

    protected Map<String, Map<String, String>> _getUsersByOrgUnit(Logger logger) {
        String idField;
        HashMap<String, Map<String, String>> orgUnitsUsers = new HashMap<String, Map<String, String>>();
        Map mapping = this.getMapping();
        List orgUnitKeys = (List)mapping.get(idField = this.getIdField());
        if (orgUnitKeys != null && orgUnitKeys.size() > 0) {
            String orgUnitKey = (String)orgUnitKeys.get(0);
            Map<String, Object> userParameters = this._getSearchUserParameters(orgUnitKey, logger);
            List<Map<String, Object>> searchUserList = this._sqlUserDAO.searchUser(userParameters, this.getDataSourceId());
            String loginColumnName = this.getLoginUserColumnName();
            String roleColumnName = this.getRoleUserColumnName();
            ArrayList<String> userColumns = new ArrayList<String>();
            userColumns.add(loginColumnName);
            userColumns.add(orgUnitKey);
            if (StringUtils.isNotBlank((CharSequence)roleColumnName)) {
                userColumns.add(roleColumnName);
            }
            for (Map<String, Object> userMap : searchUserList) {
                Map normalizedUserMap = this._getNormalizedSearchResult(userColumns, userMap);
                Optional<Triple<String, String, String>> orgUnitUser = this._getUserByOrgUnit(orgUnitKey, loginColumnName, roleColumnName, normalizedUserMap, logger);
                if (!orgUnitUser.isPresent()) continue;
                Triple<String, String, String> triple = orgUnitUser.get();
                String orgUnitId = (String)triple.getLeft();
                Map orgUnitUsers = orgUnitsUsers.computeIfAbsent(orgUnitId, __ -> new LinkedHashMap());
                orgUnitUsers.put((String)triple.getMiddle(), (String)triple.getRight());
            }
        }
        return orgUnitsUsers;
    }

    protected Optional<Triple<String, String, String>> _getUserByOrgUnit(String orgUnitKey, String loginColumnName, String roleColumnName, Map<String, Object> normalizedUser, Logger logger) {
        String loginValue = normalizedUser.get(loginColumnName) == null ? null : String.valueOf(normalizedUser.get(loginColumnName));
        String orgUnitIdValue = normalizedUser.get(orgUnitKey).toString();
        if (StringUtils.isNotBlank((CharSequence)loginValue)) {
            String roleValue = null;
            if (StringUtils.isNotBlank((CharSequence)roleColumnName)) {
                roleValue = normalizedUser.get(roleColumnName) == null ? null : String.valueOf(normalizedUser.get(roleColumnName));
            }
            return Optional.of(Triple.of((Object)orgUnitIdValue, (Object)loginValue, roleValue));
        }
        logger.warn("Can't add user to orgunit '" + orgUnitIdValue + "' because the login value is blank ...");
        return Optional.empty();
    }

    protected Optional<ModifiableContent> _importOrSynchronizeContent(String idValue, String lang, Map<String, List<Object>> remoteValues, boolean forceImport, Logger logger) {
        remoteValues.remove("parentOrgUnit");
        return super._importOrSynchronizeContent(idValue, lang, remoteValues, forceImport, logger);
    }

    public ContentSynchronizationResult additionalCommonOperations(ModifiableContent content, Map<String, Object> additionalParameters, Logger logger) {
        ContentSynchronizationResult result = super.additionalCommonOperations(content, additionalParameters, logger);
        try {
            SynchronizationResult additionalResult = new SynchronizationResult();
            String orgUnitIdValue = (String)content.getValue(this.getIdField());
            ModifiableModelLessDataHolder internalDataHolder = content.getInternalDataHolder();
            String oldValue = (String)internalDataHolder.getValueOfType(ORGUNIT_REMOTE_ID_INTERNAL_DATA, "string");
            String value = this._orgUnitRemoteIds.get(orgUnitIdValue);
            if (!value.equals(oldValue)) {
                internalDataHolder.setValue(ORGUNIT_REMOTE_ID_INTERNAL_DATA, (Object)value);
                additionalResult.setHasChanged(true);
            }
            result.aggregateResult(additionalResult);
        }
        catch (Exception e) {
            ++this._nbError;
            logger.error("An error occurred while importing or synchronizing orgunit '{}' and setting its remote id.", (Object)content, (Object)e);
        }
        return result;
    }

    protected Map<String, Object> getAdditionalAttributeValues(String idValue, Content content, Map<String, Object> additionalParameters, boolean create, Logger logger) {
        Map additionalRemoteValues = super.getAdditionalAttributeValues(idValue, content, additionalParameters, create, logger);
        List oldOrgUnitUsers = Optional.ofNullable(content.getRepeater("users")).map(Repeater::getEntries).orElseGet(() -> List.of());
        List<Map<String, Object>> newOrgUnitUsers = this._getOrgUnitUsers(idValue, content.getLanguage());
        if (!oldOrgUnitUsers.isEmpty() || !newOrgUnitUsers.isEmpty()) {
            additionalRemoteValues.put("users", newOrgUnitUsers);
        }
        return additionalRemoteValues;
    }

    protected List<Map<String, Object>> _getOrgUnitUsers(String orgUnitId, String lang) {
        if (this._usersByOrgUnitId.containsKey(orgUnitId)) {
            ArrayList<Map<String, Object>> users = new ArrayList<Map<String, Object>>();
            for (Map.Entry<String, String> user : this._usersByOrgUnitId.get(orgUnitId).entrySet()) {
                HashMap<String, String> orgUnitUser = new HashMap<String, String>();
                String loginValue = user.getKey();
                Content userContent = this._getUserContent(loginValue, lang);
                if (userContent == null) continue;
                String roleValue = user.getValue();
                orgUnitUser.put("role", roleValue);
                orgUnitUser.put("user", (String)userContent);
                users.add(orgUnitUser);
            }
            return users;
        }
        return List.of();
    }

    protected void _setContentsRelationWithParentOrgunit(List<ModifiableContent> orgUnitContents, Logger logger) {
        for (ModifiableContent orgUnitContent : orgUnitContents) {
            try {
                if (!(orgUnitContent instanceof WorkflowAwareContent)) continue;
                I18nizableText commentText = new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_WORKFLOW_ACTION_EDIT_ORGUNIT_REFERENCE_MSG");
                String comment = this._i18nUtils.translate((I18nizable)commentText, orgUnitContent.getLanguage());
                View view = View.of((Collection)orgUnitContent.getModel(), (String[])new String[]{"parentOrgUnit"});
                HashMap<String, Content> values = new HashMap<String, Content>();
                String orgUnitIdValue = (String)orgUnitContent.getValue(this.getIdField());
                String newParentSynchroId = this._orgUnitParents.get(orgUnitIdValue);
                Content newParentContent = newParentSynchroId != null ? this._getOrgUnitContentFromRemoteId(newParentSynchroId, orgUnitContent.getLanguage(), logger) : null;
                values.put("parentOrgUnit", newParentContent);
                SynchronizationContext synchronizationContext = SynchronizationContext.newInstance().withStatus(ExternalizableDataProvider.ExternalizableDataStatus.EXTERNAL).withExternalizableDataContextEntry("sccId", (Object)this.getId()).withIncompatibleValuesIgnored(true);
                if (!orgUnitContent.hasDifferences((ViewItemAccessor)view, values, synchronizationContext)) continue;
                HashMap<String, Object> inputs = new HashMap<String, Object>();
                if (StringUtils.isNotEmpty((CharSequence)comment)) {
                    inputs.put("comment", comment);
                }
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("view", view);
                parameters.put("typedValues", values);
                parameters.put("quit", true);
                inputs.put(AbstractWorkflowComponent.CONTEXT_PARAMETERS_KEY, parameters);
                inputs.put(EditSynchronizedContentFunction.SYNCHRO_INVERT_EDIT_ACTION_ID_KEY, this.getSynchronizeActionId());
                Map actionResult = this._contentWorkflowHelper.doAction((WorkflowAwareContent)orgUnitContent, this.getSynchronizeActionId(), inputs);
                if (!actionResult.getOrDefault("content.has.changed", false).booleanValue()) continue;
                Integer n = this._nbSynchronizedOrgUnit;
                this._nbSynchronizedOrgUnit = this._nbSynchronizedOrgUnit + 1;
            }
            catch (InvalidActionException | WorkflowException e) {
                logger.error("An error occurred while updating parent-child relations of org unit {} ", (Object)orgUnitContent, (Object)e);
            }
        }
    }

    protected Content _getUserContent(String loginValue, String lang) {
        String loginAttribute = this.getLoginUserAttributeName();
        Set contentTypes = this._contentTypeEP.getSubTypes("org.ametys.plugins.userdirectory.Content.user");
        ContentTypeExpression ctypeExpression = new ContentTypeExpression(Expression.Operator.EQ, contentTypes.toArray(new String[contentTypes.size()]));
        LanguageExpression languageExpression = new LanguageExpression(Expression.Operator.EQ, lang);
        StringExpression loginExp = new StringExpression(loginAttribute, Expression.Operator.EQ, loginValue);
        AndExpression userExp = new AndExpression(new Expression[]{loginExp, ctypeExpression, languageExpression});
        String xPathQuery = ContentQueryHelper.getContentXPathQuery((Expression)userExp);
        AmetysObjectIterable contentQuery = this._resolver.query(xPathQuery);
        AmetysObjectIterator contentIterator = contentQuery.iterator();
        if (contentIterator.hasNext()) {
            return (Content)contentIterator.next();
        }
        return null;
    }

    protected Content _getOrgUnitContentFromRemoteId(String remoteId, String lang, Logger logger) {
        ContentTypeExpression ctypeExpression = new ContentTypeExpression(Expression.Operator.EQ, new String[]{this.getContentType()});
        StringExpression remoteIdOrgunitExpression = new StringExpression(ORGUNIT_REMOTE_ID_INTERNAL_DATA, Expression.Operator.EQ, remoteId, ExpressionContext.newInstance().withInternal(true));
        LanguageExpression languageExpression = new LanguageExpression(Expression.Operator.EQ, lang);
        Expression collectionExpression = this._sccHelper.getCollectionExpression(this.getId());
        AndExpression userExp = new AndExpression(new Expression[]{remoteIdOrgunitExpression, ctypeExpression, languageExpression, collectionExpression});
        String xPathQuery = ContentQueryHelper.getContentXPathQuery((Expression)userExp);
        AmetysObjectIterable contentQuery = this._resolver.query(xPathQuery);
        AmetysObjectIterator contentIterator = contentQuery.iterator();
        if (contentIterator.hasNext()) {
            return (Content)contentIterator.next();
        }
        return null;
    }

    protected Map<String, Object> _getSearchUserParameters(String orgUnitColumnKey, Logger logger) {
        String sortColumnName;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(__PARAM_SQL_LOGIN_USER_COLUMN_NAME, this.getLoginUserColumnName());
        params.put("tableUser", this.getUserTableName());
        params.put("tableOrgUnit", this.getTableName());
        params.put("joinColumnName", this.getOrgunitJoinColumnNameForUser());
        params.put("orgUnitColumnKey", orgUnitColumnKey);
        params.put("orgUnitIdColumnName", this.getOrgUnitRemoteIdColumnName());
        String roleUserColumnName = this.getRoleUserColumnName();
        if (StringUtils.isNotBlank((CharSequence)roleUserColumnName)) {
            params.put(__PARAM_SQL_ROLE_USER_COLUMN_NAME, roleUserColumnName);
        }
        if (StringUtils.isNotBlank((CharSequence)(sortColumnName = this.getUserSortColumnName()))) {
            params.put(__PARAM_SQL_USER_SORT_COLUMN_NAME, sortColumnName);
        }
        return params;
    }

    protected int _deleteContents(List<Content> contentsToRemove, Logger logger) {
        return this._deleteOrgUnitComponent.deleteContentsWithLog(contentsToRemove, Map.of("sccId", this.getId()), Map.of(), logger);
    }

    public Map<String, Integer> getSynchronizationResult() {
        Map result = super.getSynchronizationResult();
        result.put(RESULT_NB_SYNCHRONIZED_ORGUNITS_RELATIONS, this._nbSynchronizedOrgUnit);
        return result;
    }
}

