/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.userdirectory.transformation.xslt;

import java.util.List;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.plugins.userdirectory.page.UserDirectoryPageResolver;
import org.ametys.plugins.userdirectory.page.UserPage;
import org.ametys.web.transformation.xslt.AmetysXSLTHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class UserXSLTHelper
extends AmetysXSLTHelper {
    protected static UserDirectoryPageResolver _userDirectoryPageResolver;
    protected static UserDirectoryHelper _userDirectoryHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        _userDirectoryPageResolver = (UserDirectoryPageResolver)((Object)manager.lookup(UserDirectoryPageResolver.ROLE));
        _userDirectoryHelper = (UserDirectoryHelper)((Object)manager.lookup(UserDirectoryHelper.ROLE));
    }

    @Deprecated
    public static String getUserContent(String lang, String userIdentity) {
        if (StringUtils.isBlank((CharSequence)userIdentity)) {
            return null;
        }
        UserIdentity user = UserIdentity.stringToUserIdentity((String)userIdentity);
        Content userContent = _userDirectoryHelper.getUserContent(user, lang);
        if (userContent != null) {
            return userContent.getId();
        }
        return null;
    }

    public static List<Content> getUserContents(String lang, String userIdentity) {
        if (StringUtils.isBlank((CharSequence)userIdentity)) {
            return null;
        }
        UserIdentity user = UserIdentity.stringToUserIdentity((String)userIdentity);
        return _userDirectoryHelper.getUserContents(user, lang);
    }

    @Deprecated
    public static String getCurrentUserContent(String lang) {
        UserIdentity currentUser = _currentUserProvider.getUser();
        if (currentUser == null) {
            return null;
        }
        Content userContent = _userDirectoryHelper.getUserContent(currentUser, lang);
        if (userContent != null) {
            return userContent.getId();
        }
        return null;
    }

    public static List<Content> getCurrentUserContents(String lang) {
        UserIdentity currentUser = _currentUserProvider.getUser();
        if (currentUser == null) {
            return null;
        }
        return _userDirectoryHelper.getUserContents(currentUser, lang);
    }

    public static String getCurrentUserPage(String lang) {
        UserIdentity currentUser = _currentUserProvider.getUser();
        if (currentUser == null) {
            return null;
        }
        String siteName = UserXSLTHelper.site();
        List<Content> userContents = _userDirectoryHelper.getUserContents(currentUser, lang);
        for (Content content : userContents) {
            String userPage = UserXSLTHelper._getUserPage(content, siteName);
            if (userPage == null) continue;
            return userPage;
        }
        return null;
    }

    public static String getUserPage(String contentId) {
        String siteName = UserXSLTHelper.site();
        return UserXSLTHelper.getUserPage(contentId, siteName);
    }

    public static String getUserPage(String contentId, String siteName) {
        if (contentId == null) {
            return null;
        }
        try {
            Content content = (Content)_ametysObjectResolver.resolveById(contentId);
            return UserXSLTHelper._getUserPage(content, siteName);
        }
        catch (UnknownAmetysObjectException e) {
            _logger.warn("Can't find user content for id '" + contentId + "'", (Throwable)e);
            return null;
        }
    }

    private static String _getUserPage(Content content, String siteName) {
        UserPage userPage = _userDirectoryPageResolver.getUserPage(content, StringUtils.isBlank((CharSequence)siteName) ? UserXSLTHelper.site() : siteName, UserXSLTHelper.lang());
        return userPage != null ? userPage.getId() : null;
    }
}

