<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="ametys docbook">

    <xsl:import href="udorgunit.xsl"/>
    <xsl:import href="plugin:cms://stylesheets/helper/html-hierarchy.xsl"/>
    
    <xsl:variable name="common-content-css-class-name">udorgunit view-main</xsl:variable>     
    
    <xsl:template name="common-content-body-content">
    
        <xsl:variable name="raw-is-title-visible">
            <xsl:call-template name="common-content-body-title-content"/>
        </xsl:variable>
        <xsl:variable name="truelevel">
            <xsl:choose>
                <xsl:when test="string-length($raw-is-title-visible) &gt; 0">2</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>    
        
        <xsl:call-template name="orgUnit-presentation" />
        
        <xsl:call-template name="main-users">
            <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>    
        <xsl:call-template name="child-orgUnits">
             <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
        <xsl:call-template name="other-users">
             <xsl:with-param name="truelevel" select="$truelevel"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="orgUnit-presentation" >
        <xsl:call-template name="common-content-body-simpletext">
            <xsl:with-param name="css-class-name">content-abstract</xsl:with-param>
            <xsl:with-param name="text" select="metadata/abstract" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="main-users" >
        <xsl:param name="metadataSetName">abstract</xsl:param>
        <xsl:param name="truelevel"/>
        
        <xsl:if test="//users/user[@role and @metadataSetName=$metadataSetName]" >
            <div class="main-users">
	            <xsl:call-template name="main-users-title">
                    <xsl:with-param name="truelevel" select="$truelevel"/>
                </xsl:call-template>
	            <xsl:call-template name="main-users-list">
                    <xsl:with-param name="metadataSetName" select="$metadataSetName"/>
                    <xsl:with-param name="truelevel" select="$truelevel"/>
                </xsl:call-template>
	        </div>
	    </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-users-title">
        <xsl:param name="truelevel"/>
    </xsl:template>
    
    <xsl:template name="main-users-list" >
        <xsl:param name="metadataSetName">abstract</xsl:param>
        <xsl:param name="truelevel"/>
        
        <ul class="main-users-list">
            <xsl:for-each select="//users/user[@role and @metadataSetName=$metadataSetName]">
                <li>
                    <xsl:call-template name="main-user">
                        <xsl:with-param name="truelevel" select="$truelevel"/>
                    </xsl:call-template>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template name="main-user">
        <xsl:param name="truelevel"/>
        
        <div>
            <xsl:element name="h{$truelevel}"><xsl:value-of select="@role"/></xsl:element>
            <xsl:call-template name="content">
                <xsl:with-param name="content" select="content"/>
                <xsl:with-param name="level" select="$truelevel + 1"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="other-users">
        <xsl:param name="metadataSetName">link</xsl:param>
        <xsl:param name="truelevel"/>
        
        <xsl:if test="//users/user[not(@role) and @metadataSetName=$metadataSetName]" >
	        <div class="other-users">
	            <xsl:call-template name="other-users-title">
                    <xsl:with-param name="truelevel" select="$truelevel"/>
                </xsl:call-template>
	            <xsl:call-template name="other-users-list">
                    <xsl:with-param name="metadataSetName" select="$metadataSetName"/>
                    <xsl:with-param name="truelevel" select="$truelevel"/>
                </xsl:call-template>
	        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="other-users-title" >
        <xsl:param name="truelevel"/>
        <xsl:element name="h{$truelevel}">
            <span class="other-users-title"><i18n:text i18n:key="PLUGINS_USER_DIRECTORY_CONTENT_TYPE_ORGUNIT_USERS_DISPLAY_TITLE_LABEL" i18n:catalogue="plugin.user-directory"/></span>
        </xsl:element>
    </xsl:template>
    
    <xsl:template name="other-users-list" >
        <xsl:param name="metadataSetName">link</xsl:param>
        <xsl:param name="truelevel"/>
                
        <ul class="other-users-list">
            <xsl:for-each select="//users/user[not(@role) and @metadataSetName=$metadataSetName]">
                <li>
                    <xsl:attribute name="class"><xsl:call-template name="common-utils-class"/></xsl:attribute>
                    <xsl:call-template name="content">
                        <xsl:with-param name="content" select="content"/>
                        <xsl:with-param name="level" select="$truelevel + 1"/>
                    </xsl:call-template>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template name="child-orgUnits">
        <xsl:param name="truelevel"/>
        
        <xsl:if test="//orgUnits/orgUnit">
            <div class="child-orgUnits">
                <xsl:call-template name="child-orgUnits-title">
                    <xsl:with-param name="truelevel" select="$truelevel"/>
                </xsl:call-template>
                <xsl:call-template name="child-orgUnits-list">
                     <xsl:with-param name="truelevel" select="$truelevel"/>
                </xsl:call-template>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="child-orgUnits-title">
        <xsl:param name="truelevel"/>
        <xsl:element name="h{$truelevel}">
            <span class="child-orgUnit-title"><i18n:text i18n:key="PLUGINS_USER_DIRECTORY_CONTENT_TYPE_ORGUNIT_DISPLAY_TITLE_LABEL" i18n:catalogue="plugin.user-directory"/></span>
        </xsl:element>
    </xsl:template>
    
    <xsl:template name="child-orgUnits-list">
        <xsl:param name="truelevel"/>
        <ul class="child-orgUnits-list">
            <xsl:for-each select="//orgUnits/orgUnit">
                <li>
                    <xsl:attribute name="class"><xsl:call-template name="common-utils-class"/></xsl:attribute>
                    <xsl:call-template name="content">
                        <xsl:with-param name="content" select="content"/>
                        <xsl:with-param name="level" select="$truelevel + 1"/>
                    </xsl:call-template>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template name="content">
        <xsl:param name="content"/>
        <xsl:param name="level">3</xsl:param>
        
        <xsl:apply-templates select="$content/html/body/node()" mode="move-hierarchy">
            <xsl:with-param name="level" select="$level"/>
        </xsl:apply-templates>
    </xsl:template>
    
</xsl:stylesheet>