/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.observation;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.indexing.IndexingObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.indexing.solr.SolrPageIndexer;
import org.ametys.web.repository.page.Page;

/**
 * {@link Observer} for observing user directory root modification
 * in order to update Solr index
 */
public class SolrContentRootPageUpdatedObserver extends AbstractLogEnabled implements IndexingObserver, Serviceable
{
    /** The ametys object resolver. */
    protected AmetysObjectResolver _resolver;
    /** The Solr page indexer. */
    protected SolrPageIndexer _solrPageIndexer;
    
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
        _solrPageIndexer = (SolrPageIndexer) manager.lookup(SolrPageIndexer.ROLE);
    }
    
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_USER_DIRECTORY_ROOT_UPDATED)
                || event.getId().equals(ObservationConstants.EVENT_ORGANISATION_CHART_ROOT_UPDATED);
    }
    
    @Override
    public int getPriority()
    {
        return MAX_PRIORITY;
    }
    
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        Page page = (Page) event.getArguments().get(org.ametys.web.ObservationConstants.ARGS_PAGE);
        
        // Reindex page recursively
        _solrPageIndexer.reindexPage(page.getId(), true, false);
    }
}
