/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.userdirectory.workflow;

import java.util.List;
import java.util.Map;

import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper;
import org.ametys.plugins.workflow.EnhancedCondition;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;

/**
 * This OS workflow condition checks if the current content is the content of the current user
 */
public class CheckCurrentUserContentCondition implements EnhancedCondition
{
    @Override
    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException
    {
        WorkflowAwareContent content = (WorkflowAwareContent) transientVars.get(AbstractContentWorkflowComponent.CONTENT_KEY);
        
        if (content == null)
        {
            throw new WorkflowException("Unable to retrieve content from transient variables");
        }

        String language = content.getLanguage();
        List<Content> currentUserContents = UserXSLTHelper.getCurrentUserContents(language);
        
        return currentUserContents != null && currentUserContents.stream().anyMatch(contentItem -> contentItem.getId().equals(content.getId()));
    }

    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.user-directory", "PLUGINS_USER_DIRECTORY_CHECK_CURRENT_USER_CONTENT_LABEL");
    }
}
