/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.webanalytics.matomo;

import java.time.Duration;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.util.HttpUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.LambdaUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.webanalytics.matomo.MatomoException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.io.CloseMode;

public class MatomoDataHelper
extends AbstractLogEnabled
implements Component,
Initializable,
Serviceable,
Disposable {
    public static final String ROLE = MatomoDataHelper.class.getName();
    public static final String MATOMO_URL_CONFIG = "piwik-url";
    public static final String MATOMO_TOKEN_CONFIG = "matomo-token";
    public static final String MATOMO_SITE_ID_SITE_CONFIG = "piwik-id";
    private static final String __MATOMO_CACHE_LIFETIME_CONFIG = "matomo-cache-lifetime";
    private static final String __MATOMO_SITE_LIVE_STATS_CONFIG = "matomo-live-stats";
    private static final String __MATOMO_LAST_DAYS_SITE_CONFIG = "matomo-last-days";
    private static final String __MATOMO_BEGIN_YEAR_SITE_CONFIG = "matomo-begin-year";
    private static final String __CACHE_COMPUTED_VISITS = "computed-visits";
    private static final String __CACHE_LIVE_VISITS = "live-visits";
    protected AbstractCacheManager _cacheManager;
    protected JSONUtils _jsonUtils;
    private CloseableHttpClient _httpClient;
    private String _matomoServerURL;
    private String _matomoToken;

    public void service(ServiceManager manager) throws ServiceException {
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createMemoryCache(__CACHE_COMPUTED_VISITS, new I18nizableText("plugin.web-analytics", "PLUGINS_WEB_ANALTICS_CACHE_MATOMO_COMPUTED_VISITS_LABEL"), new I18nizableText("plugin.web-analytics", "PLUGINS_WEB_ANALTICS_CACHE_MATOMO_COMPUTED_VISITS_DESC"), true, Duration.ofHours(6L));
        Long cacheLifeTime = (Long)Config.getInstance().getValue(__MATOMO_CACHE_LIFETIME_CONFIG, true, (Object)5L);
        this._cacheManager.createMemoryCache(__CACHE_LIVE_VISITS, new I18nizableText("plugin.web-analytics", "PLUGINS_WEB_ANALTICS_CACHE_MATOMO_LIVE_VISITS_LABEL"), new I18nizableText("plugin.web-analytics", "PLUGINS_WEB_ANALTICS_CACHE_MATOMO_LIVE_VISITS_DESC"), true, Duration.ofMinutes(cacheLifeTime));
        this._httpClient = HttpUtils.createHttpClient((int)5, (int)5);
        this._matomoServerURL = (String)Config.getInstance().getValue(MATOMO_URL_CONFIG);
        this._matomoToken = (String)Config.getInstance().getValue(MATOMO_TOKEN_CONFIG);
    }

    private void _checkMatomoConfig(Site site) throws MatomoException {
        if (!((Boolean)site.getValue(__MATOMO_SITE_LIVE_STATS_CONFIG, true, (Object)false)).booleanValue()) {
            throw new MatomoException("Can't request the matomo stats because the site does not enable it.");
        }
        String siteId = (String)site.getValue(MATOMO_SITE_ID_SITE_CONFIG);
        if (StringUtils.isBlank((CharSequence)this._matomoServerURL) || StringUtils.isBlank((CharSequence)this._matomoToken) || StringUtils.isBlank((CharSequence)siteId)) {
            throw new MatomoException("One or more of these following parameters are empty: the matamo server URL, the matomo token or the matomo site id. Can't access to matomo data without these parameters");
        }
    }

    public long getMatomoSiteNbLastDays(Site site) {
        return (Long)site.getValue(__MATOMO_LAST_DAYS_SITE_CONFIG, true, (Object)30L);
    }

    public int getNbTotalVisits(Site site, String pageUrl) throws MatomoException {
        this._checkMatomoConfig(site);
        String siteId = (String)site.getValue(MATOMO_SITE_ID_SITE_CONFIG);
        String beginYear = (String)site.getValue(__MATOMO_BEGIN_YEAR_SITE_CONFIG);
        Integer liveVisitsOfDay = this._getLiveVisitsOfDay(siteId, pageUrl);
        Integer nbComputedVisitsToday = this._getComputedVisitsOfCurrentDay(siteId, pageUrl);
        Integer nbComputedVisitsFromLastYears = this._getComputedVisitsFromBeginYear(siteId, pageUrl, beginYear);
        return nbComputedVisitsFromLastYears - nbComputedVisitsToday + liveVisitsOfDay;
    }

    public int getNbVisitsFromLastDays(Site site, String pageUrl) throws MatomoException {
        this._checkMatomoConfig(site);
        String siteId = (String)site.getValue(MATOMO_SITE_ID_SITE_CONFIG);
        long lastDays = this.getMatomoSiteNbLastDays(site);
        Integer liveVisitsOfDay = this._getLiveVisitsOfDay(siteId, pageUrl);
        Integer computedVisitsFromLastDays = this._getComputedVisitsFromLastDays(siteId, pageUrl, lastDays);
        return computedVisitsFromLastDays + liveVisitsOfDay;
    }

    protected int _getLiveVisitsOfDay(String siteId, String pageUrl) throws MatomoException {
        StringBuilder url = new StringBuilder(this._matomoServerURL);
        url.append("/?module=API&method=Live.getLastVisitsDetails");
        url.append("&format=JSON");
        url.append("&period=day");
        url.append("&date=today");
        url.append("&idSite=");
        url.append(siteId);
        url.append("&token_auth=");
        url.append(this._matomoToken);
        try {
            List liveVisits = (List)this._getLiveVisitsCache().get((Object)siteId, LambdaUtils.wrap(k -> this._requestLiveVisitsOfDay(url.toString())));
            return this._getTodayNbVisits(liveVisits, pageUrl);
        }
        catch (LambdaUtils.LambdaException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable;
                throw re;
            }
            throwable = e.getCause();
            if (throwable instanceof MatomoException) {
                MatomoException m = (MatomoException)throwable;
                throw m;
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private List<Map<String, Object>> _requestLiveVisitsOfDay(String url) throws MatomoException {
        return (List)this._executeMatomoRequest(url, "list");
    }

    protected int _getComputedVisitsFromBeginYear(String siteId, String pageUrl, String beginYear) throws MatomoException {
        String truncateURL = this._truncateURL(pageUrl);
        LocalDate beginDate = LocalDate.of((int)Integer.valueOf(beginYear), 1, 1);
        LocalDate now = LocalDate.now();
        int nbYear = now.getYear() - beginDate.getYear() + 1;
        StringBuilder url = new StringBuilder(this._matomoServerURL);
        url.append("/?module=API&method=Actions.getPageUrl");
        url.append("&format=JSON");
        url.append("&period=month");
        url.append("&date=last");
        url.append(nbYear * 12);
        url.append("&idSite=");
        url.append(siteId);
        url.append("&pageUrl=");
        url.append(URIUtils.encodeParameter((String)truncateURL));
        url.append("&token_auth=");
        url.append(this._matomoToken);
        try {
            MatomoComputedCacheKey key = MatomoComputedCacheKey.of(RequestType.BEGIN_YEAR, truncateURL);
            return (Integer)this._getComputedVisitsCache().get((Object)key, LambdaUtils.wrap(k -> this._requestComputedVisitsFromBeginYear(url.toString())));
        }
        catch (LambdaUtils.LambdaException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable;
                throw re;
            }
            throwable = e.getCause();
            if (throwable instanceof MatomoException) {
                MatomoException m = (MatomoException)throwable;
                throw m;
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private Integer _requestComputedVisitsFromBeginYear(String url) throws MatomoException {
        Map json = (Map)this._executeMatomoRequest(url, "map");
        return this._getNbVisitsFromMap(json);
    }

    protected int _getComputedVisitsOfCurrentDay(String siteId, String pageUrl) throws MatomoException {
        String truncateURL = this._truncateURL(pageUrl);
        StringBuilder url = new StringBuilder(this._matomoServerURL);
        url.append("/?module=API&method=Actions.getPageUrl");
        url.append("&format=JSON");
        url.append("&period=day");
        url.append("&date=today");
        url.append("&idSite=");
        url.append(siteId);
        url.append("&pageUrl=");
        url.append(URIUtils.encodeParameter((String)truncateURL));
        url.append("&token_auth=");
        url.append(this._matomoToken);
        try {
            MatomoComputedCacheKey key = MatomoComputedCacheKey.of(RequestType.CURRENT_DAY, truncateURL);
            return (Integer)this._getComputedVisitsCache().get((Object)key, LambdaUtils.wrap(k -> this._requestComputedVisitsOfCurrentDay(url.toString())));
        }
        catch (LambdaUtils.LambdaException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable;
                throw re;
            }
            throwable = e.getCause();
            if (throwable instanceof MatomoException) {
                MatomoException m = (MatomoException)throwable;
                throw m;
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private Integer _requestComputedVisitsOfCurrentDay(String url) throws MatomoException {
        List json = (List)this._executeMatomoRequest(url, "list");
        return this._getNbVisitsFromList(json);
    }

    protected int _getComputedVisitsFromLastDays(String siteId, String pageUrl, long nbDay) throws MatomoException {
        String truncateURL = this._truncateURL(pageUrl);
        StringBuilder url = new StringBuilder(this._matomoServerURL);
        url.append("/?module=API&method=Actions.getPageUrl");
        url.append("&format=JSON");
        url.append("&period=day");
        url.append("&date=previous");
        url.append(nbDay);
        url.append("&idSite=");
        url.append(siteId);
        url.append("&pageUrl=");
        url.append(URIUtils.encodeParameter((String)truncateURL));
        url.append("&token_auth=");
        url.append(this._matomoToken);
        try {
            MatomoComputedCacheKey key = MatomoComputedCacheKey.of(RequestType.LAST_DAYS, truncateURL);
            return (Integer)this._getComputedVisitsCache().get((Object)key, LambdaUtils.wrap(k -> this._requestComputedVisitsFromLastDays(url.toString())));
        }
        catch (LambdaUtils.LambdaException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable;
                throw re;
            }
            throwable = e.getCause();
            if (throwable instanceof MatomoException) {
                MatomoException m = (MatomoException)throwable;
                throw m;
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private Integer _requestComputedVisitsFromLastDays(String url) throws MatomoException {
        Map json = (Map)this._executeMatomoRequest(url, "map");
        return this._getNbVisitsFromMap(json);
    }

    private Object _executeMatomoRequest(String matomoUrl, String returnType) throws MatomoException {
        try {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("A request is send to Matomo with url '" + matomoUrl + "'");
            }
            HttpPost post = new HttpPost(matomoUrl);
            return this._httpClient.execute((ClassicHttpRequest)post, httpResponse -> {
                if (httpResponse.getCode() != 200) {
                    throw new IllegalStateException("Could not join matomo for URL " + matomoUrl + ". Error code " + httpResponse.getCode());
                }
                if ("map".equals(returnType)) {
                    return this._jsonUtils.convertJsonToMap(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
                }
                if ("list".equals(returnType)) {
                    return this._jsonUtils.convertJsonToList(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
                }
                throw new IllegalArgumentException("Invalid return type for request with url '" + matomoUrl + "'");
            });
        }
        catch (Exception e) {
            throw new MatomoException("An error occurred requesting Matomo for url '" + matomoUrl + "'", e);
        }
    }

    private int _getNbVisitsFromMap(Map<String, Object> jsonAsMap) {
        int nbVisits = 0;
        for (String key : jsonAsMap.keySet()) {
            nbVisits += this._getNbVisitsFromList((List)jsonAsMap.get(key));
        }
        return nbVisits;
    }

    private int _getNbVisitsFromList(List<Map<String, Object>> data) {
        if (!data.isEmpty()) {
            return (Integer)data.get(0).getOrDefault("nb_visits", 0);
        }
        return 0;
    }

    private int _getTodayNbVisits(List<Map<String, Object>> jsonAsMap, String pageUrl) {
        int nbVisits = 0;
        if (!jsonAsMap.isEmpty()) {
            String truncateURL = this._truncateURL(pageUrl);
            LocalDate today = LocalDate.now();
            for (Map<String, Object> visitInfo : jsonAsMap) {
                List actions;
                Optional<String> pageVisits;
                String visitDateAsString = (String)visitInfo.get("serverDate");
                LocalDate visitDate = LocalDate.parse(visitDateAsString);
                if (!visitDate.equals(today) || !(pageVisits = (actions = (List)visitInfo.get("actionDetails")).stream().map(a -> (String)a.get("url")).map(this::_truncateURL).filter(url -> truncateURL.equals(url)).findAny()).isPresent()) continue;
                ++nbVisits;
            }
        }
        return nbVisits;
    }

    protected String _truncateURL(String pageUrl) {
        return StringUtils.substringBefore((String)StringUtils.substringBefore((String)pageUrl, (String)"?"), (String)"#");
    }

    private Cache<MatomoComputedCacheKey, Integer> _getComputedVisitsCache() {
        return this._cacheManager.get(__CACHE_COMPUTED_VISITS);
    }

    private Cache<String, List<Map<String, Object>>> _getLiveVisitsCache() {
        return this._cacheManager.get(__CACHE_LIVE_VISITS);
    }

    public void dispose() {
        this._httpClient.close(CloseMode.GRACEFUL);
    }

    private static enum RequestType {
        BEGIN_YEAR,
        CURRENT_DAY,
        LAST_DAYS;

    }

    private static final class MatomoComputedCacheKey
    extends AbstractCacheKey {
        public MatomoComputedCacheKey(RequestType type, String pageUrl) {
            super(new Object[]{type, pageUrl});
        }

        public static MatomoComputedCacheKey of(RequestType type, String pageUrl) {
            return new MatomoComputedCacheKey(type, pageUrl);
        }
    }
}

