<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
    extension-element-prefixes="ametys escaper">
    
    <xsl:template name="google-analytics">
        <xsl:variable name="webId" select="ametys:siteParameter('google-web-property-id')"/>
        
        <!-- Do not call GA on back or preview -->
        <xsl:if test="ametys:renderingContext() = 'front' and normalize-space($webId) != ''">
            <script type="text/javascript">
                
                ametysCookieConsentListener.push(function(accept) {
	                var gaProperty = '<xsl:value-of select="escaper:escapeJavaScript($webId)"/>';
                    if (accept)
                    {
                        var a = document.createElement('script');
                        var m = document.getElementsByTagName('script')[0];
                        a.async = 1;
                        a.src = 'https://www.googletagmanager.com/gtag/js?id=' + gaProperty;
                        m.parentNode.insertBefore(a, m);
     
                        window.dataLayer = window.dataLayer || [];
                        function gtag(){dataLayer.push(arguments);}
                        gtag('js', new Date());
                        gtag('config', gaProperty);
                    }
                    else
                    {                    
                        function getDomains()
                        {
                            var domains = [];
                            var fullDomain = document.location.hostname;
                            domains.push(fullDomain);

                            var splitDomain = fullDomain.split('.');
                            while (splitDomain.length > 2)
                            {
                                // Add domain with '.' before
                                fullDomain = fullDomain.substr(fullDomain.indexOf("."), fullDomain.length);
                                domains.push(fullDomain);
                                
                                // Add domain without the '.' before
                                fullDomain = fullDomain.substr(1, fullDomain.length);
                                domains.push(fullDomain);
                                
                                // Substring to next '.'
                                splitDomain = fullDomain.substr(1, fullDomain.length).split('.');
                            }
                            
                            return domains;
                        }
                        
                        var domains = getDomains();

                        // Delete Google Analytics cookies    
                        var cookieNames = ["__utma","__utmb","__utmc","__utmt","__utmv","__utmz","_ga","_gat","_gid", "_gat_gtag"];
                        var gaId = gaProperty.replaceAll("-", "_");
                        var allCookies = [];
                        for (var k=0; k&lt;cookieNames.length; k++)
                        {
                            allCookies.push(cookieNames[k])
                            if (gaId.startsWith("G_"))
                            {
                                allCookies.push(cookieNames[k] + "_" + gaId.substring(2))
                            }
                            else
                            {
                                allCookies.push(cookieNames[k] + "_" + gaId);                    
                            }   
                        }
                        
                        for (var i=0; i&lt;allCookies.length; i++)
                        {
                            for (var j=0; j&lt;domains.length; j++)
                            {
                                // GA seems to store always on path '/'
	                            $j.removeCookie(allCookies[i], { path: '/', domain : domains[j]});
                            }
                        }
                    }
                });
            </script>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
