/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.documents;

import java.util.Date;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.workspaces.activities.documents.ResourceCreatedOrUpdatedActivityType;
import org.apache.commons.lang3.StringUtils;

public class DocumentCommentedActivityType
extends ResourceCreatedOrUpdatedActivityType {
    public static final String LAST_MODIFIED = "lastModified";
    public static final String LAST_CONTRIBUTOR = "lastContributor";
    public static final String COMMENT_SUMMARY = "commentSummary";

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        String resourceId = (String)parameters.get("object.id");
        Resource resource = (Resource)this._resolver.resolveById(resourceId);
        activity.setValue(LAST_CONTRIBUTOR, (Object)resource.getLastContributor(), "user");
        activity.setValue(LAST_MODIFIED, (Object)DateUtils.asZonedDateTime((Date)resource.getLastModified()), "datetime");
        String comment = (String)parameters.get("fileComment");
        activity.setValue(COMMENT_SUMMARY, (Object)StringUtils.abbreviate((String)comment, (String)"\u2026", (int)150));
    }

    @Override
    public boolean isMergeable(Activity activity1, Activity activity2) {
        return false;
    }
}

