/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars.task;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.messagingconnector.EventRecurrenceTypeEnum;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventOccurrence;
import org.ametys.plugins.workspaces.tasks.Task;

public class TaskCalendarEvent
implements CalendarEvent {
    private Calendar _calendar;
    private Task _task;

    public TaskCalendarEvent(Calendar calendar, Task task) {
        this._calendar = calendar;
        this._task = task;
    }

    public Task getTask() {
        return this._task;
    }

    public void tag(String tag) throws AmetysRepositoryException {
        throw new UnsupportedOperationException("Can't call method #tag for a TaskCalendarEvent");
    }

    public void untag(String tag) throws AmetysRepositoryException {
        throw new UnsupportedOperationException("Can't call method #untag for a TaskCalendarEvent");
    }

    public Set<String> getTags() throws AmetysRepositoryException {
        return this._task.getTags();
    }

    public String getName() throws AmetysRepositoryException {
        return this._task.getName();
    }

    public String getPath() throws AmetysRepositoryException {
        return this._task.getPath();
    }

    public String getId() throws AmetysRepositoryException {
        return this._task.getId();
    }

    public <A extends AmetysObject> A getParent() throws AmetysRepositoryException {
        return (A)this._task.getParent();
    }

    public String getParentPath() throws AmetysRepositoryException {
        return this._task.getParentPath();
    }

    @Override
    public Calendar getCalendar() {
        return this._calendar;
    }

    @Override
    public String getTitle() {
        return this._task.getLabel();
    }

    @Override
    public String getDescription() {
        return this._task.getDescription();
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public ZonedDateTime getStartDate() {
        LocalDate date = this._task.getStartDate() != null ? this._task.getStartDate() : this._task.getDueDate();
        return DateUtils.asZonedDateTime((LocalDate)date, (ZoneId)this.getZone());
    }

    @Override
    public ZonedDateTime getEndDate() {
        LocalDate date = this._task.getDueDate() != null ? this._task.getDueDate() : this._task.getStartDate();
        return DateUtils.asZonedDateTime((LocalDate)date, (ZoneId)this.getZone());
    }

    @Override
    public ZoneId getZone() {
        return ZoneId.systemDefault();
    }

    @Override
    public Boolean getFullDay() {
        return true;
    }

    @Override
    public UserIdentity getCreator() {
        return this._task.getAuthor();
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return this._task.getCreationDate();
    }

    @Override
    public UserIdentity getLastContributor() {
        return this._task.getAuthor();
    }

    @Override
    public ZonedDateTime getLastModified() {
        return this._task.getLastModified();
    }

    @Override
    public EventRecurrenceTypeEnum getRecurrenceType() {
        return EventRecurrenceTypeEnum.NEVER;
    }

    @Override
    public Boolean isRecurrent() {
        return false;
    }

    @Override
    public ZonedDateTime getRepeatUntil() {
        return null;
    }

    @Override
    public List<ZonedDateTime> getExcludedOccurences() {
        return List.of();
    }

    @Override
    public List<CalendarEventOccurrence> getOccurrences(ZonedDateTime startDate, ZonedDateTime endDate) {
        Optional<CalendarEventOccurrence> optionalEvent = this.getFirstOccurrence(startDate);
        return optionalEvent.isPresent() && optionalEvent.get().getStartDate().isBefore(endDate) ? List.of(optionalEvent.get()) : List.of();
    }

    @Override
    public Optional<CalendarEventOccurrence> getFirstOccurrence(ZonedDateTime date) {
        ZonedDateTime eventStartDate = this.getStartDate();
        ZonedDateTime eventEndDate = this.getEndDate();
        if (this.getFullDay().booleanValue()) {
            eventEndDate = eventEndDate.plusDays(1L);
        }
        return eventEndDate.isAfter(date) || eventEndDate.isEqual(date) ? Optional.of(new CalendarEventOccurrence(this, eventStartDate)) : Optional.empty();
    }

    @Override
    public Optional<CalendarEventOccurrence> getNextOccurrence(CalendarEventOccurrence occurrence) {
        return Optional.empty();
    }

    @Override
    public UserIdentity getOrganiser() {
        return this._task.getAuthor();
    }

    @Override
    public List<String> getResources() {
        return List.of(this._calendar.getId());
    }
}

