/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.cmis;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;

public class CmisContentRangeInputStream
extends FilterInputStream {
    private static final int BUFFER_SIZE = 4096;
    private long _offset;
    private long _length;
    private long _remaining;

    public CmisContentRangeInputStream(InputStream stream, BigInteger offset, BigInteger length) {
        super(stream);
        this._offset = offset != null ? offset.longValue() : 0L;
        this._remaining = this._length = length != null ? length.longValue() : Long.MAX_VALUE;
        if (this._offset > 0L) {
            this.skipBytes();
        }
    }

    private void skipBytes() {
        try {
            long skipped;
            for (long remainingSkipBytes = this._offset; remainingSkipBytes > 0L; remainingSkipBytes -= skipped) {
                skipped = super.skip(remainingSkipBytes);
                if (skipped != 0L) continue;
                this.skipBytesByReading(remainingSkipBytes);
                break;
            }
        }
        catch (IOException e) {
            throw new CmisRuntimeException("Skipping the stream failed!", (Throwable)e);
        }
    }

    private void skipBytesByReading(long remainingSkipBytes) {
        try {
            long skipped;
            byte[] buffer = new byte[4096];
            for (long usedRemainingSkipBytes = remainingSkipBytes; usedRemainingSkipBytes > 0L && (skipped = (long)super.read(buffer, 0, (int)Math.min((long)buffer.length, usedRemainingSkipBytes))) != -1L; usedRemainingSkipBytes -= skipped) {
            }
        }
        catch (IOException e) {
            throw new CmisRuntimeException("Reading the stream failed!", (Throwable)e);
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this._remaining <= 0L) {
            return 0L;
        }
        long skipped = super.skip(n);
        this._remaining -= skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        if (this._remaining <= 0L) {
            return 0;
        }
        int avail = super.available();
        if (this._remaining < (long)avail) {
            return (int)this._remaining;
        }
        return avail;
    }

    @Override
    public int read() throws IOException {
        if (this._remaining <= 0L) {
            return -1;
        }
        --this._remaining;
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this._remaining <= 0L) {
            return -1;
        }
        int readBytes = super.read(b, off, (int)Math.min((long)len, this._remaining));
        if (readBytes == -1) {
            return -1;
        }
        this._remaining -= (long)readBytes;
        return readBytes;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

