/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.cmis;

import org.ametys.core.authentication.token.AuthenticationTokenManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.explorer.resources.actions.AddOrUpdateResourceHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.cmis.CmisServiceImpl;
import org.ametys.plugins.workspaces.cmis.CmisTypeManager;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.documents.WorkspaceExplorerResourceDAO;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.excalibur.source.SourceResolver;

public class CmisServiceFactory
extends AbstractServiceFactory
implements Component,
Serviceable {
    public static final String ROLE = CmisServiceFactory.class.getName();
    private ProjectManager _projectManager;
    private WorkspaceExplorerResourceDAO _workspaceExplorerResourceDAO;
    private DocumentWorkspaceModule _documentModule;
    private AmetysObjectResolver _resolver;
    private CmisTypeManager _typeManager;
    private UserManager _userManager;
    private AuthenticationTokenManager _authenticationTokenManager;
    private SourceResolver _sourceResolver;
    private CurrentUserProvider _currentUserProvider;
    private SiteManager _siteManager;
    private AddOrUpdateResourceHelper _addOrUpdateResourceHelper;

    public CmisService getService(CallContext context) {
        return new CmisServiceImpl(context, this);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._workspaceExplorerResourceDAO = (WorkspaceExplorerResourceDAO)((Object)manager.lookup(WorkspaceExplorerResourceDAO.ROLE));
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._documentModule = (DocumentWorkspaceModule)moduleManagerEP.getModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID);
        this._authenticationTokenManager = (AuthenticationTokenManager)manager.lookup(AuthenticationTokenManager.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._addOrUpdateResourceHelper = (AddOrUpdateResourceHelper)manager.lookup(AddOrUpdateResourceHelper.ROLE);
        this._typeManager = new CmisTypeManager();
    }

    public ProjectManager getProjectManager() {
        return this._projectManager;
    }

    public WorkspaceExplorerResourceDAO getWorkspaceExplorerResourceDAO() {
        return this._workspaceExplorerResourceDAO;
    }

    public AmetysObjectResolver getResolver() {
        return this._resolver;
    }

    public CmisTypeManager getTypeManager() {
        return this._typeManager;
    }

    public UserManager getUserManager() {
        return this._userManager;
    }

    public AuthenticationTokenManager getAuthenticationTokenManager() {
        return this._authenticationTokenManager;
    }

    public SourceResolver getSourceResolver() {
        return this._sourceResolver;
    }

    public CurrentUserProvider getCurrentUserProvider() {
        return this._currentUserProvider;
    }

    public SiteManager getSiteManager() {
        return this._siteManager;
    }

    public DocumentWorkspaceModule getDocumentModule() {
        return this._documentModule;
    }

    public AddOrUpdateResourceHelper getAddOrUpdateResourceHelper() {
        return this._addOrUpdateResourceHelper;
    }
}

