/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.cmis;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.MutableDocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableFolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutablePropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.server.support.TypeDefinitionFactory;

public class CmisTypeManager {
    private static final String NAMESPACE = "http://ametysorg/opencmis";
    private final TypeDefinitionFactory _typeDefinitionFactory = TypeDefinitionFactory.newInstance();
    private final Map<String, TypeDefinition> _typeDefinitions;

    public CmisTypeManager() {
        this._typeDefinitionFactory.setDefaultNamespace(NAMESPACE);
        this._typeDefinitionFactory.setDefaultControllableAcl(false);
        this._typeDefinitionFactory.setDefaultControllablePolicy(false);
        this._typeDefinitionFactory.setDefaultQueryable(false);
        this._typeDefinitionFactory.setDefaultFulltextIndexed(false);
        this._typeDefinitionFactory.setDefaultTypeMutability(this._typeDefinitionFactory.createTypeMutability(false, false, false));
        this._typeDefinitions = new HashMap<String, TypeDefinition>();
        MutableFolderTypeDefinition folderType = this._typeDefinitionFactory.createBaseFolderTypeDefinition(CmisVersion.CMIS_1_1);
        this.removeQueryableAndOrderableFlags((MutableTypeDefinition)folderType);
        this._typeDefinitions.put(folderType.getId(), (TypeDefinition)folderType);
        MutableDocumentTypeDefinition documentType = this._typeDefinitionFactory.createBaseDocumentTypeDefinition(CmisVersion.CMIS_1_1);
        this.removeQueryableAndOrderableFlags((MutableTypeDefinition)documentType);
        this._typeDefinitions.put(documentType.getId(), (TypeDefinition)documentType);
    }

    private void removeQueryableAndOrderableFlags(MutableTypeDefinition type) {
        for (PropertyDefinition propDef : type.getPropertyDefinitions().values()) {
            MutablePropertyDefinition mutablePropDef = (MutablePropertyDefinition)propDef;
            mutablePropDef.setIsQueryable(Boolean.valueOf(false));
            mutablePropDef.setIsOrderable(Boolean.valueOf(false));
        }
    }

    public synchronized TypeDefinition getInternalTypeDefinition(String typeId) {
        return this._typeDefinitions.get(typeId);
    }

    public TypeDefinition getTypeDefinition(CallContext context, String typeId) {
        TypeDefinition type = this._typeDefinitions.get(typeId);
        if (type == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        return this._typeDefinitionFactory.copy(type, true, context.getCmisVersion());
    }

    public TypeDefinitionList getTypeChildren(CallContext context, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount) {
        return this._typeDefinitionFactory.createTypeDefinitionList(this._typeDefinitions, typeId, includePropertyDefinitions, maxItems, skipCount, context.getCmisVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (TypeDefinition type : this._typeDefinitions.values()) {
            sb.append('[');
            sb.append(type.getId());
            sb.append(" (");
            sb.append(type.getBaseTypeId().value());
            sb.append(")]");
        }
        return sb.toString();
    }
}

