/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.cmis;

import java.util.HashSet;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;

public final class CmisUtils {
    private CmisUtils() {
    }

    public static boolean getBooleanParameter(Boolean value, boolean def) {
        if (value == null) {
            return def;
        }
        return value;
    }

    public static String getStringProperty(Properties properties, String name) {
        return CmisUtils.getStringProperty(properties, name, null);
    }

    public static String getStringProperty(Properties properties, String name, String defaultValue) {
        PropertyData property = (PropertyData)properties.getProperties().get(name);
        if (!(property instanceof PropertyString)) {
            return defaultValue;
        }
        return (String)((PropertyString)property).getFirstValue();
    }

    public static String getObjectTypeId(Properties properties) {
        PropertyData typeProperty = (PropertyData)properties.getProperties().get("cmis:objectTypeId");
        if (!(typeProperty instanceof PropertyId)) {
            throw new CmisInvalidArgumentException("Type Id must be set!");
        }
        String typeId = (String)((PropertyId)typeProperty).getFirstValue();
        if (typeId == null) {
            throw new CmisInvalidArgumentException("Type Id must be set!");
        }
        return typeId;
    }

    public static Set<String> splitFilter(String filter) {
        if (filter == null || filter.trim().length() == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (String s : filter.split(",")) {
            String trimmed = s.trim();
            if (trimmed.equals("*") || trimmed.equals("cmis:none")) {
                return null;
            }
            if (trimmed.length() <= 0) continue;
            result.add(trimmed);
        }
        result.add("cmis:objectId");
        result.add("cmis:objectTypeId");
        result.add("cmis:baseTypeId");
        return result;
    }
}

