/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.comments;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.cms.repository.mentions.AbstractNotifyMentionsObserver;
import org.ametys.cms.repository.mentions.MentionUtils;
import org.ametys.core.observation.Event;
import org.ametys.core.user.User;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.workspaces.comments.AbstractNotifyWorkspacesCommentMentionsObserver;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tasks.Task;
import org.ametys.plugins.workspaces.tasks.TasksWorkspaceModule;
import org.ametys.runtime.i18n.I18nizableText;

public class NotifyTaskCommentMentionsObserver
extends AbstractNotifyWorkspacesCommentMentionsObserver<Task> {
    public boolean supports(Event event) {
        return event.getId().equals("task.commented");
    }

    protected String _getAmetysObjectTitle(Task task) {
        return task.getLabel();
    }

    protected AbstractNotifyMentionsObserver.MentionableObject _getMentionableObjectFromArguments(Map<String, Object> arguments) throws Exception {
        Task task = (Task)this._getAmetysObjectFromArguments(arguments);
        String commentId = (String)arguments.get("taskCommentId");
        Comment comment = (Comment)task.getComment(commentId);
        Project project = this._projectManager.getParentProject((AmetysObject)task);
        String url = this._getAbsoluteUrl(task, project);
        return new AbstractNotifyMentionsObserver.MentionableObject(this._userManager.getUser(comment.getAuthor()), comment.getContent(), (Collection)MentionUtils.extractMentionedUsersFromSimpleText((String)comment.getContent()), comment.getCreationDate(), (AmetysObject)task, new AbstractNotifyMentionsObserver.LinkToAmetysObject(url, new I18nizableText("plugin.workspaces", "PROJECT_MAIL_NOTIFICATION_BODY_TASK_BUTTON_TEXT")), this._getLanguage(project));
    }

    protected I18nizableText _getMailMessage(AbstractNotifyMentionsObserver.MentionableObject mentionableObject) {
        Task task = (Task)mentionableObject.ametysObject();
        User author = mentionableObject.author();
        Project project = this._projectManager.getParentProject((AmetysObject)task);
        List<String> i18nParams = List.of(author.getFullName(), this._getAmetysObjectTitle(task), project.getTitle());
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_TASK_MENTION_MAIL_MESSAGE", i18nParams);
    }

    @Override
    protected String _getModuleId() {
        return TasksWorkspaceModule.TASK_MODULE_ID;
    }

    @Override
    protected String getUrl(Task task, Project project) {
        return this._taskModule.getTaskUri(project, task.getId());
    }
}

