/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.dav;

import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObject;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.reading.AbstractReader;
import org.xml.sax.SAXException;

public class WebdavHeadReader
extends AbstractReader {
    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        AmetysObject object = (AmetysObject)request.getAttribute("resource");
        Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            response.setHeader("Content-Length", String.valueOf(resource.getLength()));
            response.setHeader("Content-Type", resource.getMimeType());
            String lastModified = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(TimeZone.getTimeZone("GMT").toZoneId()).format(DateUtils.asZonedDateTime((Date)resource.getLastModified(), (ZoneId)ZoneId.systemDefault()));
            response.setHeader("Last-Modified", lastModified);
            response.setHeader("ETag", resource.getLastModified().toString());
        }
    }
}

