/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.dav;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WebdavPropfindGenerator
extends AbstractGenerator {
    public static final String WEBDAV_NAMESPACE = "DAV:";
    public static final int DEFAULT_DEPTH_ALLPROP = 1;
    public static final int DEFAULT_DEPTH_NO_RECURSION = 0;
    private static final List<Pair<String, String>> __DEFAULT_PROPS_RESOURCE = Arrays.asList(Pair.of((Object)"DAV:", (Object)"creationdate"), Pair.of((Object)"DAV:", (Object)"getlastmodified"), Pair.of((Object)"DAV:", (Object)"getcontentlength"), Pair.of((Object)"DAV:", (Object)"displayname"), Pair.of((Object)"DAV:", (Object)"contenttype"), Pair.of((Object)"DAV:", (Object)"resourcetype"));
    private static final List<Pair<String, String>> __DEFAULT_PROPS_COLLECTION = Arrays.asList(Pair.of((Object)"DAV:", (Object)"displayname"), Pair.of((Object)"DAV:", (Object)"resourcetype"));

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        AmetysObject resource = (AmetysObject)request.getAttribute("resource");
        HttpServletRequest httpRequest = (HttpServletRequest)this.objectModel.get("httprequest");
        Document document = null;
        try (ServletInputStream is = httpRequest.getInputStream();){
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            document = documentBuilderFactory.newDocumentBuilder().parse((InputStream)is);
        }
        catch (ParserConfigurationException e) {
            throw new ProcessingException((Exception)e);
        }
        Element propfindRoot = document.getDocumentElement();
        Element propfindRequest = this._getFirstChildElement(propfindRoot);
        String requestName = propfindRequest.getLocalName();
        PropfindType type = PropfindType.valueOf(requestName.toUpperCase());
        List<Pair<String, String>> props = null;
        if (type == PropfindType.PROP) {
            props = this._getProps(propfindRequest);
        }
        Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
        response.setHeader("Content-Type", "application/xml; charset=utf-8");
        HttpServletResponse httpResponse = (HttpServletResponse)this.objectModel.get("httpresponse");
        httpResponse.setStatus(207);
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("d", WEBDAV_NAMESPACE);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:multistatus");
        if (resource instanceof Resource) {
            this._processResource((Resource)resource, type, props);
        } else if (resource instanceof ResourceCollection) {
            int maxDepth = type == PropfindType.ALLPROP ? 1 : 0;
            try {
                String depthHeader = httpRequest.getHeader("Depth");
                if (!StringUtils.isEmpty((CharSequence)depthHeader)) {
                    maxDepth = Integer.parseInt(depthHeader);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this._processCollection((ResourceCollection)resource, 0, maxDepth, type, props);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:multistatus");
        this.contentHandler.endDocument();
    }

    private Element _getFirstChildElement(Element element) {
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        throw new IllegalArgumentException("Unrecognized propfind request");
    }

    private void _processResource(Resource resource, PropfindType type, List<Pair<String, String>> props) throws SAXException {
        String href = ResolveURIComponent.resolve((String)"webdav-project-resource", (String)resource.getId(), (boolean)false, (boolean)true);
        this._startResponseNode(href);
        this._startPropstatNode();
        List<Pair<String, String>> actualProps = props;
        if (type == PropfindType.PROPNAME) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:creationdate");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:getlastmodified");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:getcontentlength");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:getcontenttype");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:resourcetype");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:supportedlock");
            this._endPropstatNode("HTTP/1.1 200 OK");
            this._endResponseNode();
            return;
        }
        if (type == PropfindType.ALLPROP) {
            actualProps = __DEFAULT_PROPS_RESOURCE;
        }
        ArrayList<Pair<String, String>> notFound = new ArrayList<Pair<String, String>>();
        for (Pair<String, String> prop : actualProps) {
            String name;
            String namespace = (String)prop.getLeft();
            boolean found = this._processProperty(namespace, name = (String)prop.getRight(), resource, href);
            if (found) continue;
            notFound.add(prop);
        }
        this._endPropstatNode("HTTP/1.1 200 OK");
        this._notFoundPropstatNode(notFound);
        this._endResponseNode();
    }

    private boolean _processProperty(String namespace, String name, Resource resource, String href) throws SAXException {
        boolean found = false;
        if (namespace.equals(WEBDAV_NAMESPACE)) {
            if (name.equals("creationdate")) {
                String lastModified = DateTimeFormatter.ISO_INSTANT.format(DateUtils.asInstant((Date)resource.getLastModified()));
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:creationdate", (String)lastModified);
                found = true;
            } else if (name.equals("getlastmodified")) {
                String lastModified = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(TimeZone.getTimeZone("GMT").toZoneId()).format(DateUtils.asZonedDateTime((Date)resource.getLastModified(), (ZoneId)ZoneId.systemDefault()));
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:getlastmodified", (String)lastModified);
                found = true;
            } else if (name.equals("getcontentlength")) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:getcontentlength", (String)String.valueOf(resource.getLength()));
                found = true;
            } else if (name.equals("displayname")) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:displayname", (String)resource.getName());
                found = true;
            } else if (name.equals("contenttype")) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:contenttype", (String)resource.getMimeType());
                found = true;
            } else if (name.equals("getcontenttype")) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:getcontenttype", (String)resource.getMimeType());
                found = true;
            } else if (name.equals("resourcetype")) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:resourcetype");
                found = true;
            } else if (name.equals("supportedlock")) {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:supportedlock");
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:lockentry");
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:lockscope");
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:exclusive");
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:lockscope");
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:locktype");
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:write");
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:locktype");
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:lockentry");
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:supportedlock");
                found = true;
            }
        } else if (namespace.equals("http://ucb.openoffice.org/dav/props/")) {
            if (name.equals("IsReadOnly")) {
                this.contentHandler.startPrefixMapping("o", "http://ucb.openoffice.org/dav/props/");
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"o:IsReadOnly", (String)"false");
                this.contentHandler.endPrefixMapping("o");
                found = true;
            } else if (name.equals("BaseURI")) {
                this.contentHandler.startPrefixMapping("o", "http://ucb.openoffice.org/dav/props/");
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"o:BaseURI", (String)href);
                this.contentHandler.endPrefixMapping("o");
                found = true;
            } else if (name.equals("ObjectId")) {
                this.contentHandler.startPrefixMapping("o", "http://ucb.openoffice.org/dav/props/");
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"o:ObjectId", (String)resource.getId());
                this.contentHandler.endPrefixMapping("o");
                found = true;
            }
        }
        return found;
    }

    private void _processCollection(ResourceCollection resource, int currentDepth, int maxDepth, PropfindType type, List<Pair<String, String>> props) throws SAXException {
        String href = ResolveURIComponent.resolve((String)"webdav-project-resource", (String)resource.getId(), (boolean)false, (boolean)true) + "/";
        this._startResponseNode(href);
        this._startPropstatNode();
        List<Pair<String, String>> actualProps = props;
        if (type == PropfindType.PROPNAME) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:displayname");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:resourcetype");
            this._endPropstatNode("HTTP/1.1 200 OK");
            this._endResponseNode();
            return;
        }
        if (type == PropfindType.ALLPROP) {
            actualProps = __DEFAULT_PROPS_COLLECTION;
        }
        ArrayList<Pair<String, String>> notFound = new ArrayList<Pair<String, String>>();
        for (Pair<String, String> prop : actualProps) {
            String namespace = (String)prop.getLeft();
            String name = (String)prop.getRight();
            boolean found = false;
            if (namespace.equals(WEBDAV_NAMESPACE)) {
                if (name.equals("displayname")) {
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:displayname", (String)resource.getName());
                    found = true;
                } else if (name.equals("resourcetype")) {
                    XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:resourcetype");
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:collection");
                    XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:resourcetype");
                    found = true;
                }
            }
            if (found) continue;
            notFound.add(prop);
        }
        this._endPropstatNode("HTTP/1.1 200 OK");
        this._notFoundPropstatNode(notFound);
        this._endResponseNode();
        if (currentDepth < maxDepth) {
            for (AmetysObject child : resource.getChildren()) {
                if (child instanceof Resource) {
                    this._processResource((Resource)child, type, props);
                    continue;
                }
                if (!(child instanceof ResourceCollection)) continue;
                this._processCollection((ResourceCollection)child, currentDepth + 1, maxDepth, type, props);
            }
        }
    }

    private void _startResponseNode(String href) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:response");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:href", (String)href);
    }

    private void _startPropstatNode() throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:propstat");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:prop");
    }

    private void _endResponseNode() throws SAXException {
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:response");
    }

    private void _endPropstatNode(String status) throws SAXException {
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:prop");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:status", (String)status);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:propstat");
    }

    private void _notFoundPropstatNode(List<Pair<String, String>> notFound) throws SAXException {
        if (notFound != null && !notFound.isEmpty()) {
            this._startPropstatNode();
            for (Pair<String, String> prop : notFound) {
                String namespace = (String)prop.getLeft();
                String name = (String)prop.getRight();
                this.contentHandler.startPrefixMapping("", namespace);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)name);
                this.contentHandler.endPrefixMapping("");
            }
            this._endPropstatNode("HTTP/1.1 404 Not Found");
        }
    }

    private List<Pair<String, String>> _getProps(Element props) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        NodeList propNames = props.getChildNodes();
        for (int j = 0; j < propNames.getLength(); ++j) {
            Node propName = propNames.item(j);
            if (propName.getNodeType() != 1) continue;
            result.add((Pair<String, String>)Pair.of((Object)propName.getNamespaceURI(), (Object)propName.getLocalName()));
        }
        return result;
    }

    private static enum PropfindType {
        PROP,
        ALLPROP,
        PROPNAME;

    }
}

