/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.jcr;

import java.time.ZonedDateTime;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.cms.repository.CommentableAmetysObject;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.plugins.explorer.resources.jcr.JCRResource;
import org.ametys.plugins.explorer.resources.jcr.JCRResourceFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.workspaces.documents.jcr.FileFactory;

public class File
extends JCRResource<FileFactory>
implements CommentableAmetysObject<Comment> {
    public File(Node node, String parentPath, FileFactory factory) {
        super(node, parentPath, (JCRResourceFactory)factory);
    }

    public Comment createComment() {
        return new Comment(this._getCommentsDataHolder());
    }

    public Comment createComment(String commentId, ZonedDateTime creationDate) {
        return new Comment(this._getCommentsDataHolder(), commentId, creationDate);
    }

    public Comment getComment(String commentId) throws AmetysRepositoryException {
        return Comment.getComment((ModifiableModelLessDataHolder)this._getCommentsDataHolder(), (String)commentId);
    }

    public List<Comment> getComments(boolean includeNotValidatedComments, boolean includeValidatedComments) throws AmetysRepositoryException {
        return Comment.getComments((ModifiableModelLessDataHolder)this._getCommentsDataHolder(), (boolean)includeNotValidatedComments, (boolean)includeValidatedComments);
    }

    private ModifiableModelLessDataHolder _getCommentsDataHolder() {
        try {
            Node baseNode = this.getBaseNode();
            if (!baseNode.hasNode("ametys:comments")) {
                baseNode.addNode("ametys:comments", "ametys:compositeMetadata");
            }
            Node commentsNode = baseNode.getNode("ametys:comments");
            baseNode.getSession().save();
            JCRRepositoryData repositoryData = new JCRRepositoryData(commentsNode);
            return new DefaultModifiableModelLessDataHolder(((FileFactory)this._getFactory()).getUnversionedDataTypeExtensionPoint(), (ModifiableRepositoryData)repositoryData);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException((Throwable)e);
        }
    }
}

