/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.forum;

import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.repository.CommentableAmetysObject;
import org.ametys.cms.repository.comment.AbstractComment;
import org.ametys.cms.repository.comment.RichTextComment;
import org.ametys.core.observation.Event;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.workspaces.forum.AbstractWorkspaceThreadDAO;
import org.ametys.plugins.workspaces.forum.Thread;
import org.ametys.plugins.workspaces.forum.filters.AcceptedFilter;

public class WorkspaceThreadCommentDAO
extends AbstractWorkspaceThreadDAO {
    public static final String ROLE = WorkspaceThreadCommentDAO.class.getName();

    @Callable(rights={""})
    public Map<String, Object> createComment(String threadId, String commentText) {
        Thread thread = (Thread)this._resolver.resolveById(threadId);
        ModifiableTraversableAmetysObject threadsRoot = (ModifiableTraversableAmetysObject)thread.getParent();
        this._checkUserRights((AmetysObject)threadsRoot, "Plugin_Workspace_Contribute_To_Thread");
        RichTextComment comment = this.createComment(thread, commentText, threadsRoot);
        this._setLastContribution(thread, comment);
        this._workspaceThreadUserPrefDAO.clearUnreadCommentsNotification(thread.getId(), comment.getId());
        Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON(thread, this.getSitemapLanguage(), this.getSiteName());
        this._notifyEvent(thread, comment, "forumthread.commented");
        threadAsJSON.put("passFilter", true);
        return threadAsJSON;
    }

    @Callable(rights={""})
    public Map<String, Object> editComment(String threadId, String commentId, String commentText) {
        Thread thread = (Thread)this._resolver.resolveById(threadId);
        ModifiableTraversableAmetysObject threadsRoot = (ModifiableTraversableAmetysObject)thread.getParent();
        this.editComment(thread, commentId, commentText, threadsRoot);
        Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON(thread, this.getSitemapLanguage(), this.getSiteName());
        threadAsJSON.put("passFilter", true);
        return threadAsJSON;
    }

    @Callable(rights={""})
    public Map<String, Object> deleteComment(String threadId, String commentId, Boolean accepted) {
        Thread thread = (Thread)this._resolver.resolveById(threadId);
        ModifiableTraversableAmetysObject threadsRoot = (ModifiableTraversableAmetysObject)thread.getParent();
        AbstractComment comment = thread.getComment(commentId);
        if (!comment.getAuthor().equals((Object)this._currentUserProvider.getUser())) {
            this._checkUserRights((AmetysObject)threadsRoot, "Plugin_Workspace_Handle_All_Thread", thread, "Plugin_Workspace_Delete_Own_Thread_Answers");
        }
        this.deleteComment(thread, commentId, threadsRoot);
        Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON(thread, this.getSitemapLanguage(), this.getSiteName());
        AcceptedFilter acceptedFilter = new AcceptedFilter(accepted);
        threadAsJSON.put("passFilter", acceptedFilter.passFilter(thread));
        return threadAsJSON;
    }

    @Callable(rights={""})
    public Map<String, Object> answerComment(String threadId, String commentId, String commentText) {
        Thread thread = (Thread)this._resolver.resolveById(threadId);
        ModifiableTraversableAmetysObject threadsRoot = (ModifiableTraversableAmetysObject)thread.getParent();
        this._checkUserRights((AmetysObject)threadsRoot, "Plugin_Workspace_Contribute_To_Thread");
        RichTextComment comment = this.answerComment(thread, commentId, commentText, threadsRoot);
        this._setLastContribution(thread, comment);
        this._workspaceThreadUserPrefDAO.clearUnreadCommentsNotification(thread.getId(), comment.getId());
        Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON(thread, this.getSitemapLanguage(), this.getSiteName());
        threadAsJSON.put("passFilter", true);
        this._notifyEvent(thread, comment, "forumthread.commented");
        return threadAsJSON;
    }

    @Callable(rights={""})
    public Map<String, Object> likeOrUnlikeComment(String threadId, String commentId, Boolean liked) {
        Thread thread = (Thread)this._resolver.resolveById(threadId);
        ModifiableTraversableAmetysObject threadsRoot = (ModifiableTraversableAmetysObject)thread.getParent();
        this._checkUserRights((AmetysObject)threadsRoot, "Plugin_Workspace_Contribute_To_Thread");
        this.likeOrUnlikeComment(thread, commentId, liked, threadsRoot);
        Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON(thread, this.getSitemapLanguage(), this.getSiteName());
        threadAsJSON.put("passFilter", true);
        return threadAsJSON;
    }

    private void _setLastContribution(Thread thread, RichTextComment comment) {
        thread.setLastContribution(comment.getCreationDate());
        thread.saveChanges();
    }

    @Callable(rights={""})
    public Map<String, Object> acceptComment(String threadId, String commentId, String oldCommentId, Boolean accepted) {
        Thread thread = (Thread)this._resolver.resolveById(threadId);
        ModifiableTraversableAmetysObject threadsRoot = (ModifiableTraversableAmetysObject)thread.getParent();
        this._checkUserRights((AmetysObject)threadsRoot, "Plugin_Workspace_Handle_All_Thread", thread, "Plugin_Workspace_Create_Thread");
        if (oldCommentId != null) {
            this._setAcceptedComment(thread, oldCommentId, threadsRoot, false);
        }
        RichTextComment comment = this._setAcceptedComment(thread, commentId, threadsRoot, true);
        Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON(thread, this.getSitemapLanguage(), this.getSiteName());
        AcceptedFilter acceptedFilter = new AcceptedFilter(accepted);
        this._notifyEvent(thread, comment, "forumthread.accepted");
        threadAsJSON.put("passFilter", acceptedFilter.passFilter(thread));
        return threadAsJSON;
    }

    @Callable(rights={""})
    public Map<String, Object> cancelAcceptComment(String threadId, String commentId, Boolean accepted) {
        Thread thread = (Thread)this._resolver.resolveById(threadId);
        ModifiableTraversableAmetysObject threadsRoot = (ModifiableTraversableAmetysObject)thread.getParent();
        this._checkUserRights((AmetysObject)threadsRoot, "Plugin_Workspace_Handle_All_Thread", thread, "Plugin_Workspace_Create_Thread");
        this._setAcceptedComment(thread, commentId, threadsRoot, false);
        Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON(thread, this.getSitemapLanguage(), this.getSiteName());
        AcceptedFilter acceptedFilter = new AcceptedFilter(accepted);
        threadAsJSON.put("passFilter", acceptedFilter.passFilter(thread));
        return threadAsJSON;
    }

    protected RichTextComment _setAcceptedComment(CommentableAmetysObject<RichTextComment> commentableAmetysObject, String commentId, ModifiableTraversableAmetysObject moduleRoot, boolean isAccepted) {
        RichTextComment comment = (RichTextComment)commentableAmetysObject.getComment(commentId);
        comment.setAccepted(isAccepted);
        moduleRoot.saveChanges();
        return comment;
    }

    @Callable(rights={""})
    public Map<String, Object> reportComment(String threadId, String commentId) {
        Thread thread = (Thread)this._resolver.resolveById(threadId);
        ModifiableTraversableAmetysObject threadsRoot = (ModifiableTraversableAmetysObject)thread.getParent();
        this._checkUserRights((AmetysObject)threadsRoot, "Plugin_Workspace_Contribute_To_Thread");
        RichTextComment comment = (RichTextComment)thread.getComment(commentId);
        comment.addReport();
        threadsRoot.saveChanges();
        this._notifyEvent(thread, comment, "forumthread.reported");
        Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON(thread, this.getSitemapLanguage(), this.getSiteName());
        threadAsJSON.put("passFilter", true);
        return threadAsJSON;
    }

    @Callable(rights={""})
    public Map<String, Object> clearReports(String threadId, String commentId) {
        Thread thread = (Thread)this._resolver.resolveById(threadId);
        ModifiableTraversableAmetysObject threadsRoot = (ModifiableTraversableAmetysObject)thread.getParent();
        this._checkUserRights((AmetysObject)threadsRoot, "Plugins_Workspaces_Handle_Reported_Comment_Thread", thread, "Plugins_Workspaces_Handle_Reported_Comment_Own_Thread");
        RichTextComment comment = (RichTextComment)thread.getComment(commentId);
        comment.clearReports();
        threadsRoot.saveChanges();
        Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON(thread, this.getSitemapLanguage(), this.getSiteName());
        threadAsJSON.put("passFilter", true);
        return threadAsJSON;
    }

    private void _notifyEvent(Thread thread, RichTextComment comment, String eventId) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("forumthreadthread", thread);
        eventParams.put("forumthreadcomment", comment);
        eventParams.put("object.id", thread.getId());
        this._observationManager.notify(new Event(eventId, this._currentUserProvider.getUser(), eventParams));
    }
}

