/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.forum.filters;

import org.ametys.core.util.StringUtils;
import org.ametys.plugins.workspaces.forum.Thread;
import org.ametys.plugins.workspaces.forum.filters.ThreadFilter;
import org.ametys.plugins.workspaces.forum.json.ThreadJSONHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

public class TextSearchFilter
extends AbstractLogEnabled
implements ThreadFilter {
    private String _search;
    private ThreadJSONHelper _threadJSONHelper;

    public TextSearchFilter(String search, ThreadJSONHelper threadJSONHelper) {
        this._search = search;
        this._threadJSONHelper = threadJSONHelper;
    }

    @Override
    public boolean passFilter(Thread thread) {
        if (this._search == null) {
            return true;
        }
        String simpleText = this._threadJSONHelper.richTextToSimpleText(thread.getContent(), 0);
        return this._contains(thread.getTitle(), this._search) || this._contains(simpleText, this._search);
    }

    private boolean _contains(String sequence, String searchSequence) {
        return StringUtils.normalizeStringValue((String)sequence).contains(searchSequence);
    }
}

