/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.forum.json;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.RichText;
import org.ametys.cms.data.RichTextHelper;
import org.ametys.cms.repository.comment.RichTextComment;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.forum.Thread;
import org.ametys.plugins.workspaces.forum.WorkspaceThreadUserPreferencesDAO;
import org.ametys.plugins.workspaces.util.WorkspaceObjectJSONHelper;
import org.ametys.runtime.model.type.DataContext;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ThreadJSONHelper
extends WorkspaceObjectJSONHelper
implements Component {
    public static final String ROLE = ThreadJSONHelper.class.getName();
    protected WorkspaceThreadUserPreferencesDAO _workspaceThreadUserPrefDAO;
    protected RichTextHelper _richTextHelper;
    protected WorkspacesHelper _workspaceHelper;
    protected AmetysObjectResolver _resolver;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._workspaceThreadUserPrefDAO = (WorkspaceThreadUserPreferencesDAO)((Object)manager.lookup(WorkspaceThreadUserPreferencesDAO.ROLE));
        this._richTextHelper = (RichTextHelper)manager.lookup(RichTextHelper.ROLE);
        this._workspaceHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public Map<String, Object> threadAsJSON(Thread thread, String lang, String siteName) {
        return this.threadAsJSON(thread, lang, siteName, true);
    }

    public Map<String, Object> threadAsJSON(Thread thread, String lang, String siteName, boolean parseCommentcontent) {
        return this.threadAsJSON(thread, lang, siteName, parseCommentcontent, true);
    }

    public Map<String, Object> threadAsJSON(Thread thread, String lang, String siteName, boolean parseCommentcontent, boolean parseRenderAndEditing) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("id", thread.getId());
        json.put("title", thread.getTitle());
        RichText richText = thread.getContent();
        try {
            StringBuilder result = new StringBuilder(2048);
            this._richTextTransformer.transformForEditing(richText, DataContext.newInstance(), result);
            json.put("contentAbstract", this.richTextToSimpleText(richText, 200));
            if (parseRenderAndEditing) {
                json.put("contentEditing", result.toString());
                json.put("contentRendering", this.richTextToRendering(richText));
            }
        }
        catch (IOException | AmetysRepositoryException e) {
            json.put("contentError", true);
            this.getLogger().error("Unable to transform the rich text value into a string for abstract for thread " + thread.getId(), e);
        }
        json.put("creationDate", thread.getCreationDate());
        json.put("lastModified", thread.getLastModified());
        json.put("author", this._userHelper.user2json(thread.getAuthor()));
        json.put("isAuthor", thread.getAuthor().equals((Object)this._currentUserProvider.getUser()));
        json.put("category", thread.getCategory().name());
        json.put("tags", this._getTags(thread, siteName));
        json.put("closeAuthor", this._userHelper.user2json(thread.getCloseAuthor()));
        json.put("closeDate", thread.getCloseDate());
        List attachments = thread.getAttachments().stream().map(x$0 -> this._binaryToJson((Binary)x$0)).collect(Collectors.toList());
        json.put("attachments", attachments);
        json.put("lastContribution", thread.getLastContribution());
        ZonedDateTime lastReadDate = this._workspaceThreadUserPrefDAO.getLastReadDate(thread);
        List<RichTextComment> flattenComments = thread.getFlattenComments(true, true);
        json.put("commentsLength", flattenComments.size());
        if (parseCommentcontent) {
            List<Map<String, Object>> commentsAsJSON = this._commentsToJson(flattenComments, lang, siteName, lastReadDate, parseCommentcontent);
            json.put("comments", commentsAsJSON);
        }
        List<Map<String, Object>> uniqueAuthors = this._getUniqueAuthors(flattenComments, lang);
        json.put("commentAuthors", uniqueAuthors);
        json.put("hasUnopenedThreadNotification", !this._workspaceThreadUserPrefDAO.hasOpenedThread(thread));
        json.put("unreadComments", this._workspaceThreadUserPrefDAO.getUnreadCommentNumber(thread));
        RichTextComment acceptedComment = thread.getAcceptedAnswer();
        if (acceptedComment != null) {
            json.put("acceptedAnswer", this._commentToJson(acceptedComment, lang, siteName, lastReadDate, true));
        }
        return json;
    }

    private List<Map<String, Object>> _getUniqueAuthors(List<RichTextComment> flattenComments, String lang) {
        HashSet seen = new HashSet();
        ArrayList<RichTextComment> uniqueAuthorComments = new ArrayList<RichTextComment>(flattenComments);
        uniqueAuthorComments.removeIf(e -> !seen.add(e.getAuthorEmail()));
        List<Map<String, Object>> uniqueAuthors = uniqueAuthorComments.stream().map(comment -> this._authorToJSON(comment, this._userManager.getUser(comment.getAuthor()), lang)).toList();
        return uniqueAuthors;
    }
}

