/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.members;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.query.ContentQuery;
import org.ametys.cms.search.query.NotQuery;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class MemberHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = MemberHelper.class.getName();
    protected ContentSearcherFactory _contentSearcherFactory;
    protected AmetysObjectResolver _resolver;
    protected ContentHelper _contentHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._contentHelper = (ContentHelper)smanager.lookup(ContentHelper.ROLE);
        this._contentSearcherFactory = (ContentSearcherFactory)smanager.lookup(ContentSearcherFactory.ROLE);
    }

    public List<String> getSkills(Content content) {
        ContentValue[] skillValues;
        if (content.hasValue("skills") && (skillValues = (ContentValue[])content.getValue("skills", false, (Object)new ContentValue[0])).length != 0) {
            return Arrays.stream(skillValues).map(v -> v.getContentId()).collect(Collectors.toList());
        }
        return List.of();
    }

    public List<String> getKeywords(Content content) {
        ContentValue[] keywordValues;
        if (content.hasValue("keywords") && (keywordValues = (ContentValue[])content.getValue("keywords", false, (Object)new ContentValue[0])).length != 0) {
            return Arrays.stream(keywordValues).map(v -> v.getContentId()).collect(Collectors.toList());
        }
        return List.of();
    }

    public List<Content> getRelatedMembers(Content content, int max) throws Exception {
        List<String> skills = this.getSkills(content);
        List<String> keywords = this.getKeywords(content);
        if (!skills.isEmpty() || !keywords.isEmpty()) {
            ContentSearcherFactory.SimpleContentSearcher searcher = this._contentSearcherFactory.create(new String[]{"org.ametys.plugins.workspaces.Content.member"});
            HashSet<ContentQuery> queries = new HashSet<ContentQuery>();
            for (String skillId : skills) {
                ContentQuery skillQuery = new ContentQuery("skills", Query.Operator.EQ, (Object)skillId, this._resolver, this._contentHelper);
                queries.add(skillQuery);
            }
            for (String keywordId : keywords) {
                ContentQuery keywordQuery = new ContentQuery("keywords", Query.Operator.EQ, (Object)keywordId, this._resolver, this._contentHelper);
                queries.add(keywordQuery);
            }
            AmetysObjectIterable relatedMembers = searcher.withFilterQueries(List.of(new NotQuery(() -> "id:\"" + content.getId() + "\""))).withLimits(0, max).search((Query)new OrQuery(queries));
            return relatedMembers.stream().collect(Collectors.toList());
        }
        return List.of();
    }
}

