/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.members;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.ametys.cms.languages.Language;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.plugins.workspaces.members.MembersWorkspaceModule;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.rights.ProjectRightHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.Zone;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.usermanagement.UserManagementException;
import org.ametys.web.usermanagement.UserSignUpConfiguration;
import org.ametys.web.usermanagement.UserSignupManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class ProjectInvitationHelper
extends AbstractLogEnabled
implements Serviceable,
Component,
Configurable,
PluginAware,
Contextualizable {
    public static final String ROLE = ProjectInvitationHelper.class.getName();
    private static final String __MAIL_PROJECT_EMAIL_PATTERN = "${email}";
    private static final String __MAIL_PROJECT_TOKEN_PATTERN = "${token}";
    private ProjectManager _projectManager;
    private UserSignUpConfiguration _signupConfig;
    private UserSignupManager _signupManager;
    private SiteManager _siteManager;
    private WorkspaceModuleExtensionPoint _moduleEP;
    private CurrentUserProvider _currentUserProvider;
    private UserManager _userManager;
    private UserHelper _userHelper;
    private ProjectRightHelper _projectRightsHelper;
    private ProjectMemberManager _projectMemberManager;
    private PopulationContextHelper _populationContextHelper;
    private LanguagesManager _languagesManager;
    private UserLanguagesManager _userLanguagesManager;
    private String _subjectKeyForInvitation;
    private String _textBodyKeyForInvitation;
    private String _htmlBodyKeyForInvitation;
    private String _subjectKeyForInvitationAccepted;
    private String _textBodyKeyForInvitationAccepted;
    private String _htmlBodyKeyForInvitationAccepted;
    private I18nUtils _i18nUtils;
    private String _pluginName;
    private Context _context;

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._projectManager = (ProjectManager)((Object)serviceManager.lookup(ProjectManager.ROLE));
        this._projectRightsHelper = (ProjectRightHelper)((Object)serviceManager.lookup(ProjectRightHelper.ROLE));
        this._projectMemberManager = (ProjectMemberManager)((Object)serviceManager.lookup(ProjectMemberManager.ROLE));
        this._signupConfig = (UserSignUpConfiguration)serviceManager.lookup(UserSignUpConfiguration.ROLE);
        this._signupManager = (UserSignupManager)serviceManager.lookup(UserSignupManager.ROLE);
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._moduleEP = (WorkspaceModuleExtensionPoint)((Object)serviceManager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._userHelper = (UserHelper)serviceManager.lookup(UserHelper.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
        this._populationContextHelper = (PopulationContextHelper)serviceManager.lookup(PopulationContextHelper.ROLE);
        this._languagesManager = (LanguagesManager)serviceManager.lookup(LanguagesManager.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)serviceManager.lookup(UserLanguagesManager.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._subjectKeyForInvitation = configuration.getChild("invitation-email-subject").getValue(null);
        this._textBodyKeyForInvitation = configuration.getChild("invitation-email-text-body").getValue(null);
        this._htmlBodyKeyForInvitation = configuration.getChild("invitation-email-html-body").getValue(null);
        this._subjectKeyForInvitationAccepted = configuration.getChild("invitation-accepted-email-subject").getValue(null);
        this._textBodyKeyForInvitationAccepted = configuration.getChild("invitation-accepted-email-text-body").getValue(null);
        this._htmlBodyKeyForInvitationAccepted = configuration.getChild("invitation-accepted-email-html-body").getValue(null);
    }

    public Map<String, Object> inviteEmails(String projectName, List<String> emails, Map<String, String> allowedProfileByModule) throws UserManagementException, NotUniqueUserException {
        Request request = ContextHelper.getRequest((Context)this._context);
        String siteName = WebHelper.getSiteName((Request)request);
        String sitemapLanguage = (String)request.getAttribute("sitemapLanguage");
        return this.inviteEmails(projectName, siteName, sitemapLanguage, emails, allowedProfileByModule);
    }

    public Map<String, Object> inviteEmails(String projectName, String siteName, String lang, List<String> emails, Map<String, String> allowedProfileByModule) throws UserManagementException, NotUniqueUserException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("existing-users", new ArrayList());
        result.put("email-success", new ArrayList());
        result.put("email-error", new ArrayList());
        Project project = this._projectManager.getProject(projectName);
        if (project != null) {
            MembersWorkspaceModule module = (MembersWorkspaceModule)this._moduleEP.getModule(MembersWorkspaceModule.MEMBERS_MODULE_ID);
            if (module != null && this._projectManager.isModuleActivated(project, module.getId())) {
                if (!this._projectRightsHelper.canAddMember(project)) {
                    throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to send invitations without sufficient right.");
                }
                String catalogSiteName = this._projectManager.getCatalogSiteName();
                UserDirectory userDirectory = this._getUserDirectoryForSignup(result, catalogSiteName, lang);
                if (userDirectory != null) {
                    String populationId = userDirectory.getPopulationId();
                    String userDirectoryId = userDirectory.getId();
                    Map<String, String> emailConfiguration = this._getInvitationEmailConfiguration(project, lang);
                    String mailSubject = emailConfiguration.get("subject");
                    String mailBodyText = emailConfiguration.get("bodyText");
                    String mailBodyHtml = emailConfiguration.get("bodyHtml");
                    block6: for (String email : emails) {
                        try {
                            this._signupManager.inviteToSignup(catalogSiteName, lang, email, populationId, userDirectoryId, null, null, false, false, false);
                            if (!this._addOrUpdateInvitation(project, catalogSiteName, module, email, allowedProfileByModule, populationId, userDirectoryId, mailSubject, mailBodyText, mailBodyHtml)) continue;
                            List emailSuccess = (List)result.get("email-success");
                            emailSuccess.add(email);
                        }
                        catch (UserManagementException e) {
                            switch (e.getStatusError()) {
                                case USER_ALREADY_EXISTS: {
                                    User user = this._getUser(catalogSiteName, email);
                                    Map user2json = this._userHelper.user2json(user, true);
                                    List existingUsers = (List)result.get("existing-users");
                                    existingUsers.add(user2json);
                                    continue block6;
                                }
                                case TEMP_USER_ALREADY_EXISTS: {
                                    if (!this._addOrUpdateInvitation(project, catalogSiteName, module, email, allowedProfileByModule, populationId, userDirectoryId, mailSubject, mailBodyText, mailBodyHtml)) continue block6;
                                    List emailSuccess = (List)result.get("email-success");
                                    emailSuccess.add(email);
                                    continue block6;
                                }
                            }
                            this.getLogger().error("Cannot invite " + email, (Throwable)e);
                            List emailErrors = (List)result.get("email-error");
                            emailErrors.add(email);
                        }
                    }
                    List emailSuccess = (List)result.get("email-success");
                    if (emailSuccess.size() == emails.size()) {
                        result.put("success", true);
                    }
                }
            }
        } else {
            result.put("success", false);
            result.put("unknown-project", projectName);
        }
        return result;
    }

    private User _getUser(String siteName, String email) throws NotUniqueUserException {
        Set populations = this._populationContextHelper.getUserPopulationsOnContexts(Arrays.asList("/sites/" + siteName, "/sites-fo/" + siteName), false);
        for (String population : populations) {
            User user = this._userManager.getUser(population, email);
            if (user == null) {
                user = this._userManager.getUserByEmail(population, email);
            }
            if (user == null) continue;
            return user;
        }
        return null;
    }

    @Callable(rights={""})
    public Map<String, Object> getInvitationConfiguration(String projectName, String lang) {
        Project project = this._projectManager.getProject(projectName);
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (!this._projectRightsHelper.canAddMember(project)) {
            config.put("allowed", false);
            config.put("error", "no-right");
            return config;
        }
        String catalogSiteName = this._projectManager.getCatalogSiteName();
        if (this._getUserDirectoryForSignup(config, catalogSiteName, lang) == null) {
            config.remove("success");
            config.put("allowed", false);
            return config;
        }
        config.put("allowed", true);
        config.put("email", this._getInvitationEmailConfiguration(project, lang));
        config.put("rights", this._projectRightsHelper.getProjectRightsData(projectName));
        return config;
    }

    private Map<String, String> _getInvitationEmailConfiguration(Project project, String lang) {
        String bodyHtml;
        String bodyTxt;
        String subject;
        HashMap<String, String> emailConfig = new HashMap<String, String>();
        HashMap<String, I18nizableTextParameter> i18nparams = new HashMap<String, I18nizableTextParameter>();
        i18nparams.put("projectTitle", (I18nizableTextParameter)new I18nizableText(project.getTitle()));
        i18nparams.put("projectUrl", (I18nizableTextParameter)new I18nizableText(this._projectManager.getProjectUrl(project, "")));
        i18nparams.put("nbDays", (I18nizableTextParameter)new I18nizableText(String.valueOf(this._signupConfig.getTokenValidity())));
        i18nparams.put("nbDays", (I18nizableTextParameter)new I18nizableText(String.valueOf(this._signupConfig.getTokenValidity())));
        String catalogSiteName = this._projectManager.getCatalogSiteName();
        Site catalogSite = this._siteManager.getSite(catalogSiteName);
        i18nparams.put("catalogSiteTitle", (I18nizableTextParameter)new I18nizableText(catalogSite.getTitle()));
        i18nparams.put("catalogSiteUrl", (I18nizableTextParameter)new I18nizableText(catalogSite.getUrl()));
        Page signupPage = this._getSignupPage(this._projectManager.getCatalogSiteName(), lang);
        if (signupPage != null) {
            String signupUri = ResolveURIComponent.resolve((String)"page", (String)signupPage.getId(), (boolean)false, (boolean)true) + "?email=${email}&token=${token}";
            i18nparams.put("signupUri", (I18nizableTextParameter)new I18nizableText(signupUri));
        }
        if ((subject = this.getSubjectForInvitationEmail(i18nparams, lang)) != null) {
            emailConfig.put("subject", subject);
        }
        if ((bodyTxt = this.getTextBodyForInvitationEmail(i18nparams, lang)) != null) {
            emailConfig.put("bodyText", bodyTxt);
        }
        if ((bodyHtml = this.getHtmlBodyForInvitationEmail(i18nparams, lang)) != null) {
            emailConfig.put("bodyHtml", bodyHtml);
        }
        return emailConfig;
    }

    private Page _getSignupPage(String catalogSiteName, String lang) {
        Page signupPage = this._signupManager.getSignupPage(catalogSiteName, lang);
        if (signupPage == null) {
            signupPage = this._signupManager.getSignupPage(catalogSiteName, "en");
        }
        if (signupPage == null) {
            Map availableLanguages = this._languagesManager.getAvailableLanguages();
            for (Language availableLanguage : availableLanguages.values()) {
                if (signupPage != null) continue;
                signupPage = this._signupManager.getSignupPage(catalogSiteName, availableLanguage.getCode());
            }
        }
        return signupPage;
    }

    private void _sendInvitationMail(String catalogSiteName, String email, String populationId, String userDirectoryId, String mailSubject, String mailBodyText, String mailBodyHtml) throws UserManagementException {
        String encodedEmail;
        try {
            encodedEmail = URLEncoder.encode(email, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UserManagementException("Encoding error while sending a sign-up confirmation e-mail.", UserManagementException.StatusError.MAIL_ERROR, (Throwable)e);
        }
        String token = this._signupManager.getToken(catalogSiteName, email, populationId, userDirectoryId);
        String bodyTxt = StringUtils.replace((String)mailBodyText, (String)__MAIL_PROJECT_TOKEN_PATTERN, (String)token);
        bodyTxt = StringUtils.replace((String)bodyTxt, (String)__MAIL_PROJECT_EMAIL_PATTERN, (String)encodedEmail);
        String bodyHtml = StringUtils.replace((String)mailBodyHtml, (String)__MAIL_PROJECT_TOKEN_PATTERN, (String)token);
        bodyHtml = StringUtils.replace((String)bodyHtml, (String)__MAIL_PROJECT_EMAIL_PATTERN, (String)encodedEmail);
        this.getLogger().debug("Sending signup invitation e-mail to {}", (Object)email);
        Site site = this._siteManager.getSite(catalogSiteName);
        String from = (String)site.getValue("site-mail-from");
        try {
            ArrayList errorReport = new ArrayList();
            SendMailHelper.newMail().withSubject(mailSubject).withTextBody(bodyTxt).withHTMLBody(bodyHtml).withSender(from).withRecipient(email).withErrorReport(errorReport).sendMail();
            if (errorReport.contains(email)) {
                throw new UserManagementException("Error sending the sign-up confirmation mail.", UserManagementException.StatusError.MAIL_ERROR);
            }
        }
        catch (MessagingException | IOException e) {
            throw new UserManagementException("Error sending the sign-up confirmation mail.", UserManagementException.StatusError.MAIL_ERROR, e);
        }
    }

    private boolean _addOrUpdateInvitation(Project project, String catalogSiteName, MembersWorkspaceModule module, String email, Map<String, String> allowedProfileByModules, String populationId, String userDirectoryId, String mailSubject, String mailBodyText, String mailBodyHtml) throws UserManagementException {
        try {
            module.removeInvitation(project, email);
            module.addInvitation(project, new Date(), email, this._currentUserProvider.getUser(), allowedProfileByModules);
            project.saveChanges();
            this._sendInvitationMail(catalogSiteName, email, populationId, userDirectoryId, mailSubject, mailBodyText, mailBodyHtml);
            return true;
        }
        catch (RepositoryException e) {
            this.getLogger().error("Fail to store invitation for email " + email, (Throwable)e);
            return false;
        }
    }

    private UserDirectory _getUserDirectoryForSignup(Map<String, Object> result, String catalogSiteName, String lang) {
        if (catalogSiteName == null) {
            this.getLogger().error("The catalog's site name is not configured. User invitations can not be activated.");
            result.put("success", false);
            result.put("error", "invalid-configuration");
            return null;
        }
        if (!this._signupManager.isSignupAllowed(catalogSiteName)) {
            this.getLogger().warn("Signup is disabled for the catalog's site.");
            result.put("success", false);
            return null;
        }
        Page signupPage = this._getSignupPage(catalogSiteName, lang);
        if (signupPage == null) {
            this.getLogger().error("The catalog's site does not contain the signup service for language " + lang + ". User invitations can not be activated.");
            result.put("success", false);
            result.put("error", "invalid-configuration");
            return null;
        }
        UserDirectory userDirectory = this._getUserDirectoryForSignup(signupPage);
        if (userDirectory == null) {
            this.getLogger().error("There is no user directory configured for users signup. Please check the sign up service of catalog's site.");
            result.put("success", false);
            result.put("error", "invalid-configuration");
            return null;
        }
        return userDirectory;
    }

    private UserDirectory _getUserDirectoryForSignup(Page signupPage) {
        for (Zone zone : signupPage.getZones()) {
            AmetysObjectIterable zoneItems = zone.getZoneItems();
            try {
                for (ZoneItem zoneItem : zoneItems) {
                    UserDirectory userDirectory = this._signupManager.getUserDirectory(zoneItem);
                    if (userDirectory == null) continue;
                    UserDirectory userDirectory2 = userDirectory;
                    return userDirectory2;
                }
            }
            finally {
                if (zoneItems == null) continue;
                zoneItems.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMemberFromInvitations(User user) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWorkspace = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            MembersWorkspaceModule memberModule = (MembersWorkspaceModule)this._moduleEP.getExtension(MembersWorkspaceModule.MEMBERS_MODULE_ID);
            List<MembersWorkspaceModule.Invitation> invitations = memberModule.getInvitations(user.getEmail());
            for (MembersWorkspaceModule.Invitation invitation : invitations) {
                Map<String, String> allowedProfileByModules = invitation.getAllowedProfileByModules();
                String projectName = invitation.getProjectName();
                Project project = this._projectManager.getProject(projectName);
                this._projectMemberManager.addOrUpdateProjectMember(project, user.getIdentity(), allowedProfileByModules, invitation.getAuthor());
                UserIdentity author = invitation.getAuthor();
                this.sendInvitationAcceptedMail(project, this._userManager.getUser(author), user);
                try {
                    memberModule.removeInvitation(project, invitation.getEmail());
                }
                catch (RepositoryException e) {
                    this.getLogger().error("Failed to remove invitation " + String.valueOf(invitation), (Throwable)e);
                }
            }
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWorkspace);
        }
    }

    protected void sendInvitationAcceptedMail(Project project, User invitAuthor, User newMember) {
        if (invitAuthor != null) {
            Site site = project.getSite();
            String from = (String)site.getValue("site-mail-from");
            String email = invitAuthor.getEmail();
            String language = (String)StringUtils.defaultIfBlank((CharSequence)invitAuthor.getLanguage(), (CharSequence)this._userLanguagesManager.getDefaultLanguage());
            if (StringUtils.isNotEmpty((CharSequence)email)) {
                HashMap<String, I18nizableTextParameter> i18nParams = new HashMap<String, I18nizableTextParameter>();
                i18nParams.put("projectTitle", (I18nizableTextParameter)new I18nizableText(project.getTitle()));
                i18nParams.put("projectUrl", (I18nizableTextParameter)new I18nizableText(this._projectManager.getProjectUrl(project, "")));
                i18nParams.put("newMember", (I18nizableTextParameter)new I18nizableText(newMember.getFullName()));
                i18nParams.put("newMemberMail", (I18nizableTextParameter)new I18nizableText(newMember.getEmail()));
                Set<Page> memberPages = this._projectManager.getModulePages(project, MembersWorkspaceModule.MEMBERS_MODULE_ID);
                if (!memberPages.isEmpty()) {
                    Page page = memberPages.iterator().next();
                    i18nParams.put("membersPageUri", (I18nizableTextParameter)new I18nizableText(ResolveURIComponent.resolve((String)"page", (String)page.getId(), (boolean)false, (boolean)true)));
                }
                String subject = this.getSubjectForInvitationAcceptedEmail(i18nParams, language);
                String textBody = this.getTextBodyForInvitationAcceptedEmail(i18nParams, language);
                String htmlBody = this.getHtmlBodyForInvitationAcceptedEmail(project, i18nParams, language);
                try {
                    SendMailHelper.newMail().withSubject(subject).withHTMLBody(htmlBody).withTextBody(textBody).withSender(from).withRecipient(email).sendMail();
                }
                catch (MessagingException | IOException e) {
                    this.getLogger().error("Error sending the invitation accepted email.", e);
                }
            }
        }
    }

    public String getSubjectForInvitationEmail(Map<String, I18nizableTextParameter> defaultI18nParams, String language) {
        if (StringUtils.isNotBlank((CharSequence)this._subjectKeyForInvitation)) {
            return this._i18nUtils.translate((I18nizable)this._getI18nizableText(this._subjectKeyForInvitation, defaultI18nParams), language);
        }
        return null;
    }

    public String getTextBodyForInvitationEmail(Map<String, I18nizableTextParameter> defaultI18nParams, String language) {
        if (StringUtils.isNotBlank((CharSequence)this._textBodyKeyForInvitation)) {
            return this._i18nUtils.translate((I18nizable)this._getI18nizableText(this._textBodyKeyForInvitation, defaultI18nParams), language);
        }
        return null;
    }

    public String getHtmlBodyForInvitationEmail(Map<String, I18nizableTextParameter> defaultI18nParams, String language) {
        if (StringUtils.isNotBlank((CharSequence)this._htmlBodyKeyForInvitation)) {
            try {
                StandardMailBodyHelper.MailBodyBuilder bodyBuilder = StandardMailBodyHelper.newHTMLBody().withLanguage(language).withMessage(this._getI18nizableText(this._htmlBodyKeyForInvitation, defaultI18nParams));
                Page signupPage = this._getSignupPage(this._projectManager.getCatalogSiteName(), language);
                if (signupPage != null) {
                    String signupUri = ResolveURIComponent.resolve((String)"page", (String)signupPage.getId(), (boolean)false, (boolean)true) + "?email=${email}&token=${token}";
                    bodyBuilder.withLink(signupUri, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_USER_INVITATION_MAIL_BODY_HTML_LINK_TITLE"));
                }
                return bodyBuilder.build();
            }
            catch (IOException e) {
                this.getLogger().warn("Faild to build HTML body for invitation email", (Throwable)e);
            }
        }
        return null;
    }

    public String getSubjectForInvitationAcceptedEmail(Map<String, I18nizableTextParameter> defaultI18nParams, String language) {
        if (StringUtils.isNotBlank((CharSequence)this._subjectKeyForInvitationAccepted)) {
            return this._i18nUtils.translate((I18nizable)this._getI18nizableText(this._subjectKeyForInvitationAccepted, defaultI18nParams), language);
        }
        return null;
    }

    public String getTextBodyForInvitationAcceptedEmail(Map<String, I18nizableTextParameter> defaultI18nParams, String language) {
        if (StringUtils.isNotBlank((CharSequence)this._textBodyKeyForInvitationAccepted)) {
            return this._i18nUtils.translate((I18nizable)this._getI18nizableText(this._textBodyKeyForInvitationAccepted, defaultI18nParams), language);
        }
        return null;
    }

    public String getHtmlBodyForInvitationAcceptedEmail(Project project, Map<String, I18nizableTextParameter> defaultI18nParams, String language) {
        if (StringUtils.isNotBlank((CharSequence)this._htmlBodyKeyForInvitationAccepted)) {
            try {
                StandardMailBodyHelper.MailBodyBuilder bodyBuilder = StandardMailBodyHelper.newHTMLBody().withLanguage(language).withMessage(this._getI18nizableText(this._htmlBodyKeyForInvitationAccepted, defaultI18nParams));
                Set<Page> memberPages = this._projectManager.getModulePages(project, MembersWorkspaceModule.MEMBERS_MODULE_ID);
                if (!memberPages.isEmpty()) {
                    Page page = memberPages.iterator().next();
                    String memberPageUri = ResolveURIComponent.resolve((String)"page", (String)page.getId(), (boolean)false, (boolean)true);
                    bodyBuilder.withLink(memberPageUri, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_USER_INVITATION_ACCEPTED_MAIL_BODY_HTML_LINK_TITLE"));
                }
                return bodyBuilder.build();
            }
            catch (IOException e) {
                this.getLogger().warn("Faild to build HTML body for invitation accepted email", (Throwable)e);
            }
        }
        return null;
    }

    protected I18nizableText _getI18nizableText(String fullI18nKey, Map<String, I18nizableTextParameter> i18nParams) {
        Object catalogue = StringUtils.contains((CharSequence)fullI18nKey, (CharSequence)":") ? StringUtils.substringBefore((String)fullI18nKey, (String)":") : "plugin." + this._pluginName;
        String i18nKey = StringUtils.contains((CharSequence)fullI18nKey, (CharSequence)":") ? StringUtils.substringAfter((String)fullI18nKey, (String)":") : fullI18nKey;
        return new I18nizableText((String)catalogue, i18nKey, i18nParams);
    }
}

