/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.ametys.cms.tag.DefaultTag;
import org.ametys.cms.tag.Tag;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.cache.CacheException;
import org.ametys.core.group.GroupDirectoryContextHelper;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.observation.Observer;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.core.search.UserAndGroupSearchManager;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.NodeTypeHelper;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.repository.provider.JackrabbitRepository;
import org.ametys.plugins.repository.provider.WorkspaceSelector;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.categories.Category;
import org.ametys.plugins.workspaces.categories.CategoryProviderExtensionPoint;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.rights.ProjectRightHelper;
import org.ametys.plugins.workspaces.tags.ProjectTagProviderExtensionPoint;
import org.ametys.plugins.workspaces.util.StatisticColumn;
import org.ametys.plugins.workspaces.util.StatisticsColumnType;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteDAO;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.site.SiteConfigurationManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ProjectManager
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable,
PluginAware,
Initializable,
Observer {
    public static final String ROLE = ProjectManager.class.getName();
    public static final String REQUEST_PROJECTBYID_CACHE = ProjectManager.class.getName() + "$ProjectById";
    public static final String MEMORY_PROJECTIDBYNAMECACHE = ProjectManager.class.getName() + "$UUID";
    public static final String REQUEST_PAGESBYPROJECTANDMODULE_CACHE = ProjectManager.class.getName() + "$PagesByModule";
    public static final String MEMORY_PAGESBYIDCACHE = ProjectManager.class.getName() + "$PageUUID";
    public static final String MEMORY_SITEASSOCIATION_CACHE = ProjectManager.class.getName() + "$SiteAssociation";
    private static final String __WORKSPACES_PLUGIN_NODE_NAME = "workspaces";
    private static final String __WORKSPACES_PLUGIN_NODE_TYPE = "ametys:unstructured";
    private static final String __PROJECTS_ROOT_NODE_NAME = "projects";
    private static final String __PROJECTS_ROOT_NODE_TYPE = "ametys:unstructured";
    private static final String __PROJECTS_TAGS_PROPERTY = "ametys-internal:tags";
    private static final String __PAGE_MODULES_VALUE = "workspaces-modules";
    private static final String __IS_CACHE_FILLED = "###iscachefilled###";
    protected AmetysObjectResolver _resolver;
    protected I18nUtils _i18nUtils;
    protected SiteManager _siteManager;
    protected SiteDAO _siteDao;
    protected SiteConfigurationManager _siteConfigurationManager;
    protected WorkspaceModuleExtensionPoint _moduleManagerEP;
    protected PopulationContextHelper _populationContextHelper;
    protected GroupDirectoryContextHelper _groupDirectoryContextHelper;
    protected ProjectMemberManager _projectMemberManager;
    protected Context _context;
    private ObservationManager _observationManager;
    private CurrentUserProvider _currentUserProvider;
    private ProjectMemberManager _projectMembers;
    private String _pluginName;
    private ProjectRightHelper _projectRightHelper;
    private ProjectTagProviderExtensionPoint _projectTagProviderEP;
    private CategoryProviderExtensionPoint _categoryProviderEP;
    private UserHelper _userHelper;
    private AbstractCacheManager _cacheManager;
    private UserAndGroupSearchManager _userAndGroupSearchManager;
    private JackrabbitRepository _repository;
    private WorkspaceSelector _workspaceSelector;
    private RightManager _rightManager;
    private GroupDirectoryContextHelper _directoryContextHelper;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._repository = (JackrabbitRepository)manager.lookup("javax.jcr.Repository");
        this._workspaceSelector = (WorkspaceSelector)manager.lookup(WorkspaceSelector.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._siteDao = (SiteDAO)manager.lookup(SiteDAO.ROLE);
        this._siteConfigurationManager = (SiteConfigurationManager)manager.lookup(SiteConfigurationManager.ROLE);
        this._projectMembers = (ProjectMemberManager)((Object)manager.lookup(ProjectMemberManager.ROLE));
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._projectRightHelper = (ProjectRightHelper)((Object)manager.lookup(ProjectRightHelper.ROLE));
        this._projectTagProviderEP = (ProjectTagProviderExtensionPoint)((Object)manager.lookup(ProjectTagProviderExtensionPoint.ROLE));
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)manager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._populationContextHelper = (PopulationContextHelper)manager.lookup(PopulationContextHelper.ROLE);
        this._groupDirectoryContextHelper = (GroupDirectoryContextHelper)manager.lookup(GroupDirectoryContextHelper.ROLE);
        this._projectMemberManager = (ProjectMemberManager)((Object)manager.lookup(ProjectMemberManager.ROLE));
        this._userAndGroupSearchManager = (UserAndGroupSearchManager)manager.lookup(UserAndGroupSearchManager.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._directoryContextHelper = (GroupDirectoryContextHelper)manager.lookup(GroupDirectoryContextHelper.ROLE);
    }

    public void initialize() throws Exception {
        this._createCaches();
        this._observationManager.registerObserver((Observer)this);
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public AmetysObjectIterable<Project> getProjects() {
        return this.getProjects(true);
    }

    public AmetysObjectIterable<Project> getProjects(boolean onlyWorking) {
        Set projects = this._getUUIDCache().values().stream().filter(arg_0 -> ((AmetysObjectResolver)this._resolver).hasAmetysObjectForId(arg_0)).map(arg_0 -> ((AmetysObjectResolver)this._resolver).resolveById(arg_0)).filter(project -> !onlyWorking || Objects.nonNull(project.getSite())).collect(Collectors.toSet());
        return new CollectionIterable(projects);
    }

    public List<Project> getProjects(Set<String> filteredCategories) {
        return this.getProjects(filteredCategories, null, null, true);
    }

    public List<Project> getProjects(Set<String> filteredCategories, Set<String> filteredKeywords, boolean anyMatch) {
        return this.getProjects(filteredCategories, filteredKeywords, null, anyMatch);
    }

    public List<Project> getProjects(Set<String> filteredCategories, Set<String> filteredKeywords, String pattern, boolean anyMatch) {
        return this.getProjects(filteredCategories, filteredKeywords, null, anyMatch, false);
    }

    public List<Project> getProjects(Set<String> filteredCategories, Set<String> filteredKeywords, String pattern, boolean anyMatch, boolean excludePrivate) {
        Pattern patternFilter;
        ArrayList<Predicate<Project>> filters = new ArrayList<Predicate<Project>>();
        if (filteredCategories != null && !filteredCategories.isEmpty()) {
            filters.add(p -> !Collections.disjoint(p.getCategories(), filteredCategories));
        }
        if (filteredKeywords != null && !filteredKeywords.isEmpty()) {
            filters.add(p -> !Collections.disjoint(Arrays.asList(p.getKeywords()), filteredKeywords));
        }
        Pattern pattern2 = patternFilter = StringUtils.isNotEmpty((CharSequence)pattern) ? Pattern.compile(pattern, 2) : null;
        if (patternFilter != null) {
            filters.add(p -> p.getTitle() != null && patternFilter.matcher(p.getTitle()).find() || p.getDescription() != null && patternFilter.matcher(p.getDescription()).find());
        }
        Predicate<Project> fullMatch = filters.stream().reduce(anyMatch ? Predicate::or : Predicate::and).orElse(p -> Boolean.TRUE);
        Predicate<Project> matchStatus = p -> !excludePrivate || p.getInscriptionStatus() != Project.InscriptionStatus.PRIVATE;
        return this.getProjects().stream().filter(matchStatus).filter(fullMatch).collect(Collectors.toList());
    }

    public Set<Category> getProjectsCategories() {
        return this.getProjects().stream().map(Project::getCategories).flatMap(Collection::stream).map(id -> (Category)this._categoryProviderEP.getTag((String)id, null)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<Category> getUserProjectsCategories(UserIdentity user) {
        return this.getUserProjects(user).keySet().stream().map(Project::getCategories).flatMap(Collection::stream).map(id -> (Category)this._categoryProviderEP.getTag((String)id, null)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<WorkspaceModule> getProjectsModules() {
        return this.getProjects().stream().map(Project::getModules).flatMap(Arrays::stream).map(id -> this._moduleManagerEP.getModule((String)id)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<WorkspaceModule> getUserProjectsModules(UserIdentity user) {
        return this.getUserProjects(user).keySet().stream().map(Project::getModules).flatMap(Arrays::stream).map(id -> this._moduleManagerEP.getModule((String)id)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public List<Map<String, Object>> getProjectsForClientSide() {
        return this.getProjects(false).stream().map(p -> this.getProjectProperties((Project)((Object)p))).collect(Collectors.toList());
    }

    public Project getProject(String projectName) {
        if (StringUtils.isBlank((CharSequence)projectName)) {
            return null;
        }
        Request request = this._getRequest();
        if (request == null) {
            return this._computeProject(projectName);
        }
        Cache<RequestProjectCacheKey, Project> projectsCache = this._getRequestProjectCache();
        String currentWorkspace = this._workspaceSelector.getWorkspace();
        RequestProjectCacheKey projectKey = RequestProjectCacheKey.of(projectName, currentWorkspace);
        try {
            Project project = (Project)((Object)projectsCache.get((Object)projectKey, __ -> this._computeProject(projectName)));
            return project;
        }
        catch (CacheException e) {
            if (e.getCause() instanceof UnknownAmetysObjectException) {
                throw new UnknownAmetysObjectException(e.getMessage());
            }
            throw e;
        }
    }

    public Map<Project, JCRProjectMember.MemberType> getUserProjects(UserIdentity user) {
        return this.getUserProjects(user, Set.of());
    }

    public Map<Project, JCRProjectMember.MemberType> getUserProjects(UserIdentity user, Set<String> filteredCategories) {
        return this.getUserProjects(user, filteredCategories, null, null, true);
    }

    public Map<Project, JCRProjectMember.MemberType> getUserProjects(UserIdentity user, Set<String> filteredCategories, Set<String> filteredKeywords) {
        return this.getUserProjects(user, filteredCategories, filteredKeywords, null, true);
    }

    public Map<Project, JCRProjectMember.MemberType> getUserProjects(UserIdentity user, Set<String> filteredCategories, Set<String> filteredKeywords, String pattern, boolean anyMatch) {
        return this.getUserProjects(user, filteredCategories, filteredKeywords, pattern, true, false);
    }

    public Map<Project, JCRProjectMember.MemberType> getUserProjects(UserIdentity user, Set<String> filteredCategories, Set<String> filteredKeywords, String pattern, boolean anyMatch, boolean excludePrivate) {
        HashMap<Project, JCRProjectMember.MemberType> userProjects = new HashMap<Project, JCRProjectMember.MemberType>();
        List<Project> projects = this.getProjects(filteredCategories, filteredKeywords, pattern, anyMatch, excludePrivate);
        for (Project project : projects) {
            ProjectMemberManager.ProjectMember member = this._projectMembers.getProjectMember(project, user);
            if (member == null) continue;
            userProjects.put(project, member.getType());
        }
        return userProjects;
    }

    public List<Project> getManagedProjects(UserIdentity user) {
        return this.getManagedProjects(user, Set.of());
    }

    public List<Project> getManagedProjects(UserIdentity user, Set<String> filteredCategories) {
        return this.getProjects(filteredCategories).stream().filter(p -> ArrayUtils.contains((Object[])p.getManagers(), (Object)user)).collect(Collectors.toList());
    }

    public boolean hasProject(String projectName) {
        Map<String, String> uuidCache = this._getUUIDCache();
        if (uuidCache.containsKey(projectName)) {
            return this._resolver.hasAmetysObjectForId(uuidCache.get(projectName));
        }
        return false;
    }

    public Set<UserIdentity> getManagers() {
        return this.getProjects().stream().map(Project::getManagers).flatMap(Arrays::stream).collect(Collectors.toSet());
    }

    public boolean isManager() {
        return this.isManager(this._currentUserProvider.getUser());
    }

    public boolean isManager(UserIdentity user) {
        AmetysObjectIterable<Project> projects = this.getProjects();
        for (Project project : projects) {
            if (!this.isManager(project, user)) continue;
            return true;
        }
        return false;
    }

    public boolean isManager(String projectName, UserIdentity user) {
        Project project = this.getProject(projectName);
        if (project != null) {
            return this.isManager(project, user);
        }
        return false;
    }

    public boolean isManager(Project project, UserIdentity user) {
        return ArrayUtils.contains((Object[])project.getManagers(), (Object)user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAccessBO(Project project) {
        Site site = project.getSite();
        if (site == null) {
            return false;
        }
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentSiteName = (String)request.getAttribute("siteName");
        try {
            request.setAttribute("siteName", (Object)site.getName());
            boolean bl = !this._rightManager.getUserRights(this._currentUserProvider.getUser(), (Object)"/cms").isEmpty();
            return bl;
        }
        finally {
            request.setAttribute("siteName", (Object)currentSiteName);
        }
    }

    public boolean canLeaveProject(Project project) {
        if (project == null) {
            return false;
        }
        Site site = project.getSite();
        if (site == null) {
            return false;
        }
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        Set<ProjectMemberManager.ProjectMember> members = this._projectMemberManager.getProjectMembers(project, false);
        ProjectMemberManager.ProjectMember projectMember = members.stream().filter(member -> JCRProjectMember.MemberType.USER == member.getType()).filter(member -> userIdentity.equals((Object)member.getUser().getIdentity())).findFirst().orElse(null);
        if (projectMember == null) {
            return false;
        }
        return !this._projectMemberManager.isOnlyManager(project, userIdentity);
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getUserProjectsData() {
        return this.getUserProjects(this._currentUserProvider.getUser()).keySet().stream().map(p -> this._project2json((Project)((Object)p))).collect(Collectors.toList());
    }

    @Callable(rights={""})
    public Map<String, Object> searchUserByProject(String projectName, int limit, String criteria, Map<String, Object> previousSearchData) {
        Project project = this.getProject(projectName);
        if (!this._projectRightHelper.canAddMember(project)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to do read operation without convenient right");
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        Site site = project.getSite();
        Set projectMemberList = this._projectMemberManager.getProjectMembers(project, false).stream().map(member -> {
            if (member.getType() == JCRProjectMember.MemberType.USER) {
                return UserIdentity.userIdentityToString((UserIdentity)member.getUser().getIdentity());
            }
            GroupIdentity groupIdentityAsString = member.getGroup().getIdentity();
            return GroupIdentity.groupIdentityToString((GroupIdentity)groupIdentityAsString);
        }).collect(Collectors.toSet());
        HashSet<String> contexts = new HashSet<String>(Arrays.asList("/sites/" + site.getName(), "/sites-fo/" + site.getName()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pattern", criteria);
        Map result = new HashMap();
        Map searchData = previousSearchData;
        ArrayList memberList = new ArrayList();
        Set groupDirectories = this._directoryContextHelper.getGroupDirectoriesOnContexts(contexts);
        Set<String> userPopulations = this.getPopulation(site, true);
        do {
            result = this._userAndGroupSearchManager.searchUsersAndGroup(userPopulations, groupDirectories, limit - memberList.size(), searchData, params, true);
            List filteredMembers = ((List)result.get("results")).stream().filter(member -> !projectMemberList.contains(String.valueOf(member.get("login")) + "#" + String.valueOf(member.get("populationId"))) && !projectMemberList.contains(String.valueOf(member.get("id")) + "#" + String.valueOf(member.get("groupDirectory")))).collect(Collectors.toList());
            searchData = (Map)result.get("searchData");
            memberList.addAll(filteredMembers);
        } while (!result.containsKey("finished") && memberList.size() < limit);
        results.put("searchData", searchData);
        results.put("memberList", memberList);
        return results;
    }

    public Set<String> getPopulation(Site site, boolean excludeConfigurationPopulations) {
        HashSet<String> contexts = new HashSet<String>(Arrays.asList("/sites/" + site.getName(), "/sites-fo/" + site.getName()));
        Set userPopulations = this._populationContextHelper.getUserPopulationsOnContexts(contexts, false, true);
        if (excludeConfigurationPopulations) {
            List<String> excludedPopulationsList;
            Site catalogSite = this._siteManager.getSite(this.getCatalogSiteName());
            String excludedPopulationsString = (String)catalogSite.getValue("workspacesExcludedPopulation");
            if (((Boolean)site.getValue("overrideExcludedPopulation", false, (Object)false)).booleanValue()) {
                excludedPopulationsString = (String)site.getValue("workspacesExcludedPopulationProject");
            }
            if (!(excludedPopulationsList = Arrays.asList(StringUtils.split((String)StringUtils.defaultString((String)excludedPopulationsString), (String)","))).isEmpty()) {
                userPopulations.removeAll(excludedPopulationsList);
            }
        }
        return userPopulations;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public List<Map<String, Object>> getProjectsData() {
        return this.getProjects().stream().map(p -> this._project2json((Project)((Object)p))).collect(Collectors.toList());
    }

    protected Map<String, Object> _project2json(Project project) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("id", project.getId());
        json.put("name", project.getName());
        json.put("title", project.getTitle());
        json.put("url", this.getProjectUrl(project, ""));
        return json;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Collection<String> getProjectNames() {
        return this._getUUIDCache().entrySet().stream().filter(e -> this._resolver.hasAmetysObjectForId((String)e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public ModifiableTraversableAmetysObject getProjectsRoot() {
        try {
            ModifiableTraversableAmetysObject pluginsNode = (ModifiableTraversableAmetysObject)this._resolver.resolveByPath("/ametys:plugins");
            ModifiableTraversableAmetysObject workspacesPluginNode = (ModifiableTraversableAmetysObject)this._getOrCreateObject(pluginsNode, __WORKSPACES_PLUGIN_NODE_NAME, "ametys:unstructured");
            return (ModifiableTraversableAmetysObject)this._getOrCreateObject(workspacesPluginNode, __PROJECTS_ROOT_NODE_NAME, "ametys:unstructured");
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Error getting the projects root node.", (Throwable)e);
        }
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getProjectProperties(String projectId) {
        return this.getProjectProperties((Project)this._resolver.resolveById(projectId));
    }

    public Map<String, Object> getProjectProperties(Project project) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("id", project.getId());
        info.put("name", project.getName());
        info.put("type", "project");
        info.put("title", project.getTitle());
        info.put("description", project.getDescription());
        info.put("inscriptionStatus", project.getInscriptionStatus().toString());
        info.put("defaultProfile", project.getDefaultProfile());
        info.put("creationDate", project.getCreationDate());
        Site site = project.getSite();
        boolean valid = site != null && this._siteConfigurationManager.isSiteConfigurationValid(site);
        Set<String> categories = project.getCategories();
        info.put("categories", categories.stream().map(c -> (Category)this._categoryProviderEP.getTag((String)c, new HashMap())).filter(Objects::nonNull).map(t -> this._tag2json((Tag)t)).collect(Collectors.toList()));
        Set<String> tags = project.getTags();
        info.put("tags", tags.stream().map(c -> (DefaultTag)this._projectTagProviderEP.getTag((String)c, new HashMap())).filter(Objects::nonNull).map(t -> this._tag2json((Tag)t)).collect(Collectors.toList()));
        info.put("valid", valid);
        UserIdentity[] managers = project.getManagers();
        info.put("managers", Arrays.stream(managers).map(u -> this._userHelper.user2json(u)).collect(Collectors.toList()));
        HashMap<String, String> siteProps = new HashMap<String, String>();
        if (site != null) {
            siteProps.put("id", site.getId());
            siteProps.put("name", site.getName());
            siteProps.put("title", site.getTitle());
            siteProps.put("url", site.getUrl());
        }
        info.put("site", siteProps);
        return info;
    }

    private Map<String, Object> _tag2json(Tag tag) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("id", tag.getId());
        json.put("name", tag.getName());
        json.put("title", tag.getTitle());
        return json;
    }

    public String getProjectUrl(Project project, String defaultValue) {
        Site site = project.getSite();
        if (site == null) {
            return defaultValue;
        }
        return site.getUrl();
    }

    @Callable(rights={""})
    public Map<String, Object> createProject(String name, String title, String description, String emailList, String inscriptionStatus, String defaultProfile) {
        this.checkRightsForProjectCreation(Project.InscriptionStatus.valueOf(inscriptionStatus.toUpperCase()), null);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> errors = new ArrayList<String>();
        HashMap<String, Object> additionalValues = new HashMap<String, Object>();
        additionalValues.put("description", description);
        additionalValues.put("emailList", emailList);
        additionalValues.put("inscriptionStatus", inscriptionStatus);
        additionalValues.put("defaultProfile", defaultProfile);
        Project project = this.createProject(name, title, additionalValues, null, errors);
        if (CollectionUtils.isEmpty(errors)) {
            result.put("id", project.getId());
        } else {
            result.put("error", errors.get(0));
        }
        return result;
    }

    public Project createProject(String name, String title, Map<String, Object> additionalValues, Set<String> modulesIds, List<String> errors) {
        List keywords;
        List categoryTags;
        List tags;
        String defaultProfile;
        String inscriptionStatus;
        String mailingList;
        if (StringUtils.isEmpty((CharSequence)title)) {
            throw new IllegalArgumentException(String.format("Cannot create project. Title is mandatory", new Object[0]));
        }
        ModifiableTraversableAmetysObject projectsRoot = this.getProjectsRoot();
        if (this.hasProject(name)) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(String.format("A project with the name '%s' already exists", name));
            }
            if (errors != null) {
                errors.add("project-exists");
            }
            return null;
        }
        Project project = (Project)projectsRoot.createChild(name, "ametys:project");
        project.setTitle(title);
        String description = additionalValues.getOrDefault("description", null);
        if (StringUtils.isNotEmpty((CharSequence)description)) {
            project.setDescription(description);
        }
        if (StringUtils.isNotEmpty((CharSequence)(mailingList = (String)additionalValues.getOrDefault("emailList", null)))) {
            project.setMailingList(mailingList);
        }
        if (StringUtils.isNotEmpty((CharSequence)(inscriptionStatus = (String)additionalValues.getOrDefault("inscriptionStatus", null)))) {
            project.setInscriptionStatus(inscriptionStatus);
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaultProfile = (String)additionalValues.getOrDefault("defaultProfile", null)))) {
            project.setDefaultProfile(defaultProfile);
        }
        if ((tags = (List)additionalValues.getOrDefault("tags", null)) != null) {
            project.setTags(tags);
        }
        if ((categoryTags = (List)additionalValues.getOrDefault("categoryTags", null)) != null) {
            project.setCategoryTags(categoryTags);
        }
        if ((keywords = (List)additionalValues.getOrDefault("keywords", null)) != null) {
            project.setKeywords(keywords.toArray(new String[keywords.size()]));
        }
        project.setCreationDate(ZonedDateTime.now());
        this._createProjectWorkspace(project, errors);
        this.activateModules(project, modulesIds, additionalValues);
        if (CollectionUtils.isEmpty(errors)) {
            project.saveChanges();
            HashMap<String, Project> eventParams = new HashMap<String, Project>();
            eventParams.put("project", project);
            this._observationManager.notify(new Event("project.added", this._currentUserProvider.getUser(), eventParams));
        } else {
            this.deleteProject(project);
        }
        this.clearCaches();
        return project;
    }

    @Callable(rights={"Plugins_Workspaces_Rights_Project_Edit"}, context="/admin")
    public void editProject(String id, String title, String description, String mailingList, String inscriptionStatus, String defaultProfile) {
        Project project = (Project)this._resolver.resolveById(id);
        this.editProject(project, title, description, mailingList, inscriptionStatus, defaultProfile);
    }

    public void editProject(Project project, String title, String description, String mailingList, String inscriptionStatus, String defaultProfile) {
        this.checkRightsForProjectEdition(project, Project.InscriptionStatus.valueOf(inscriptionStatus.toUpperCase()), null);
        project.setTitle(title);
        if (StringUtils.isNotEmpty((CharSequence)description)) {
            project.setDescription(description);
        } else {
            project.removeDescription();
        }
        if (StringUtils.isNotEmpty((CharSequence)mailingList)) {
            project.setMailingList(mailingList);
        } else {
            project.removeMailingList();
        }
        project.setInscriptionStatus(inscriptionStatus);
        project.setDefaultProfile(defaultProfile);
        project.saveChanges();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("project", (Object)project);
        eventParams.put("projectId", project.getId());
        this._observationManager.notify(new Event("project.updated", this._currentUserProvider.getUser(), eventParams));
    }

    @Callable(rights={"Plugins_Workspaces_Rights_Project_Delete"}, context="/admin")
    public Map<String, Object> deleteProjectsByIds(List<String> ids) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList deleted = new ArrayList();
        ArrayList<String> unknowns = new ArrayList<String>();
        for (String id : ids) {
            try {
                Project project = (Project)this._resolver.resolveById(id);
                HashMap<String, Object> projectInfo = new HashMap<String, Object>();
                projectInfo.put("id", id);
                projectInfo.put("title", project.getTitle());
                projectInfo.put("sites", this.deleteProject(project));
                deleted.add(projectInfo);
            }
            catch (UnknownAmetysObjectException e) {
                this.getLogger().warn(String.format("Unable to delete the definition of id '%s', because it does not exist.", id), (Throwable)e);
                unknowns.add(id);
            }
        }
        result.put("deleted", deleted);
        result.put("unknowns", unknowns);
        return result;
    }

    public List<Map<String, String>> deleteProject(List<Project> projects) {
        ArrayList<Map<String, String>> deletedSitesInfo = new ArrayList<Map<String, String>>();
        for (Project project : projects) {
            deletedSitesInfo.addAll(this.deleteProject(project));
        }
        return deletedSitesInfo;
    }

    public List<Map<String, String>> deleteProject(Project project) {
        ModifiableAmetysObject parent = (ModifiableAmetysObject)project.getParent();
        ArrayList<Map<String, String>> deletedSitesInfo = new ArrayList<Map<String, String>>();
        Site site = project.getSite();
        if (site != null) {
            try {
                HashMap<String, String> siteProps = new HashMap<String, String>();
                siteProps.put("id", site.getId());
                siteProps.put("name", site.getName());
                this._siteDao.deleteSite(site.getId());
                deletedSitesInfo.add(siteProps);
            }
            catch (RepositoryException e) {
                String errorMsg = String.format("Error while trying to delete the site '%s' for the project '%s'.", site.getName(), project.getName());
                this.getLogger().error(errorMsg, (Throwable)e);
            }
        }
        String projectId = project.getId();
        Set<ProjectMemberManager.ProjectMember> projectMembers = this._projectMembers.getProjectMembers(project, true);
        project.remove();
        parent.saveChanges();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("projectId", projectId);
        eventParams.put("project.name", project.getName());
        eventParams.put("project.members", projectMembers);
        this._observationManager.notify(new Event("project.deleted", this._currentUserProvider.getUser(), eventParams));
        this.clearCaches();
        return deletedSitesInfo;
    }

    private <A extends AmetysObject> A _getOrCreateObject(ModifiableTraversableAmetysObject parent, String name, String type) throws AmetysRepositoryException {
        AmetysObject object;
        if (parent.hasChild(name)) {
            object = parent.getChild(name);
        } else {
            object = parent.createChild(name, type);
            parent.saveChanges();
        }
        return (A)object;
    }

    public Project getParentProject(String id) {
        return this.getParentProject(this._resolver.resolveById(id));
    }

    public Project getParentProject(AmetysObject object) {
        AmetysObject ametysObject = object;
        while ((ametysObject = ametysObject.getParent()) instanceof ExplorerNode) {
        }
        if (!(ametysObject instanceof Project)) {
            this.getLogger().warn(String.format("No project found for ametys object with id '%s'", ametysObject.getId()));
            return null;
        }
        return (Project)ametysObject;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public List<String> getProjectsForSite(String siteName) {
        Cache<String, List<Pair<String, String>>> cache = this._getMemorySiteAssociationCache();
        if (cache.hasKey((Object)siteName)) {
            return ((List)cache.get((Object)siteName)).stream().map(p -> (String)p.getRight()).collect(Collectors.toList());
        }
        ArrayList<String> projectNames = new ArrayList<String>();
        if (this._siteManager.hasSite(siteName)) {
            Site site = this._siteManager.getSite(siteName);
            this.getProjectsForSite(site).stream().map(SimpleAmetysObject::getName).forEach(projectNames::add);
        }
        return projectNames;
    }

    public List<Project> getProjectsForSite(Site site) {
        Cache<String, List<Pair<String, String>>> cache = this._getMemorySiteAssociationCache();
        if (cache.hasKey((Object)site.getName())) {
            return ((List)cache.get((Object)site.getName())).stream().map(p -> (Project)this._resolver.resolveById((String)p.getLeft())).collect(Collectors.toList());
        }
        try {
            PropertyIterator propertyIterator = site.getNode().getWeakReferences();
            Iterable propertyIterable = () -> ProjectManager.lambda$getProjectsForSite$27((Iterator)propertyIterator);
            List<Project> projects = StreamSupport.stream(propertyIterable.spliterator(), false).map(p -> {
                block5: {
                    try {
                        Node parent = p.getParent();
                        if (NodeTypeHelper.isNodeType((Node)parent, (String)"ametys:project")) {
                            Project project = (Project)this._resolver.resolve(parent, false);
                            return project;
                        }
                    }
                    catch (Exception e) {
                        if (!this.getLogger().isWarnEnabled()) break block5;
                        String propertyPath = null;
                        try {
                            propertyPath = p.getPath();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String warnMsg = String.format("Site '%s' is pointed by a weak reference '%s' which is not representing a relation with project. This reference is ignored.", site.getName(), propertyPath);
                        this.getLogger().warn(warnMsg);
                    }
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            List projectsPairs = projects.stream().map(p -> Pair.of((Object)p.getId(), (Object)p.getName())).collect(Collectors.toList());
            cache.put((Object)site.getName(), projectsPairs);
            return projects;
        }
        catch (RepositoryException e) {
            this.getLogger().error(String.format("Unable to find projects for site '%s'", site.getName()), (Throwable)e);
            return new ArrayList<Project>();
        }
    }

    protected Site _createProjectWorkspace(Project project, List<String> errors) {
        String initialSiteName = project.getName();
        Site site = null;
        Site catalogSite = this._siteManager.getSite(this.getCatalogSiteName());
        String rootId = catalogSite != null ? catalogSite.getId() : null;
        Map result = this._siteDao.createSite(rootId, initialSiteName, "workspaces.project", true);
        String siteId = (String)result.get("id");
        String siteName = (String)result.get("name");
        if (StringUtils.isNotEmpty((CharSequence)siteId)) {
            site = this._siteManager.getSite(siteName);
            this.setProjectSiteTitle(site, project.getTitle());
            project.setSite(site);
            site.saveChanges();
        }
        return site;
    }

    public List<String> getTags() {
        ModifiableTraversableAmetysObject projectsRootNode = this.getProjectsRoot();
        if (projectsRootNode instanceof JCRAmetysObject) {
            Node node = ((JCRAmetysObject)projectsRootNode).getNode();
            try {
                return Arrays.stream(node.getProperty(__PROJECTS_TAGS_PROPERTY).getValues()).map(LambdaUtils.wrap(Value::getString)).collect(Collectors.toList());
            }
            catch (PathNotFoundException pathNotFoundException) {
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException((Throwable)e);
            }
        }
        return new ArrayList<String>();
    }

    public synchronized void addTags(Collection<String> newTags) {
        ModifiableTraversableAmetysObject projectsRootNode;
        if (CollectionUtils.isNotEmpty(newTags) && (projectsRootNode = this.getProjectsRoot()) instanceof JCRAmetysObject) {
            String[] tags = (String[])Stream.concat(this.getTags().stream(), newTags.stream().map(String::trim).map(String::toLowerCase).filter(StringUtils::isNotEmpty)).distinct().toArray(String[]::new);
            try {
                ((JCRAmetysObject)projectsRootNode).getNode().setProperty(__PROJECTS_TAGS_PROPERTY, tags);
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException((Throwable)e);
            }
        }
    }

    public List<WorkspaceModule> getModules(Project project) {
        return this._moduleManagerEP.getModules().stream().filter(module -> this.isModuleActivated(project, module.getId())).collect(Collectors.toList());
    }

    public Set<Page> getModulePages(Project project, String moduleId) {
        if (this._moduleManagerEP.hasExtension(moduleId)) {
            WorkspaceModule module = (WorkspaceModule)this._moduleManagerEP.getExtension(moduleId);
            return this.getModulePages(project, module);
        }
        return null;
    }

    public Set<ModifiableResourceCollection> pageToModuleRoot(Page page) {
        LinkedHashSet<ModifiableResourceCollection> data = new LinkedHashSet<ModifiableResourceCollection>();
        Page rootPage = page;
        SitemapElement parent = (SitemapElement)page.getParent();
        while (!(parent instanceof Sitemap) && !page.hasValue(__PAGE_MODULES_VALUE)) {
            rootPage = (Page)parent;
            parent = (SitemapElement)parent.getParent();
        }
        String[] modulesRootsIds = (String[])rootPage.getValue(__PAGE_MODULES_VALUE, (Object)new String[0]);
        if (modulesRootsIds.length > 0) {
            for (String moduleRootId : modulesRootsIds) {
                try {
                    ModifiableResourceCollection moduleRoot = (ModifiableResourceCollection)this._resolver.resolveById(moduleRootId);
                    data.add(moduleRoot);
                }
                catch (UnknownAmetysObjectException unknownAmetysObjectException) {
                    // empty catch block
                }
            }
        }
        return data;
    }

    public void tagProjectPage(ModifiablePage page, ModifiableResourceCollection moduleRoot) {
        String[] currentModules = (String[])page.getValue(__PAGE_MODULES_VALUE, (Object)new String[0]);
        LinkedHashSet<String> modules = new LinkedHashSet<String>(Arrays.asList(currentModules));
        modules.add(moduleRoot.getId());
        String[] newModules = new String[modules.size()];
        modules.toArray(newModules);
        page.setValue(__PAGE_MODULES_VALUE, (Object)newModules);
    }

    public void untagProjectPage(ModifiablePage page, ModifiableResourceCollection moduleRoot) {
        if (moduleRoot != null) {
            String[] currentModules = (String[])page.getValue(__PAGE_MODULES_VALUE, (Object)new String[0]);
            LinkedHashSet<String> modules = new LinkedHashSet<String>(Arrays.asList(currentModules));
            modules.remove(moduleRoot.getId());
            String[] newModules = new String[modules.size()];
            modules.toArray(newModules);
            page.setValue(__PAGE_MODULES_VALUE, (Object)newModules);
        }
    }

    public Set<Page> getModulePages(Project project, WorkspaceModule workspaceModule) {
        Request request = this._getRequest();
        if (request == null) {
            return this._computePages(project, workspaceModule);
        }
        Cache<RequestModuleCacheKey, Set<Page>> pagesCache = this._getRequestPageCache();
        String currentWorkspace = this._workspaceSelector.getWorkspace();
        RequestModuleCacheKey pagesKey = RequestModuleCacheKey.of(project.getName(), workspaceModule.getId(), currentWorkspace);
        try {
            return (Set)pagesCache.get((Object)pagesKey, __ -> this._computePages(project, workspaceModule));
        }
        catch (CacheException e) {
            if (e.getCause() instanceof UnknownAmetysObjectException) {
                throw (UnknownAmetysObjectException)e.getCause();
            }
            throw new RuntimeException("An error occurred while computing page of module " + workspaceModule.getModuleName() + " in project " + project.getName(), e);
        }
    }

    private Set<Page> _computePages(Project project, WorkspaceModule workspaceModule) {
        Set pagesUUids = (Set)this._getMemoryPageCache().get((Object)ModuleCacheKey.of(project.getName(), workspaceModule.getId()), __ -> this._computePagesIds(project, workspaceModule));
        if (pagesUUids != null) {
            return pagesUUids.stream().map(uuid -> (Page)this._resolver.resolveById(uuid)).collect(Collectors.toSet());
        }
        throw new UnknownAmetysObjectException("There is no pages for '" + project.getName() + "', module '" + workspaceModule.getModuleName() + "'");
    }

    private Set<String> _computePagesIds(Project project, WorkspaceModule workspaceModule) {
        String siteName;
        Site site = project.getSite();
        String string = siteName = site != null ? site.getName() : null;
        if (StringUtils.isEmpty((CharSequence)siteName)) {
            return null;
        }
        ModifiableResourceCollection moduleRoot = workspaceModule.getModuleRoot(project, false);
        if (moduleRoot != null) {
            StringExpression expression = new StringExpression(__PAGE_MODULES_VALUE, Expression.Operator.EQ, moduleRoot.getId());
            String query = PageQueryHelper.getPageXPathQuery((String)siteName, null, null, (Expression)expression, null);
            return StreamSupport.stream(this._resolver.query(query).spliterator(), false).map(page -> page.getId()).collect(Collectors.toSet());
        }
        return Set.of();
    }

    public void activateModules(Project project, Set<String> moduleIds, Map<String, Object> additionalValues) {
        Set<String> modules = moduleIds == null ? this._moduleManagerEP.getExtensionsIds() : moduleIds;
        for (String moduleId : modules) {
            Object module = this._moduleManagerEP.getModule(moduleId);
            if (module == null || this.isModuleActivated(project, moduleId)) continue;
            module.activateModule(project, additionalValues);
            project.addModule(moduleId);
        }
        this._setDefaultProfileForMembers(project, modules);
        project.saveChanges();
    }

    private void _setDefaultProfileForMembers(Project project, Set<String> modules) {
        String profileForNewModule = StringUtils.defaultString((String)((String)Config.getInstance().getValue("workspaces.profile.new.module")));
        if (profileForNewModule.equals(ProfileForNewModule.DEFAULT_MEMBER_PROFILE.name())) {
            Set<String> defaultProfiles = Set.of(StringUtils.defaultString((String)((String)Config.getInstance().getValue("workspaces.profile.default"))));
            Map<JCRProjectMember, Object> projectMembers = this._projectMembers.getJCRProjectMembers(project);
            for (String moduleId : modules) {
                Object module = this._moduleManagerEP.getModule(moduleId);
                for (JCRProjectMember member : projectMembers.keySet()) {
                    this._projectMembers.setProfileOnModule(member, project, (WorkspaceModule)module, defaultProfiles);
                }
            }
        }
    }

    public void initializeModulesSitemap(Project project, Sitemap sitemap) {
        Set<String> modules = this._moduleManagerEP.getExtensionsIds();
        for (String moduleId : modules) {
            if (!this._moduleManagerEP.hasExtension(moduleId)) continue;
            WorkspaceModule module = (WorkspaceModule)this._moduleManagerEP.getExtension(moduleId);
            if (!this.isModuleActivated(project, moduleId)) continue;
            module.initializeSitemap(project, sitemap);
        }
    }

    public boolean isModuleActivated(Project project, String moduleId) {
        return ArrayUtils.contains((Object[])project.getModules(), (Object)moduleId);
    }

    public void deactivateModules(Project project, Set<String> moduleIds) {
        for (String moduleId : moduleIds) {
            Object module = this._moduleManagerEP.getModule(moduleId);
            if (module == null || !this.isModuleActivated(project, moduleId)) continue;
            module.deactivateModule(project);
            project.removeModule(moduleId);
        }
        project.saveChanges();
    }

    @Callable(rights={"Plugins_Workspaces_Rights_Project_Create_Private", "Plugins_Workspaces_Rights_Project_Create_Public_Moderated", "Plugins_Workspaces_Rights_Project_Create_Public_Opened", "Plugins_Workspaces_Rights_Project_Edit"}, context="/admin")
    public Map<String, Object> getProjectProfiles() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List profiles = this._projectRightHelper.getProfiles().stream().map(p -> p.toJSON()).collect(Collectors.toList());
        result.put("profiles", profiles);
        return result;
    }

    public String getCatalogSiteName() throws UnknownCatalogSiteException {
        String catalogSiteName = (String)Config.getInstance().getValue("workspaces.catalog.site.name");
        if (!this._siteManager.hasSite(catalogSiteName)) {
            throw new UnknownCatalogSiteException("Unknown site '" + catalogSiteName + "'. The global Ametys configuration is invalid for the parameter 'workspaces.catalog.site.name'");
        }
        return catalogSiteName;
    }

    public String getUsersDirectorySiteName() throws UnknownUserDirectorySiteException {
        String udSiteName = (String)Config.getInstance().getValue("workspaces.member.userdirectory.site.name");
        if (!this._siteManager.hasSite(udSiteName)) {
            throw new UnknownUserDirectorySiteException("Unknown site '" + udSiteName + "'. The global Ametys configuration is invalid for the parameter 'workspaces.member.userdirectory.site.name'");
        }
        return udSiteName;
    }

    public boolean supports(Event event) {
        return event.getId().equals("project.deleted") || event.getId().equals("project.updated") || event.getId().equals("project.added") || event.getId().equals("page.added") || event.getId().equals("page.deleted");
    }

    public int getPriority() {
        return 0;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        this.clearCaches();
    }

    public void setProjectSiteTitle(Site site, String title) {
        I18nizableText i18nSiteTitle = new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_DEFAULT_PROJECT_WORKSPACE_TITLE", Arrays.asList(title));
        site.setTitle(this._i18nUtils.translate((I18nizable)i18nSiteTitle));
    }

    private Project _computeProject(String projectName) {
        if (this.hasProject(projectName)) {
            String uuid = this._getUUIDCache().get(projectName);
            return (Project)this._resolver.resolveById(uuid);
        }
        throw new UnknownAmetysObjectException("There is no site named '" + projectName + "'");
    }

    public void checkRightsForProjectCreation(Project.InscriptionStatus inscriptionStatus, ZoneItem zoneItem) {
        SitemapElement catalogPage;
        SitemapElement sitemapElement = catalogPage = zoneItem != null ? zoneItem.getZone().getSitemapElement() : null;
        if (catalogPage != null && !this._projectRightHelper.hasCatalogReadAccess(zoneItem)) {
            throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " tried to create project from page '" + catalogPage.getId() + "' without sufficient rights");
        }
        switch (inscriptionStatus) {
            case PRIVATE: {
                boolean hasRightToCreatePrivateProjetOnPages;
                boolean bl = catalogPage != null ? this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Private", (Object)catalogPage) == RightManager.RightResult.RIGHT_ALLOW : (hasRightToCreatePrivateProjetOnPages = false);
                if (hasRightToCreatePrivateProjetOnPages || this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Private", (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW) break;
                throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " tried to create private project without sufficient rights");
            }
            case MODERATED: {
                boolean hasRightToCreateModeratedProjetOnPages;
                boolean bl = catalogPage != null ? this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Public_Moderated", (Object)catalogPage) == RightManager.RightResult.RIGHT_ALLOW : (hasRightToCreateModeratedProjetOnPages = false);
                if (hasRightToCreateModeratedProjetOnPages || this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Public_Moderated", (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW) break;
                throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " tried to create public project with moderation without sufficient rights");
            }
            case OPEN: {
                boolean hasRightToCreateOpenProjetOnPages;
                boolean bl = catalogPage != null ? this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Public_Opened", (Object)catalogPage) == RightManager.RightResult.RIGHT_ALLOW : (hasRightToCreateOpenProjetOnPages = false);
                if (hasRightToCreateOpenProjetOnPages || this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Public_Opened", (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW) break;
                throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " tried to create public project without sufficient rights");
            }
            default: {
                throw new IllegalArgumentException("Inscription status '" + inscriptionStatus.toString() + "' is unknown");
            }
        }
    }

    public void checkRightsForProjectEdition(Project project, Project.InscriptionStatus inscriptionStatus, ZoneItem zoneItem) {
        SitemapElement catalogPage;
        Project.InscriptionStatus oldInscriptionStatus = project.getInscriptionStatus();
        SitemapElement sitemapElement = catalogPage = zoneItem != null ? zoneItem.getZone().getSitemapElement() : null;
        if (catalogPage != null && !this._projectRightHelper.hasCatalogReadAccess(zoneItem)) {
            throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " tried to edit project from page '" + catalogPage.getId() + "' without sufficient rights");
        }
        if (oldInscriptionStatus != inscriptionStatus) {
            boolean canCreatePrivateProjet = this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Private", (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW || catalogPage != null && this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Private", (Object)catalogPage) == RightManager.RightResult.RIGHT_ALLOW;
            boolean canCreatePublicProjetWithModeration = this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Public_Moderated", (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW || catalogPage != null && this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Public_Moderated", (Object)catalogPage) == RightManager.RightResult.RIGHT_ALLOW;
            boolean canCreatePublicProjet = this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Public_Opened", (Object)"/${WorkspaceName}") == RightManager.RightResult.RIGHT_ALLOW || catalogPage != null && this._rightManager.currentUserHasRight("Plugins_Workspaces_Rights_Project_Create_Public_Opened", (Object)catalogPage) == RightManager.RightResult.RIGHT_ALLOW;
            switch (oldInscriptionStatus) {
                case PRIVATE: {
                    if (canCreatePrivateProjet) break;
                    throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " tried to edit private project without sufficient rights");
                }
                case MODERATED: {
                    if (canCreatePublicProjetWithModeration) break;
                    throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " tried to edit public project with moderation without sufficient rights");
                }
                case OPEN: {
                    if (canCreatePublicProjet) break;
                    throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " tried to edit public project without sufficient rights");
                }
                default: {
                    throw new IllegalArgumentException("Inscription status '" + oldInscriptionStatus.toString() + "' is unknown");
                }
            }
            switch (inscriptionStatus) {
                case PRIVATE: {
                    if (canCreatePrivateProjet) break;
                    throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " tried to edit project to private project without sufficient rights");
                }
                case MODERATED: {
                    if (canCreatePublicProjetWithModeration) break;
                    throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " tried to edit project to public project with moderation without sufficient rights");
                }
                case OPEN: {
                    if (canCreatePublicProjet) break;
                    throw new AccessDeniedException("User " + String.valueOf(this._currentUserProvider.getUser()) + " tried to edit project to public project without sufficient rights");
                }
                default: {
                    throw new IllegalArgumentException("Inscription status '" + inscriptionStatus.toString() + "' is unknown");
                }
            }
        }
    }

    public void clearCaches() {
        this._getMemorySiteAssociationCache().invalidateAll();
        this._getMemoryProjectCache().invalidateAll();
        this._getMemoryPageCache().invalidateAll();
        this._getRequestProjectCache().invalidateAll();
        this._getRequestPageCache().invalidateAll();
    }

    private Cache<String, List<Pair<String, String>>> _getMemorySiteAssociationCache() {
        return this._cacheManager.get(MEMORY_SITEASSOCIATION_CACHE);
    }

    private Cache<String, String> _getMemoryProjectCache() {
        return this._cacheManager.get(MEMORY_PROJECTIDBYNAMECACHE);
    }

    private Cache<ModuleCacheKey, Set<String>> _getMemoryPageCache() {
        return this._cacheManager.get(MEMORY_PAGESBYIDCACHE);
    }

    private Cache<RequestProjectCacheKey, Project> _getRequestProjectCache() {
        return this._cacheManager.get(REQUEST_PROJECTBYID_CACHE);
    }

    private Cache<RequestModuleCacheKey, Set<Page>> _getRequestPageCache() {
        return this._cacheManager.get(REQUEST_PAGESBYPROJECTANDMODULE_CACHE);
    }

    protected void _createCaches() {
        this._cacheManager.createMemoryCache(MEMORY_SITEASSOCIATION_CACHE, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CACHE_PROJECT_MANAGER_LABEL"), new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CACHE_PROJECT_MANAGER_DESCRIPTION"), true, null);
        this._cacheManager.createMemoryCache(MEMORY_PROJECTIDBYNAMECACHE, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_MANAGER_UUID_CACHE_LABEL"), new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_MANAGER_UUID_CACHE_DESCRIPTION"), true, null);
        this._cacheManager.createMemoryCache(MEMORY_PAGESBYIDCACHE, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_MANAGER_PAGEUUID_CACHE_LABEL"), new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_MANAGER_PAGEUUID_CACHE_DESCRIPTION"), true, null);
        this._cacheManager.createRequestCache(REQUEST_PROJECTBYID_CACHE, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_MANAGER_REQUEST_CACHE_LABEL"), new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_MANAGER_REQUEST_CACHE_DESCRIPTION"), false);
        this._cacheManager.createRequestCache(REQUEST_PAGESBYPROJECTANDMODULE_CACHE, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_MANAGER_PAGEREQUEST_CACHE_LABEL"), new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_MANAGER_PAGEREQUEST_CACHE_DESCRIPTION"), false);
    }

    private synchronized Map<String, String> _getUUIDCache() {
        if (!this._getMemoryProjectCache().hasKey((Object)__IS_CACHE_FILLED)) {
            Session defaultSession = null;
            try {
                defaultSession = this._repository.login("default");
                String jcrQuery = "//element(*, ametys:project)";
                AmetysObjectIterable projects = this._resolver.query(jcrQuery, defaultSession);
                for (Project project : projects) {
                    this._getMemoryProjectCache().put((Object)project.getName(), (Object)project.getId());
                }
                this._getMemoryProjectCache().put((Object)__IS_CACHE_FILLED, null);
            }
            catch (RepositoryException e) {
                throw new AmetysRepositoryException((Throwable)e);
            }
            finally {
                if (defaultSession != null) {
                    defaultSession.logout();
                }
            }
        }
        Map cacheAsMap = this._getMemoryProjectCache().asMap();
        cacheAsMap.remove(__IS_CACHE_FILLED);
        return cacheAsMap;
    }

    private Request _getRequest() {
        try {
            return (Request)this._context.get((Object)"object-model.request");
        }
        catch (ContextException ce) {
            this.getLogger().info("Unable to get the request", (Throwable)ce);
            return null;
        }
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public List<Map<String, Object>> getProjectsStatisticsForClientSide() {
        return this.getProjects().stream().map(p -> this.getProjectStatistics((Project)((Object)p))).collect(Collectors.toList());
    }

    public Map<String, Object> getProjectStatistics(Project project) {
        HashMap<String, Object> statistics = new HashMap<String, Object>();
        statistics.put("title", project.getTitle());
        long totalSize = 0L;
        for (WorkspaceModule moduleManager : this._moduleManagerEP.getModules()) {
            Map<String, Object> moduleStatistics = moduleManager.getStatistics(project);
            statistics.putAll(moduleStatistics);
            Long size = (Long)moduleStatistics.get(moduleManager.getModuleSizeKey());
            totalSize += size != null && size >= 0L ? (Long)moduleStatistics.get(moduleManager.getModuleSizeKey()) : 0L;
        }
        statistics.put("totalSize", totalSize);
        ZonedDateTime creationDate = project.getCreationDate();
        statistics.put("creationDate", creationDate);
        statistics.put("managers", Arrays.stream(project.getManagers()).map(u -> this._userHelper.user2json(u)).collect(Collectors.toList()));
        return statistics;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public List<Map<String, Object>> getProjectsStatisticsColumnsModel() {
        return this.getStatisticHeaders().stream().map(p -> p.convertToJSON()).collect(Collectors.toList());
    }

    private List<StatisticColumn> getStatisticHeaders() {
        List<StatisticColumn> flatStatisticHeaders = this.getFlatStatisticHeaders();
        ArrayList<StatisticColumn> headers = new ArrayList<StatisticColumn>();
        for (StatisticColumn statisticColumn : flatStatisticHeaders) {
            if (statisticColumn.getGroup() != null) {
                Optional<StatisticColumn> parent = flatStatisticHeaders.stream().filter(column -> column.getId().equals(statisticColumn.getGroup())).findAny();
                if (!parent.isPresent()) continue;
                parent.get().addSubColumn(statisticColumn);
                continue;
            }
            headers.add(statisticColumn);
        }
        return headers;
    }

    private List<StatisticColumn> getFlatStatisticHeaders() {
        ArrayList<StatisticColumn> headers = new ArrayList<StatisticColumn>();
        headers.add(new StatisticColumn("title", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_TITLE")).withType(StatisticsColumnType.STRING).withWidth(200).withRenderer("Ametys.plugins.workspaces.project.tool.ProjectsGridHelper.renderTitle"));
        headers.add(new StatisticColumn("creationDate", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_CREATION")).withType(StatisticsColumnType.DATE).withWidth(150));
        headers.add(new StatisticColumn("managers", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_MANAGERS")).withRenderer("Ametys.grid.GridColumnHelper.renderUser").withFilter(false));
        for (WorkspaceModule moduleManager : this._moduleManagerEP.getModules()) {
            headers.addAll(moduleManager.getStatisticModel());
        }
        StatisticColumn elements = new StatisticColumn("general$elements", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_ELEMENTS")).withFilter(false);
        headers.add(elements);
        StatisticColumn activatedModules = new StatisticColumn("general$activated", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_ACTIVE_MODULES")).isHidden(true).withFilter(false);
        headers.add(activatedModules);
        StatisticColumn lastActivity = new StatisticColumn("general$lastActivity", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_LAST_ACTIVITY")).isHidden(true);
        headers.add(lastActivity);
        StatisticColumn modulesSize = new StatisticColumn("general$size", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_MODULES_SIZE")).withFilter(false);
        modulesSize.addSubColumn(new StatisticColumn("totalSize", new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_MODULES_SIZE_TOTAL")).withRenderer("Ametys.plugins.workspaces.project.tool.ProjectsGridHelper.renderSize").withType(StatisticsColumnType.LONG));
        headers.add(modulesSize);
        return headers;
    }

    public boolean isUserInProjectPopulations(Project project, UserIdentity user) {
        Site site = project.getSite();
        if (site == null) {
            throw new IllegalArgumentException("Cannot determine if user " + UserIdentity.userIdentityToString((UserIdentity)user) + " can connect to the project " + project.getName() + " since the project has no associated site to determine the populations");
        }
        String siteName = site.getName();
        Set populations = this._populationContextHelper.getUserPopulationsOnContext("/sites/" + siteName, false);
        Set frontPopulations = this._populationContextHelper.getUserPopulationsOnContext("/sites-fo/" + siteName, false);
        return populations.contains(user.getPopulationId()) || frontPopulations.contains(user.getPopulationId());
    }

    private static /* synthetic */ Iterator lambda$getProjectsForSite$27(Iterator propertyIterator) {
        return propertyIterator;
    }

    private static final class RequestProjectCacheKey
    extends AbstractCacheKey {
        private RequestProjectCacheKey(String projectName, String workspaceName) {
            super(new Object[]{projectName, workspaceName});
        }

        static RequestProjectCacheKey of(String projectName, String workspaceName) {
            return new RequestProjectCacheKey(projectName, workspaceName);
        }
    }

    private static final class RequestModuleCacheKey
    extends AbstractCacheKey {
        private RequestModuleCacheKey(String projectName, String moduleId, String workspaceName) {
            super(new Object[]{projectName, moduleId, workspaceName});
        }

        static RequestModuleCacheKey of(String projectName, String moduleId, String workspaceName) {
            return new RequestModuleCacheKey(projectName, moduleId, workspaceName);
        }
    }

    private static final class ModuleCacheKey
    extends AbstractCacheKey {
        private ModuleCacheKey(String projectName, String moduleId) {
            super(new Object[]{projectName, moduleId});
        }

        static ModuleCacheKey of(String projectName, String moduleId) {
            return new ModuleCacheKey(projectName, moduleId);
        }
    }

    public static enum ProfileForNewModule {
        NONE,
        DEFAULT_MEMBER_PROFILE;

    }

    public class UnknownCatalogSiteException
    extends IllegalArgumentException {
        public UnknownCatalogSiteException(String message) {
            super(message);
        }
    }

    public class UnknownUserDirectorySiteException
    extends IllegalArgumentException {
        public UnknownUserDirectorySiteException(String message) {
            super(message);
        }
    }
}

