/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.enumerators;

import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.languages.Language;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ProjectLanguagesEnumerator
extends AbstractLogEnabled
implements Enumerator<String>,
Serviceable {
    private LanguagesManager _languagesManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._languagesManager = (LanguagesManager)manager.lookup(LanguagesManager.ROLE);
    }

    public I18nizableText getEntry(String code) throws Exception {
        Language language = this._languagesManager.getLanguage(code);
        return language != null ? language.getLabel() : null;
    }

    public Map<String, I18nizableText> getEntries() throws Exception {
        HashMap<String, I18nizableText> result = new HashMap<String, I18nizableText>();
        Map availableLanguages = this._languagesManager.getAvailableLanguages();
        for (Language availableLanguage : availableLanguages.values()) {
            result.put(availableLanguage.getCode(), availableLanguage.getLabel());
        }
        return result;
    }
}

