/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.generators;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SummaryMailNotifierGenerator
extends ActionResultGenerator
implements Serviceable {
    private ProjectManager _projectManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        Map parentContextAttr = (Map)this.objectModel.get("parent-context");
        String frequency = (String)parentContextAttr.get("frequency");
        Map activitiesByProject = (Map)parentContextAttr.get("activities");
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("frequency", frequency);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"notification", (Attributes)attrs);
        for (Map.Entry entry : activitiesByProject.entrySet()) {
            String projectName = (String)entry.getKey();
            Project project = this._projectManager.getProject(projectName);
            if (project == null) continue;
            attrs = new AttributesImpl();
            attrs.addCDATAAttribute("name", projectName);
            attrs.addCDATAAttribute("title", project.getTitle());
            attrs.addCDATAAttribute("url", this._projectManager.getProjectUrl(project, null));
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"project", (Attributes)attrs);
            Map activitiesByType = (Map)entry.getValue();
            for (Map.Entry entry2 : activitiesByType.entrySet()) {
                String eventType = (String)entry2.getKey();
                attrs.clear();
                attrs.addCDATAAttribute("type", eventType);
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"events", (Attributes)attrs);
                for (Map activityJSON : (List)entry2.getValue()) {
                    this._saxActivity(activityJSON);
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"events");
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"project");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"notification");
        this.contentHandler.endDocument();
    }

    private void _saxActivity(Map<String, Object> activityJSON) throws ProcessingException, IOException, SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"event");
        for (Map.Entry<String, Object> entry : activityJSON.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.saxMapItem(key, value);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"event");
    }

    protected void saxMapItem(String key, Object value) throws IOException, SAXException, ProcessingException {
        if (value instanceof Date) {
            Date date = (Date)value;
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)key, (String)DateUtils.dateToString((Date)date));
        } else {
            super.saxMapItem(key, value);
        }
    }
}

