/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.notification;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ametys.core.observation.Event;
import org.ametys.core.user.User;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.workspaces.project.notification.AbstractMemberMailNotifierObserver;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RemoveMemberMailManagersNotifierObserver
extends AbstractMemberMailNotifierObserver {
    public boolean supports(Event event) {
        return event.getId().equals("member.deleted");
    }

    @Override
    protected String getMailBodyURI(Event event, Project project) {
        return "cocoon://_plugins/workspaces/notification-mail-member-removed-manager";
    }

    @Override
    protected Map<String, List<String>> getUserToNotifyByLanguage(Event event, Project project) {
        return Arrays.stream(project.getManagers()).map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).filter(Objects::nonNull).map(user -> Pair.of((Object)user, (Object)user.getEmail())).filter(p -> StringUtils.isNotEmpty((String)((String)p.getRight()))).collect(Collectors.groupingBy(p -> StringUtils.defaultString((String)((User)p.getLeft()).getLanguage()), Collectors.mapping(Pair::getRight, Collectors.toList())));
    }

    @Override
    protected I18nizableText getI18nSubject(Event event, Project project) {
        return new I18nizableText("plugin." + this._pluginName, "PROJECT_MAIL_MANAGER_NOTIFICATION_SUBJECT_MEMBER_DELETED", List.of(project.getTitle()));
    }
}

