/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.notification.schedule;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.right.RightManager;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.user.User;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.DateExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.notification.preferences.NotificationPreferencesHelper;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.web.WebConstants;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.quartz.JobExecutionContext;

public abstract class AbstractSendNotificationSummarySchedulable
extends AbstractStaticSchedulable {
    protected ProjectManager _projectManager;
    protected NotificationPreferencesHelper _notificationPrefHelper;
    private I18nUtils _i18nUtils;
    private ProjectMemberManager _projectMemberManager;
    private RenderingContextHandler _renderingContextHandler;
    private AmetysObjectResolver _resolver;
    private RightManager _rightManager;
    private SiteManager _siteManager;
    private SourceResolver _srcResolver;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._projectMemberManager = (ProjectMemberManager)((Object)manager.lookup(ProjectMemberManager.ROLE));
        this._renderingContextHandler = (RenderingContextHandler)manager.lookup(RenderingContextHandler.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._srcResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._notificationPrefHelper = (NotificationPreferencesHelper)((Object)manager.lookup(NotificationPreferencesHelper.ROLE));
    }

    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        List<Map<String, Object>> activitiesInTimeFrame = this._getAggregatedActivitiesInTimeFrame();
        if (activitiesInTimeFrame.size() == 0) {
            return;
        }
        Set<User> userToNotify = this._getUserToNotify();
        for (User user : userToNotify) {
            Map<String, Map<String, List<Map<String, Object>>>> userActivitiesInTimeFrame = this._getActivitiesByProject(user, activitiesInTimeFrame);
            if (userActivitiesInTimeFrame.isEmpty()) continue;
            String lang = (String)StringUtils.defaultIfBlank((CharSequence)user.getLanguage(), (CharSequence)this._userLanguagesManager.getDefaultLanguage());
            String mailSubject = this._i18nUtils.translate(this.getI18nSubject(), lang);
            String mailBody = this._getMailBody(user, userActivitiesInTimeFrame, lang);
            SendMailHelper.newMail().withRecipient(user.getEmail()).withSubject(mailSubject).withHTMLBody(mailBody).withInlineCSS(false).withAsync(true).sendMail();
        }
    }

    private List<Map<String, Object>> _getAggregatedActivitiesInTimeFrame() {
        StringExpression projectExpr = new StringExpression("projectName", Expression.Operator.NE, "");
        ZonedDateTime frameLimit = this.getTimeFrameLimit();
        DateExpression dateExpr = new DateExpression("date", Expression.Operator.GE, frameLimit);
        AndExpression finalExpr = new AndExpression(new Expression[]{projectExpr, dateExpr});
        String query = ActivityHelper.getActivityXPathQuery((Expression)finalExpr);
        try (AmetysObjectIterable activities = this._resolver.query(query);){
            ArrayList<Map<String, Object>> activitiesAsJSON = new ArrayList<Map<String, Object>>();
            for (Activity activity : activities) {
                try {
                    activitiesAsJSON.add(activity.toJSONForClient());
                }
                catch (Exception e) {
                    this.getLogger().warn("An error occurred while serializing activity '{}'. The activity will be ignored in the notification summary", (Object)activity.getId(), (Object)e);
                }
            }
            Object object = this._aggregateActivities(activitiesAsJSON);
            return object;
        }
    }

    private List<Map<String, Object>> _aggregateActivities(List<Map<String, Object>> activities) {
        ArrayList<Map<String, Object>> aggregatedActivities = new ArrayList<Map<String, Object>>();
        for (Map map : activities) {
            List sameActivities = aggregatedActivities.stream().filter(e -> this._isAlreadyPresent(activity, (Map<String, Object>)e)).collect(Collectors.toList());
            if (sameActivities.size() == 0) {
                aggregatedActivities.add(map);
                continue;
            }
            try {
                Map finalActivity = map;
                ZonedDateTime finalActivityDate = DateUtils.parseZonedDateTime((String)((String)finalActivity.get("date")));
                boolean multipleAuthor = false;
                int nbOfOccurrence = 1;
                for (Map sameActivity : sameActivities) {
                    ZonedDateTime activityDate;
                    nbOfOccurrence = sameActivity.get("nbOfOccurence") != null ? (nbOfOccurrence += ((Integer)sameActivity.get("nbOfOccurrence")).intValue()) : ++nbOfOccurrence;
                    if (!multipleAuthor && !finalActivity.get("author").equals(sameActivity.get("author"))) {
                        multipleAuthor = true;
                    }
                    if (!(activityDate = DateUtils.parseZonedDateTime((String)((String)sameActivity.get("date")))).isAfter(finalActivityDate)) continue;
                    finalActivity = sameActivity;
                    finalActivityDate = activityDate;
                }
                if (multipleAuthor) {
                    finalActivity.remove("author");
                }
                aggregatedActivities.removeAll(sameActivities);
                finalActivity.put((String)"nbOfOccurrence", nbOfOccurrence);
                aggregatedActivities.add(finalActivity);
            }
            catch (Exception e2) {
                this.getLogger().warn("An error occurred while trying to aggregate activity '{}'. The activity will be added as is.", map.get("id"), (Object)e2);
                aggregatedActivities.add(map);
            }
        }
        return aggregatedActivities;
    }

    private boolean _isAlreadyPresent(Map<String, Object> activity, Map<String, Object> activity2) {
        if (!activity.get("projectName").equals(activity2.get("projectName"))) {
            return false;
        }
        if (!activity.get("type").equals(activity2.get("type"))) {
            return false;
        }
        String type = (String)activity.get("type");
        switch (StringUtils.substringBefore((String)type, (String)".")) {
            case "calendar": {
                return this._calendarActivityAlreadyPresent(activity, activity2);
            }
            case "member": {
                return this._memberActivityAlreadyPresent(activity, activity2);
            }
            case "task": {
                return this._taskActivityAlreadyPresent(activity, activity2);
            }
            case "resource": {
                if ("resource.commented".equals(type)) {
                    return false;
                }
                return this._resourceActivityAlreadyPresent(activity, activity2);
            }
            case "wallcontent": {
                return this._wallContentActivityAlreadyPresent(activity, activity2);
            }
            case "minisite": {
                return this._minisiteActivityAlreadyPresent(activity, activity2);
            }
            case "forumthread": {
                if ("forumthread.commented".equals(type)) {
                    return false;
                }
                return this._forumActivityAlreadyPresent(activity, activity2);
            }
        }
        return false;
    }

    private boolean _wallContentActivityAlreadyPresent(Map<String, Object> activity, Map<String, Object> activity2) {
        if (activity.get("contentId") != null && activity2.get("contentId") != null) {
            return activity.get("contentId").equals(activity2.get("contentId"));
        }
        return false;
    }

    private boolean _resourceActivityAlreadyPresent(Map<String, Object> activity, Map<String, Object> activity2) {
        List<Map<String, Object>> fileList2 = this._getFiles(activity2);
        List<Map<String, Object>> fileList = this._getFiles(activity);
        if (fileList.size() == 1 && fileList2.size() == 1) {
            Object file1 = fileList.get(0).get("id");
            Object file2 = fileList2.get(0).get("id");
            return file1 != null && file2 != null && file1.equals(file2);
        }
        return false;
    }

    private List<Map<String, Object>> _getFiles(Map<String, Object> activity) {
        if (activity.get("file") != null) {
            Map file = (Map)activity.get("file");
            return List.of(file);
        }
        if (activity.get("files") != null) {
            List files = (List)activity.get("files");
            return files;
        }
        return List.of();
    }

    private boolean _taskActivityAlreadyPresent(Map<String, Object> activity, Map<String, Object> activity2) {
        if (activity.get("taskId") != null && activity2.get("taskId") != null) {
            return activity.get("taskId").equals(activity2.get("taskId"));
        }
        return false;
    }

    private boolean _memberActivityAlreadyPresent(Map<String, Object> event, Map<String, Object> event2) {
        if (event.get("member") != null && event2.get("member") != null) {
            return event.get("member").equals(event2.get("member"));
        }
        return false;
    }

    private boolean _calendarActivityAlreadyPresent(Map<String, Object> activity, Map<String, Object> activity2) {
        if (activity.get("eventId") != null && activity2.get("eventId") != null) {
            return activity.get("eventId").equals(activity2.get("eventId"));
        }
        return false;
    }

    private boolean _minisiteActivityAlreadyPresent(Map<String, Object> activity, Map<String, Object> activity2) {
        if (activity.get("pageId") != null && activity2.get("pageId") != null) {
            return activity.get("pageId").equals(activity2.get("pageId"));
        }
        return false;
    }

    private boolean _forumActivityAlreadyPresent(Map<String, Object> event, Map<String, Object> event2) {
        if (event.get("threadId") != null && event2.get("threadId") != null) {
            return event.get("threadId").equals(event2.get("threadId"));
        }
        return false;
    }

    protected abstract ZonedDateTime getTimeFrameLimit();

    private Set<User> _getUserToNotify() {
        HashSet users = new HashSet();
        try (AmetysObjectIterable<Project> projects = this._projectManager.getProjects();){
            for (Project project : projects) {
                Set<ProjectMemberManager.ProjectMember> projectMembers = this._projectMemberManager.getProjectMembers(project, true);
                Set projectUsers = projectMembers.stream().map(ProjectMemberManager.ProjectMember::getUser).collect(Collectors.toSet());
                users.addAll(projectUsers);
            }
            Object object = users.stream().filter(user -> StringUtils.isNotEmpty((CharSequence)user.getEmail())).filter(user -> this._notificationPrefHelper.hasFrequencyInPreferences((User)user, this.getFrequency())).collect(Collectors.toSet());
            return object;
        }
    }

    protected abstract NotificationPreferencesHelper.Frequency getFrequency();

    private Map<String, Map<String, List<Map<String, Object>>>> _getActivitiesByProject(User user, List<Map<String, Object>> activitiesInTimeFrame) {
        Set<String> projectNames = this._notificationPrefHelper.getUserProjectsWithFrequency(user, this.getFrequency());
        HashMap<String, Map<String, List<Map<String, Object>>>> userActivities = new HashMap<String, Map<String, List<Map<String, Object>>>>();
        for (String projectName : projectNames) {
            try {
                Set<String> allowedType = this._getAllowedEventTypes(user, projectName);
                Map<String, List<Map<String, Object>>> userActivitiesByType = this._getUserProjectActivities(projectName, allowedType, activitiesInTimeFrame);
                if (userActivitiesByType.isEmpty()) continue;
                userActivities.put(projectName, userActivitiesByType);
            }
            catch (UnknownAmetysObjectException e) {
                this._notificationPrefHelper.deleteProjectNotificationPreferences(user.getIdentity(), projectName);
            }
        }
        return userActivities;
    }

    private Set<String> _getAllowedEventTypes(User user, String projectName) {
        Project project = this._projectManager.getProject(projectName);
        if (project == null) {
            return Set.of();
        }
        HashSet<String> allowedTypes = new HashSet<String>();
        for (WorkspaceModule module : this._projectManager.getModules(project)) {
            ModifiableResourceCollection moduleRoot = module.getModuleRoot(project, false);
            if (moduleRoot == null || !this._rightManager.hasReadAccess(user.getIdentity(), (Object)moduleRoot)) continue;
            allowedTypes.addAll(module.getAllowedEventTypes());
        }
        return allowedTypes;
    }

    private Map<String, List<Map<String, Object>>> _getUserProjectActivities(String projectName, Set<String> allowedType, List<Map<String, Object>> activitiesInTimeFrame) {
        HashMap<String, List<Map<String, Object>>> userActivitiesByType = new HashMap<String, List<Map<String, Object>>>();
        for (Map<String, Object> activityJSON : activitiesInTimeFrame) {
            String eventType = (String)activityJSON.get("type");
            Object project = activityJSON.get("projectName");
            if (project == null || !allowedType.contains(eventType) || !project.equals(projectName)) continue;
            if (!userActivitiesByType.containsKey(eventType)) {
                userActivitiesByType.put(eventType, new ArrayList());
            }
            ((List)userActivitiesByType.get(eventType)).add(activityJSON);
        }
        return userActivitiesByType;
    }

    protected abstract I18nizable getI18nSubject();

    /*
     * Loose catch block
     */
    private String _getMailBody(User user, Map<String, Map<String, List<Map<String, Object>>>> activities, String lang) {
        String string;
        InputStream is;
        RenderingContext currentContext;
        Source source;
        block12: {
            source = null;
            currentContext = this._renderingContextHandler.getRenderingContext();
            Request request = ContextHelper.getRequest((Context)this._context);
            this._renderingContextHandler.setRenderingContext(RenderingContext.FRONT);
            request.setAttribute("lang", (Object)lang);
            String siteName = this._projectManager.getCatalogSiteName();
            Site site = this._siteManager.getSite(siteName);
            request.setAttribute("forceAbsoluteUrl", (Object)true);
            request.setAttribute(WebConstants.REQUEST_ATTR_SITE, (Object)site);
            request.setAttribute("site", (Object)siteName);
            request.setAttribute("skin", (Object)site.getSkinId());
            source = this._srcResolver.resolveURI("cocoon://_plugins/workspaces/notification-mail-summary.html", null, Map.of("frequency", this.getFrequency().name(), "activities", activities, "user", user));
            is = source.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            SourceUtil.copy((InputStream)is, (OutputStream)bos);
            string = bos.toString("UTF-8");
            if (is == null) break block12;
            is.close();
        }
        this._renderingContextHandler.setRenderingContext(currentContext);
        if (source != null) {
            this._srcResolver.release(source);
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to get mail body for workspaces notifications", e);
                    }
                }
                catch (Throwable throwable3) {
                    this._renderingContextHandler.setRenderingContext(currentContext);
                    if (source != null) {
                        this._srcResolver.release(source);
                    }
                    throw throwable3;
                }
            }
        }
    }
}

