/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.rights.accesscontroller;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.ProfileAssignmentStorage;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.right.AbstractRightBasedAccessController;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.rights.ProjectRightHelper;
import org.ametys.plugins.workspaces.project.rights.accesscontroller.ProjectAccessController;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.tuple.Pair;

public class ModuleAccessController
extends AbstractRightBasedAccessController
implements Serviceable {
    private static Pattern __MODULE_ROOT_PATH_PATTERN = Pattern.compile("^(/ametys:plugins/workspaces/projects/(?:[^/]+)/ametys-internal:resources/(?:[^/]+)).*$");
    protected ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageEP;
    protected ProjectRightHelper _projectRightHelper;
    protected AmetysObjectResolver _resolver;
    protected WorkspaceModuleExtensionPoint _moduleEP;
    protected ProjectManager _projectManager;
    protected RightProfilesDAO _profileDAO;
    protected SiteManager _siteManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._profileAssignmentStorageEP = (ProfileAssignmentStorageExtensionPoint)manager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
        this._profileDAO = (RightProfilesDAO)manager.lookup(RightProfilesDAO.ROLE);
        this._projectRightHelper = (ProjectRightHelper)((Object)manager.lookup(ProjectRightHelper.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._moduleEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
    }

    public boolean supports(Object object) {
        if (object instanceof AmetysObject) {
            String path = ((AmetysObject)object).getPath();
            return path.startsWith("/ametys:plugins/workspaces/projects/") && path.contains("/ametys-internal:resources/");
        }
        return false;
    }

    private boolean _isModuleActivated(ResourceCollection moduleRoot) {
        Project project = (Project)moduleRoot.getParent().getParent();
        WorkspaceModule module = this._moduleEP.getModuleByName(moduleRoot.getName());
        if (module == null) {
            throw new IllegalStateException("Can not find module from the module root name '" + moduleRoot.getName() + "'");
        }
        return this._projectManager.isModuleActivated(project, module.getId());
    }

    private ModifiableResourceCollection _getModuleRoot(Object object) {
        AmetysObject node = (AmetysObject)object;
        Matcher matcher = __MODULE_ROOT_PATH_PATTERN.matcher(node.getPath());
        if (matcher.matches()) {
            String rootPath = matcher.group(1);
            if (node.getPath().equals(rootPath)) {
                return (ModifiableResourceCollection)node;
            }
            return (ModifiableResourceCollection)this._resolver.resolveByPath(rootPath);
        }
        throw new IllegalArgumentException("Node " + node.getPath() + " is not a module path");
    }

    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        ModifiableResourceCollection root = this._getModuleRoot(object);
        if (!this._isModuleActivated((ResourceCollection)root)) {
            return AccessController.AccessResult.UNKNOWN;
        }
        return this._profileAssignmentStorageEP.getPermissions(user, userGroups, this._projectRightHelper.getProfilesIds(), (Object)root).values().stream().anyMatch(ar -> ar.toRightResult() == RightManager.RightResult.RIGHT_ALLOW) ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.UNKNOWN;
    }

    public AccessExplanation explainReadAccessPermission(UserIdentity user, Set<GroupIdentity> groups, Object object) {
        return this._explain(this._getModuleRoot(object), AccessController.AccessResult.USER_ALLOWED, AccessController.AccessResult.UNKNOWN, root -> {
            Set grantingProfile = this._profileAssignmentStorageEP.getPermissions(user, groups, this._projectRightHelper.getProfilesIds(), root).entrySet().stream().filter(entry -> ((AccessController.AccessResult)entry.getValue()).toRightResult() == RightManager.RightResult.RIGHT_ALLOW).map(Map.Entry::getKey).collect(Collectors.toSet());
            return Pair.of(grantingProfile, Set.of());
        });
    }

    private AccessExplanation _explain(ModifiableResourceCollection root, AccessController.AccessResult grantedPermission, AccessController.AccessResult deniedPermission, Function<ModifiableResourceCollection, Pair<Set<String>, Set<String>>> profileSupplier) {
        Object i18nkey;
        AccessController.AccessResult permission;
        HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
        i18nParams.put("module", this._moduleEP.getModuleByName(root.getName()).getModuleTitle());
        if (!this._isModuleActivated((ResourceCollection)root)) {
            permission = AccessController.AccessResult.UNKNOWN;
            i18nkey = "PLUGINS_WORKSPACES_MODULE_ACCESS_CONTROLLER_DISABLED_MODULE_EXPLANATION";
        } else {
            Pair<Set<String>, Set<String>> assignedProfiles = profileSupplier.apply(root);
            if (!((Set)assignedProfiles.getRight()).isEmpty()) {
                permission = deniedPermission;
                i18nkey = "PLUGINS_WORKSPACES_MODULE_ACCESS_CONTROLLER_" + deniedPermission.name() + "_EXPLANATION";
                Set denyingProfiles = ((Set)assignedProfiles.getRight()).stream().map(arg_0 -> ((RightProfilesDAO)this._profileDAO).getProfile(arg_0)).collect(Collectors.toSet());
                i18nParams.put("profiles", AccessExplanation.profilesToI18nizableText(denyingProfiles));
            } else if (!((Set)assignedProfiles.getLeft()).isEmpty()) {
                permission = grantedPermission;
                i18nkey = "PLUGINS_WORKSPACES_MODULE_ACCESS_CONTROLLER_" + grantedPermission.name() + "_EXPLANATION";
                Set grantingProfiles = ((Set)assignedProfiles.getLeft()).stream().map(arg_0 -> ((RightProfilesDAO)this._profileDAO).getProfile(arg_0)).collect(Collectors.toSet());
                i18nParams.put("profiles", AccessExplanation.profilesToI18nizableText(grantingProfiles));
            } else {
                permission = AccessController.AccessResult.UNKNOWN;
                i18nkey = "PLUGINS_WORKSPACES_MODULE_ACCESS_CONTROLLER_UNKNOWN_EXPLANATION";
            }
        }
        return new AccessExplanation(this.getId(), permission, new I18nizableText("plugin.workspaces", (String)i18nkey, i18nParams));
    }

    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        return Map.of();
    }

    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        ModifiableResourceCollection root = this._getModuleRoot(object);
        if (!this._isModuleActivated((ResourceCollection)root)) {
            return AccessController.AccessResult.UNKNOWN;
        }
        return this._profileAssignmentStorageEP.getPermissionForAnonymous(this._projectRightHelper.getProfilesIds(), (Object)root);
    }

    public AccessExplanation explainReadAccessPermissionForAnonymous(Object object) {
        return this._explain(this._getModuleRoot(object), AccessController.AccessResult.ANONYMOUS_ALLOWED, AccessController.AccessResult.ANONYMOUS_DENIED, root -> {
            Map assignments = this._profileAssignmentStorageEP.getProfilesForAnonymousAndAnyConnectedUser(root);
            Set<String> workspaceProfiles = this._projectRightHelper.getProfilesIds();
            Set deniedProfiles = ((Set)assignments.get(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED)).stream().filter(p -> workspaceProfiles.contains(p)).collect(Collectors.toSet());
            Set allowedProfiles = ((Set)assignments.get(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED)).stream().filter(p -> workspaceProfiles.contains(p)).collect(Collectors.toSet());
            return Pair.of(allowedProfiles, deniedProfiles);
        });
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        ModifiableResourceCollection root = this._getModuleRoot(object);
        if (!this._isModuleActivated((ResourceCollection)root)) {
            return AccessController.AccessResult.UNKNOWN;
        }
        return this._profileAssignmentStorageEP.getPermissionForAnyConnectedUser(this._projectRightHelper.getProfilesIds(), (Object)root);
    }

    public AccessExplanation explainReadAccessPermissionForAnyConnectedUser(Object object) {
        return this._explain(this._getModuleRoot(object), AccessController.AccessResult.ANY_CONNECTED_ALLOWED, AccessController.AccessResult.ANY_CONNECTED_DENIED, root -> {
            Map assignments = this._profileAssignmentStorageEP.getProfilesForAnonymousAndAnyConnectedUser(root);
            Set<String> workspaceProfiles = this._projectRightHelper.getProfilesIds();
            Set deniedProfiles = ((Set)assignments.get(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED)).stream().filter(p -> workspaceProfiles.contains(p)).collect(Collectors.toSet());
            Set allowedProfiles = ((Set)assignments.get(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED)).stream().filter(p -> workspaceProfiles.contains(p)).collect(Collectors.toSet());
            return Pair.of(allowedProfiles, deniedProfiles);
        });
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        return Map.of();
    }

    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        ModifiableResourceCollection root = this._getModuleRoot(object);
        if (!this._isModuleActivated((ResourceCollection)root)) {
            return Map.of();
        }
        return this._profileAssignmentStorageEP.getPermissionsByUser(this._projectRightHelper.getProfilesIds(), (Object)root);
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return Map.of();
    }

    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        ModifiableResourceCollection root = this._getModuleRoot(object);
        if (!this._isModuleActivated((ResourceCollection)root)) {
            return Map.of();
        }
        return this._profileAssignmentStorageEP.getPermissionsByGroup(this._projectRightHelper.getProfilesIds(), (Object)root);
    }

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        return false;
    }

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return false;
    }

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    protected AccessExplanation _getAccessExplanation(AccessController.AccessResult result, Object object, UserIdentity user, Set<GroupIdentity> groups, String rightId) {
        switch (result) {
            case UNKNOWN: {
                return new AccessExplanation(this.getId(), result, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_MODULE_ACCESS_CONTROLLER_UNKNOWN_EXPLANATION", Map.of("module", this.getObjectLabel(object))));
            }
        }
        return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)result);
    }

    public I18nizableText getObjectLabel(Object object) {
        return this._moduleEP.getModuleByName(this._getModuleRoot(object).getName()).getModuleTitle();
    }

    public I18nizableText getObjectCategory(Object object) {
        return ProjectAccessController.WORKSPACE_CONTEXT_CATEGORY;
    }

    protected Iterable<? extends Object> getHandledObjects(UserIdentity identity, Set<GroupIdentity> groups, Set<Object> workspacesContexts) {
        List<Project> projects;
        String siteName = WebHelper.getSiteName((Request)ContextHelper.getRequest((Context)this._context));
        Site site = this._siteManager.getSite(siteName);
        if (site != null && !(projects = this._projectManager.getProjectsForSite(site)).isEmpty()) {
            try {
                String query = "/jcr:root" + projects.get(0).getNode().getPath() + "/ametys-internal:resources/*";
                return this._resolver.query(query);
            }
            catch (RepositoryException e) {
                this.getLogger().warn("Failed to list project modules", (Throwable)e);
            }
        }
        return List.of();
    }

    protected Collection<String> getHandledRights() {
        return List.of();
    }
}

