/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search.module;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.SearchResults;
import org.ametys.cms.search.SortOrder;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.query.MatchAllQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProviderExtensionPoint;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.search.module.AbstractSolrSearchModuleGenerator;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.page.Page;
import org.ametys.web.search.query.SiteQuery;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractContentSolrSearchModuleGenerator
extends AbstractSolrSearchModuleGenerator {
    protected ContentSearcherFactory _contentSearcherFactory;
    protected ContentTypesHelper _cTypesHelper;
    protected TagProviderExtensionPoint _tagProviderEP;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._contentSearcherFactory = (ContentSearcherFactory)this.manager.lookup(ContentSearcherFactory.ROLE);
        this._cTypesHelper = (ContentTypesHelper)smanager.lookup(ContentTypesHelper.ROLE);
        this._tagProviderEP = (TagProviderExtensionPoint)smanager.lookup(TagProviderExtensionPoint.ROLE);
    }

    @Override
    protected void saxHit(AmetysObject object, String lang) throws Exception {
        if (object instanceof Content) {
            Content content = (Content)object;
            View view = this._cTypesHelper.getView("search", content.getTypes(), content.getMixinTypes());
            if (view == null) {
                view = this._cTypesHelper.getView("main", content.getTypes(), content.getMixinTypes());
            }
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", content.getId());
            attrs.addCDATAAttribute("title", content.getTitle());
            attrs.addCDATAAttribute("createdAt", DateUtils.zonedDateTimeToString((ZonedDateTime)content.getCreationDate()));
            attrs.addCDATAAttribute("creator", UserIdentity.userIdentityToString((UserIdentity)content.getCreator()));
            attrs.addCDATAAttribute("lastModifiedAt", DateUtils.zonedDateTimeToString((ZonedDateTime)content.getLastModified()));
            ZonedDateTime lastValidatedAt = content.getLastValidationDate();
            if (lastValidatedAt != null) {
                attrs.addCDATAAttribute("lastValidatedAt", DateUtils.zonedDateTimeToString((ZonedDateTime)lastValidatedAt));
            }
            attrs.addCDATAAttribute("lastContributor", UserIdentity.userIdentityToString((UserIdentity)content.getLastContributor()));
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"hit", (Attributes)attrs);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"attributes");
            content.dataToSAX(this.contentHandler, (ViewItemAccessor)view, DataContext.newInstance().withLocale(LocaleUtils.toLocale((String)lang)).withEmptyValues(false));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"attributes");
            this.saxAdditionalInformation(content);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"hit");
        } else {
            this.getLogger().error("Object '" + object.getId() + "' is not a Content.");
        }
    }

    protected void saxAdditionalInformation(Content content) throws SAXException {
        this.saxPage(content);
        this.saxTags(content);
    }

    protected void saxPage(Content content) throws SAXException {
        Collection referencingPages;
        if (content instanceof WebContent && !(referencingPages = ((WebContent)content).getReferencingPages()).isEmpty()) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"page", (String)((Page)referencingPages.iterator().next()).getId());
        }
    }

    protected void saxTags(Content content) throws SAXException {
        Set tags = content.getTags();
        if (!tags.isEmpty()) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"tags");
            for (String tagName : tags) {
                Tag tag;
                HashMap<String, String> contextParameters = new HashMap<String, String>();
                if (content instanceof WebContent) {
                    contextParameters.put("siteName", ((WebContent)content).getSiteName());
                }
                if ((tag = this._tagProviderEP.getTag(tagName, contextParameters)) == null) continue;
                AttributesImpl attrs = new AttributesImpl();
                if (tag.getParentName() != null) {
                    attrs.addCDATAAttribute("parent", tag.getParentName());
                }
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)tagName, (Attributes)attrs);
                tag.getTitle().toSAX(this.contentHandler);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)tagName);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"tags");
        }
    }

    protected SearchResults<Content> getSearchResults(String siteName, String lang, String textfield, Request request, int offset, int limit) throws Exception {
        ContentSearcherFactory.SimpleContentSearcher searcher = this.getSearcher();
        Query query = this.getQuery(siteName, lang, textfield, request);
        return searcher.withLimits(offset, limit).addSort(this.getSortFieldName(), this.getSortOrder()).searchWithFacets(query);
    }

    protected Query getSiteQuery(List<Project> projects) {
        List<String> sites = this.getSiteNames(projects);
        if (sites == null || sites.isEmpty()) {
            return new MatchAllQuery();
        }
        return new SiteQuery(sites);
    }

    protected List<String> getSiteNames(List<Project> projects) {
        if (projects == null) {
            return null;
        }
        return projects.stream().map(Project::getSite).filter(Objects::nonNull).map(SimpleAmetysObject::getName).collect(Collectors.toList());
    }

    protected abstract ContentSearcherFactory.SimpleContentSearcher getSearcher();

    protected abstract String getSortFieldName();

    protected abstract SortOrder getSortOrder();

    protected abstract Query getQuery(String var1, String var2, String var3, Request var4);
}

