/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search.module;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.search.SearchResult;
import org.ametys.cms.search.SearchResults;
import org.ametys.cms.search.SearchResultsIterable;
import org.ametys.cms.search.SearchResultsIterator;
import org.ametys.cms.search.query.AndQuery;
import org.ametys.cms.search.query.DocumentTypeQuery;
import org.ametys.cms.search.query.FullTextQuery;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.solr.SearcherFactory;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.EmptyIterable;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.search.module.AbstractSolrSearchModuleGenerator;
import org.ametys.plugins.workspaces.search.query.ProjectQuery;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public class DocumentSearchModuleGenerator
extends AbstractSolrSearchModuleGenerator {
    protected SearcherFactory _searcherFactory;
    protected ContentTypesHelper _cTypesHelper;
    protected WorkspacesHelper _workspaceHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._searcherFactory = (SearcherFactory)this.manager.lookup(SearcherFactory.ROLE);
        this._cTypesHelper = (ContentTypesHelper)this.manager.lookup(ContentTypesHelper.ROLE);
        this._workspaceHelper = (WorkspacesHelper)((Object)this.manager.lookup(WorkspacesHelper.ROLE));
    }

    @Override
    protected SearchResults<? extends AmetysObject> getSearchResults(String siteName, String lang, String textfield, Request request, int offset, int limit) throws Exception {
        SearcherFactory.Searcher searcher = this._searcherFactory.create();
        List<Project> projects = this.getProjects(request, true);
        if ((projects = this.filterProjectsForModule(projects, DocumentWorkspaceModule.DOCUMENT_MODULE_ID)).isEmpty()) {
            return new EmptySearchResults();
        }
        HashSet<Object> queries = new HashSet<Object>();
        DocumentTypeQuery documentTypeQuery = new DocumentTypeQuery("projectResource");
        queries.add(documentTypeQuery);
        if (StringUtils.isNotBlank((CharSequence)textfield)) {
            FullTextQuery fullTextQuery = new FullTextQuery("*" + textfield + "*", lang, Query.Operator.SEARCH);
            Query fileNameQuery = () -> "filename:(*" + ClientUtils.escapeQueryChars((String)textfield) + "*)";
            OrQuery searchQuery = new OrQuery(new Query[]{fullTextQuery, fileNameQuery});
            queries.add(searchQuery);
        }
        Set<String> projectIds = projects.stream().map(SimpleAmetysObject::getId).collect(Collectors.toSet());
        queries.add(new ProjectQuery(projectIds));
        AndQuery fullQuery = new AndQuery(queries);
        return searcher.withLimits(offset, limit).withQuery((Query)fullQuery).searchWithFacets();
    }

    @Override
    protected void saxHit(AmetysObject object, String lang) throws Exception {
        if (object instanceof Resource) {
            Resource file = (Resource)object;
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", file.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"hit", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)file.getName());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"uri", (String)ResolveURIComponent.resolve((String)"project-resource", (String)file.getId(), (boolean)false, (boolean)true));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"length", (String)String.valueOf(file.getLength()));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"mimeType", (String)file.getMimeType());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"fileType", (String)this._workspaceHelper.getFileType(file).name().toLowerCase());
            Date creationDate = file.getCreationDate();
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"creationDate", (String)DateUtils.dateToString((Date)creationDate));
            Date lastModified = file.getLastModified();
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"lastModified", (String)DateUtils.dateToString((Date)lastModified));
            Project project = this.getProject(object);
            this.saxProject(project);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"hit");
        }
    }

    class EmptySearchResults<A extends AmetysObject>
    implements SearchResults<A> {
        EmptySearchResults() {
        }

        public SearchResultsIterable<SearchResult<A>> getResults() {
            return new EmptySearchResultsIterable();
        }

        public AmetysObjectIterable<A> getObjects() {
            return new EmptyIterable();
        }

        public Iterable<String> getObjectIds() {
            return IterableUtils.emptyIterable();
        }

        public Map<String, Map<String, Integer>> getFacetResults() {
            return Collections.EMPTY_MAP;
        }

        public long getTotalCount() {
            return 0L;
        }

        public float getMaxScore() {
            return 0.0f;
        }

        public Optional<Map<String, Object>> getDebugMap() {
            return Optional.empty();
        }
    }

    class EmptySearchResultsIterator<A extends AmetysObject>
    implements SearchResultsIterator<SearchResult<A>> {
        EmptySearchResultsIterator(DocumentSearchModuleGenerator this$0) {
        }

        public boolean hasNext() {
            return false;
        }

        public SearchResult<A> next() {
            throw new UnsupportedOperationException();
        }

        public void skip(long skipNum) {
            throw new UnsupportedOperationException();
        }
    }

    class EmptySearchResultsIterable<A extends AmetysObject>
    implements SearchResultsIterable<SearchResult<A>> {
        EmptySearchResultsIterable() {
        }

        public long getSize() {
            return 0L;
        }

        public SearchResultsIterator<SearchResult<A>> iterator() {
            return new EmptySearchResultsIterator(DocumentSearchModuleGenerator.this);
        }
    }
}

