/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search.module;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.List;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.query.SortCriteria;
import org.ametys.plugins.repository.query.expression.FullTextExpression;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.plugins.workspaces.forum.ForumWorkspaceModule;
import org.ametys.plugins.workspaces.forum.jcr.JCRThread;
import org.ametys.plugins.workspaces.forum.json.ThreadJSONHelper;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.search.module.AbstractXpathSearchModuleGenerator;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.type.DataContext;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ThreadSearchModuleGenerator
extends AbstractXpathSearchModuleGenerator {
    protected ForumWorkspaceModule _forumModule;
    protected UserDirectoryHelper _userDirectoryHelper;
    protected ContentTypeExtensionPoint _cTypeEP;
    protected ThreadJSONHelper _threadJSONHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)this.manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._forumModule = (ForumWorkspaceModule)moduleManagerEP.getModule(ForumWorkspaceModule.FORUM_MODULE_ID);
        this._userDirectoryHelper = (UserDirectoryHelper)smanager.lookup(UserDirectoryHelper.ROLE);
        this._cTypeEP = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._threadJSONHelper = (ThreadJSONHelper)((Object)smanager.lookup(ThreadJSONHelper.ROLE));
    }

    @Override
    protected String getXPathQuery(String siteName, String lang, String textfield, Request request, int offset, int limit) throws Exception {
        List<Project> projects = this.getProjects(request, true);
        List<Project> filteredProjects = this.filterProjectsForModule(projects, ForumWorkspaceModule.FORUM_MODULE_ID);
        if (filteredProjects.isEmpty()) {
            return null;
        }
        String projectXPathQuery = this.getProjectXPathQuery(filteredProjects);
        Object searchQuery = "";
        if (StringUtils.isNotBlank((CharSequence)textfield)) {
            FullTextExpression labelEXpr = new FullTextExpression("title", textfield);
            searchQuery = "[" + labelEXpr.build() + "]";
        }
        SortCriteria sortCriteria = new SortCriteria();
        sortCriteria.addCriterion("creationDate", false, false);
        String sortQuery = sortCriteria.build();
        String jcrQuery = projectXPathQuery + "//forums/element(*, ametys:forum-thread)" + (String)searchQuery + " " + sortQuery;
        return jcrQuery;
    }

    @Override
    protected void saxHit(AmetysObject object, String lang) throws Exception {
        if (object instanceof JCRThread) {
            JCRThread thread = (JCRThread)object;
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", thread.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"hit", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)thread.getTitle());
            if (thread.getContent() != null) {
                String simpleText = this._threadJSONHelper.richTextToSimpleText(thread.getContent(), 150);
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"description", (String)simpleText);
            }
            Project project = this.getProject(object);
            String threadUri = this._forumModule.getThreadUri(project, thread.getId());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"uri", (String)threadUri);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"creationDate", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)thread.getCreationDate()));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"category", (String)thread.getCategory().toString());
            UserIdentity author = thread.getAuthor();
            this.saxUser(author, "author");
            this.saxAuthorInfos(author, lang);
            this.saxProject(project);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"hit");
        }
    }

    protected void saxAuthorInfos(UserIdentity author, String lang) throws SAXException, BadItemTypeException, IOException {
        Content userContent = this._userDirectoryHelper.getUserContent(author, lang);
        if (userContent != null) {
            AttributesImpl contentAttrs = new AttributesImpl();
            contentAttrs.addCDATAAttribute("id", userContent.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"author-infos", (Attributes)contentAttrs);
            ContentType contentType = (ContentType)this._cTypeEP.getExtension("org.ametys.plugins.workspaces.Content.member");
            View view = contentType.getView("abstract");
            userContent.dataToSAX(this.contentHandler, (ViewItemAccessor)view, DataContext.newInstance().withLocale(LocaleUtils.toLocale((String)lang)).withEmptyValues(false));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"author-infos");
        }
    }
}

