/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.web.frontoffice.FrontOfficeSearcherFactory;
import org.ametys.web.frontoffice.QueryAdapterFOSearch;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.search.query.SiteTypeQuery;
import org.apache.cocoon.environment.Request;

public class WorkspacesQueryAdapterFOSearch
implements QueryAdapterFOSearch {
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Query modifyQuery(Query query, Request request, Collection<String> siteNames, String language) {
        return query;
    }

    public Query modifySiteQueryFilter(Query siteQuery, Request request, Collection<String> siteNames, String language) {
        if (this._withWorkspaces(request)) {
            SiteTypeQuery siteTypeQuery = new SiteTypeQuery(new String[]{"workspaces.project"});
            return new OrQuery(new Query[]{siteQuery, siteTypeQuery});
        }
        return siteQuery;
    }

    public Query modifySitemapQueryFilter(Query sitemapQuery, Request request, Collection<String> siteNames, String language) {
        if (this._withWorkspaces(request)) {
            SiteTypeQuery siteTypeQuery = new SiteTypeQuery(new String[]{"workspaces.project"});
            return new OrQuery(new Query[]{sitemapQuery, siteTypeQuery});
        }
        return sitemapQuery;
    }

    public Set<FrontOfficeSearcherFactory.QueryFacet> modifyQueryFacets(Set<FrontOfficeSearcherFactory.QueryFacet> queryFacets, Request request) {
        if (this._withWorkspaces(request)) {
            HashSet<FrontOfficeSearcherFactory.QueryFacet> modifiedQueryFacets = new HashSet<FrontOfficeSearcherFactory.QueryFacet>();
            for (FrontOfficeSearcherFactory.QueryFacet queryFacet : queryFacets) {
                if (queryFacet.getKeyName().equals("isPageResource")) {
                    modifiedQueryFacets.add(new FrontOfficeSearcherFactory.QueryFacet("isPageResource", "page-content-types", "_documentType:pageResource OR _documentType:projectResource"));
                    continue;
                }
                modifiedQueryFacets.add(queryFacet);
            }
            return modifiedQueryFacets;
        }
        return queryFacets;
    }

    public void addDocumentType(List<String> documentTypes) {
        documentTypes.add("projectResource");
    }

    private boolean _withWorkspaces(Request request) {
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(ZoneItem.class.getName());
        if (zoneItem != null) {
            ModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
            return (Boolean)serviceParameters.getValue("withWorkspaces", false, (Object)false);
        }
        return false;
    }
}

