/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.tasks.actions;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.tasks.Task;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public abstract class AbstractGetTasksForExportAction
extends ServiceableAction {
    private static final String __FULL_DAY_PATTERN = "uuuuMMdd";
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, List<Map>> result = new HashMap<String, List<Map>>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        List<Task> tasks = this.getTasks(request);
        List<Map> tasksMap = tasks.stream().filter(this::_passFilter).map(this::_task2Result).toList();
        result.put("events", tasksMap);
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return EMPTY_MAP;
    }

    protected boolean _passFilter(Task task) {
        return task != null;
    }

    protected Map<String, Object> _task2Result(Task task) {
        LocalDate startDateEvent;
        HashMap<String, Object> taskMap = new HashMap<String, Object>();
        taskMap.put("id", task.getId());
        taskMap.put("title", task.getLabel());
        taskMap.put("description", task.getDescription());
        taskMap.put("fullDay", true);
        taskMap.put("keywords", task.getTags());
        LocalDate dueDate = task.getDueDate();
        LocalDate startDate = task.getStartDate();
        LocalDate localDate = startDateEvent = startDate != null ? startDate : dueDate;
        if (startDateEvent != null) {
            taskMap.put("startDate", startDateEvent.format(DateTimeFormatter.BASIC_ISO_DATE));
        }
        if (dueDate != null) {
            taskMap.put("endDate", dueDate.plusDays(1L).format(DateTimeFormatter.BASIC_ISO_DATE));
        }
        taskMap.put("creationDate", DateUtils.zonedDateTimeToString((ZonedDateTime)task.getCreationDate(), (ZoneId)task.getCreationDate().getZone(), (String)__FULL_DAY_PATTERN));
        taskMap.put("lastModified", DateUtils.zonedDateTimeToString((ZonedDateTime)task.getLastModified(), (ZoneId)task.getLastModified().getZone(), (String)__FULL_DAY_PATTERN));
        taskMap.put("tags", task.getTags());
        taskMap.put("recurrenceType", "NEVER");
        return taskMap;
    }

    protected abstract List<Task> getTasks(Request var1);
}

