/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.tasks.json;

import java.util.HashMap;
import java.util.Map;
import org.ametys.plugins.workspaces.tasks.TasksList;
import org.ametys.plugins.workspaces.tasks.TasksListColorsComponent;
import org.ametys.plugins.workspaces.tasks.TasksListIconsComponent;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class TasksListJSONHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = TasksListJSONHelper.class.getName();
    protected TasksListColorsComponent _tasksListColorsComponent;
    protected TasksListIconsComponent _tasksListIconsComponent;

    public void service(ServiceManager manager) throws ServiceException {
        this._tasksListColorsComponent = (TasksListColorsComponent)((Object)manager.lookup(TasksListColorsComponent.ROLE));
        this._tasksListIconsComponent = (TasksListIconsComponent)manager.lookup(TasksListIconsComponent.ROLE);
    }

    public Map<String, Object> tasksListAsJson(TasksList tasksList) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("id", tasksList.getListId());
        json.put("label", tasksList.getLabel());
        json.put("position", tasksList.getPosition());
        String color = tasksList.getColor();
        json.put("colorId", StringUtils.isNotBlank((CharSequence)color) ? color : this._tasksListColorsComponent.getDefaultKey());
        String icon = tasksList.getIcon();
        json.put("iconId", StringUtils.isNotBlank((CharSequence)icon) ? icon : this._tasksListIconsComponent.getDefaultKey());
        return json;
    }
}

