/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
// This script check if the script for tasks 20210702T0000 and 20210707T0000 are already past
 
const migrationEngine = Ametys.serviceManager.lookup(org.ametys.core.migration.MigrationEngine.ROLE);

const versionStorageEP = Ametys.serviceManager.lookup(org.ametys.core.migration.version.storage.VersionStorageExtensionPoint.ROLE);
const versionStorage = versionStorageEP.getExtension('jcr');
  
let versions = versionStorage.getVersions(componentId, null, component);
let currentVersion = migrationEngine.getLatestVersion(versions);

// If the current version is before the task migration version 20210707T0000
if (currentVersion != null && org.apache.commons.lang3.StringUtils.compare(currentVersion.getVersionNumber(), "20210707T0000") < 0)
{
    // Check if the script for tasks are already past in the old component
    let oldVersions = versions.stream()
                              .map(v => v.getVersionNumber())
                              .collect(java.util.stream.Collectors.toList());

    if (oldVersions.contains("20210702T0000"))
    {
        //Ignore automatic version for tasks, they are already past
        Migration.addVersion(componentId, null, null, "20210702T0000", "Ignore automatic migration 20210702T0000 for WORKSPACES-858 because there are already past.");
        logger.info("Version 20210702T0000 added by script for component " + componentId);
    }
    
    if (oldVersions.contains("20210707T0000"))
    {
        //Ignore automatic version for tasks, they are already past
        Migration.addVersion(componentId, null, null, "20210707T0000", "Ignore automatic migration 20210707T0000 for WORKSPACES-858 because there are already past.");
        logger.info("Version 20210707T0000 added by script for component " + componentId);
    }
}

if (versions.length == 0)
{
    // Set to 0 to force upgrades, no initializations
    let version = versionStorage.createVersion(componentId, component, null, null);
    version.setVersionNumber("0");
    return version;
}

return versions;
