/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

try { logger; }
catch (e) { logger = Ametys.getLogger("org.ametys.core.migration.MigrationExtensionPoint.workspaces"); }

let projectManager = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.project.ProjectManager.ROLE);
let workspaceModuleExtensionPoint = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint.ROLE);

projectManager.getProjects().forEach(
    project =>
    {
	    logger.info("Migration of " + project.getName());
	    migrateProjectPageOrder(project);
    }
);

function migrateProjectPageOrder(project)
{
    // First get all pages of all modules'project
    // And sort the pages by the module order in descending order
    let pagesMap = new java.util.TreeMap();
    for (let moduleId of project.getModules())
    {
        let module = workspaceModuleExtensionPoint.getModule(moduleId);
        let order = module.getOrder();

        for (let page of projectManager.getModulePages(project, module))
        {
            let inversedOrder = 0.0 - order;
	        if (pagesMap.containsKey(inversedOrder))
	        {
	            pagesMap.put(inversedOrder + 1, page);
	        }
	        else
	        {
	            pagesMap.put(inversedOrder, page);
	        }
        }
    }

    // Then for each page, just order the next page in the TreeMap before this page.
    let afterPage = null;
    let lastAfterPageLive = null;
    for (let order in pagesMap)
    {
        let currentPage = pagesMap.get(order)
        logger.debug(currentPage.getTitle() + " - " + order);
        if (afterPage == null)
        {
            afterPage = currentPage;
        }
        else
        {
            currentPage.orderBefore(afterPage);
            currentPage.getParent().saveChanges();
        
            // Reorder pages in live session
			try 
			{
				let afterPageLive = Repository.resolver.resolveById(afterPage.getId(), Repository.liveSession);
				lastAfterPageLive = afterPageLive;
			}
			catch (e) {/* Keep the last valid after page in live session */}
         
			if (lastAfterPageLive != null)
			{
				try
				{
					let currentPageLive = Repository.resolver.resolveById(currentPage.getId(), Repository.liveSession);
					currentPageLive.orderBefore(lastAfterPageLive);
					currentPageLive.getParent().saveChanges();
				}
				catch (e) {/* One of the page should be null */}
			}
         
            afterPage = currentPage;
        }
    }
}
  