/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
const OLD_WORKFLOW_NAME = "content";
const OLD_WIKI_WORKFLOW_NAME = "editionfo";
const NEW_WORKFLOW_NAME = "workspaces-content";
const oldAboutModuleId = "org.ametys.plugins.workspaces.editionfo.EditionFOWorkspaceModule";
const newAboutModuleId = "org.ametys.plugins.workspaces.about.AboutWorkspaceModule";

const ModifiableContentHelper = Java.type('org.ametys.cms.repository.ModifiableContentHelper');
const modifiableContentComponent = Ametys.serviceManager.lookup(ModifiableContentHelper.ROLE);

let count = 0;

function moveWikiNode(s)
{
    let query = "//element(*, ametys:project)/ametys-internal:resources/element(wiki, ametys:resources-collection)";
    Repository.query(query, true, s).forEach(function(collection)             
    { 
        count++;
        collection.getNode().getSession().move(collection.getNode().getPath(), collection.getNode().getParent().getPath() + '/about');   
    });
    s.save();
    
    logger.info(`${count} about module nodes have been renamed in ${s.getWorkspace().getName()} workspace`);
}

function __migrateContentType(newContentType, content)
{
    content.setType(newContentType);
    count++; 
}

function migrateContentType(oldContentTypeId, newContentTypeId)
{
    let query = "//element(*, ametys:content)[@ametys-internal:contentType = '" + oldContentTypeId + "']";
    
    Repository.query(query).forEach(function(content)             
    {      
        Content.migrate(             
            content,             
            [__migrateContentType.bind(null, newContentTypeId)],             
            false /* old versions are still compatible */,             
            null /* no tag */,             
            false /* not verbose */,
            true /* synchronize live */
        );             
    });     ;
    
    logger.info(`Content type ${oldContentTypeId} has been migrated to ${newContentTypeId} for ${count} content(s)`);
}

function __migrateWorkflow(oldWorkflowName, newWorkflowName, content)
{
    if (content.getNode().hasNode("ametys-internal:workflows"))
    {
       let workflowNodes = content.getNode().getNode("ametys-internal:workflows").getNodes();
       while (workflowNodes.hasNext())   
       {   
          var workflowNode = workflowNodes.next();   
          let workflowName = workflowNode.getProperty("oswf:workflowName").getString();
          if (workflowName == oldWorkflowName)
          {
             workflowNode.setProperty("oswf:workflowName", newWorkflowName);
             count++; 
          }
       }   
    }
}

function migrateWorflow(contentTypeId, oldWorkflowName, newWorkflowName)
{
    let query = "//element(*, ametys:content)[@ametys-internal:contentType = '" + contentTypeId + "']";
    
    Repository.query(query).forEach(function(content)             
    {      
        Content.migrate(             
            content,             
            [__migrateWorkflow.bind(null, oldWorkflowName, newWorkflowName)],             
            false /* old versions are still compatible */,             
            null /* no tag */,             
            false /* not verbose */             
        );             
    });     
    
    logger.info(`Workflow name has been updated for ${count} content(s) of type ${contentTypeId}`);
}

function migratePageTemplate(oldTemplate, newTemplate, s)
{
    let query = "//element(*, ametys:page)[@ametys-internal:template = '" + oldTemplate + "']";
    
    Repository.query(query, true, s).forEach(function(page)             
    {      
        count++;
        page.setTemplate(newTemplate);      
    });     
    
    s.save();
    
    logger.info(`${count} about page have been updated in ${s.getWorkspace().getName()} workspace`);
}

function migrateModule(oldModuleId, newModuleId)
{
    let query = `//element(*, ametys:project)[@ametys:modules='${oldModuleId}']`;
    
    Repository.query(query).forEach(function(project)             
    {      
        project.removeModule(oldModuleId);
        project.addModule(newModuleId);     
    });     
    
    session.save();
    
    logger.info(`${count} project(s) have been updated`);
}

// 1 - rename 'wiki' module node to 'about'
count = 0;
logger.info("Start migration of About module name");
moveWikiNode(Repository.session);
count = 0;
moveWikiNode(Repository.liveSession);

// 2 - Migrate 'editionFO' content types to 'about'
count = 0;
logger.info("Start migration of About contents");
migrateContentType("org.ametys.plugins.workspaces.Content.editionFO", "org.ametys.plugins.workspaces.Content.about");

// 3 - Migrate 'project-wiki' template to 'project-about'
count = 0;
logger.info("Start migration of About pages");
migratePageTemplate("project-wiki", "project-about", Repository.session);
count = 0;
migratePageTemplate("project-wiki", "project-about", Repository.liveSession);

// 4 - Update workflow name for alert, news and about contents
logger.info("Start migration of workflow name for projects' contents");
count = 0;
migrateWorflow("org.ametys.plugins.workspaces.Content.projectNews", OLD_WORKFLOW_NAME, NEW_WORKFLOW_NAME);  
count = 0;
migrateWorflow("org.ametys.plugins.workspaces.Content.catalogNews", OLD_WORKFLOW_NAME, NEW_WORKFLOW_NAME);  
count = 0;
migrateWorflow("org.ametys.plugins.workspaces.Content.alert", OLD_WORKFLOW_NAME, NEW_WORKFLOW_NAME); 
count = 0;
migrateWorflow("org.ametys.plugins.workspaces.Content.about", OLD_WIKI_WORKFLOW_NAME, NEW_WORKFLOW_NAME); 
logger.info("Migration of workflow name for projects' contents is successfully terminated")

// 5 - Update about module id on project
logger.info("Start migration of about module id for projects");
migrateModule(oldAboutModuleId, newAboutModuleId);

  