/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

transform(Repository.session);
transform(Repository.liveSession);

function transform(s, pageName, zoneName)
{
    updateServices(s, "index", "left");
    updateServices(s, "news", "default");
}

function updateServices(s, pageName, zoneName)
{
    let zoneItems = Repository.query(`//element(*, ametys:site)[@ametys:type='workspaces.project']//element(*, ametys:sitemap)/${pageName}/ametys-internal:zones/${zoneName}/ametys-internal:zoneItems//element(*, ametys:zoneItem)[@ametys-internal:type = 'SERVICE' and @ametys-internal:service = 'org.ametys.web.service.SearchService']`, true, s);
    zoneItems.forEach(
        zi =>
        {
            logger.info(`Update zone item ${zi} in workspace ${s.getWorkspace().getName()}`);
            zi.getServiceParameters().setValue("rightCheckingMode", "none");
            zi.saveChanges();
        }
    );
}
