/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

removeSurveyServices(Repository.session);
removeSurveyServices(Repository.liveSession);

Repository.registerNodeType("survey", { "unregisterIfExists": false });
Repository.registerNodeType("survey-page", { "unregisterIfExists": false });
Repository.registerNodeType("survey-options", { "unregisterIfExists": false });
Repository.registerNodeType("survey-question", { "unregisterIfExists": false });
Repository.registerNodeType("survey-rules", { "unregisterIfExists": false });
Repository.registerNodeType("survey-rule", { "unregisterIfExists": false });

removeSurveys(Repository.session);
removeSurveys(Repository.liveSession);

function removeSurveyServices(s)
{
    let count=0;
    let zoneItems = Repository.query("//element(*, ametys:site)[@ametys:type='workspaces.project']//element(*, ametys:zoneItem)[@ametys-internal:type = 'SERVICE' and @ametys-internal:service = 'org.ametys.survey.service.Display']", true, s);
    zoneItems.forEach(
        zi =>
        {
            zi.remove();
            zi.saveChanges();
            count++;
        }
    );
    
    logger.info(`${count} project's mini survey services have been removed in workspace ${s.getWorkspace().getName()}`);
}

function removeSurveys(s)
{
    let count = 0;
    let among = 0;
    const nodes = Repository.query("//element(*, ametys:site)[@ametys:type='workspaces.project']", false, s)
    while (nodes.hasNext())
    {
        among++;
        const node = nodes.next();
        if (node.hasNode("ametys-internal:plugins"))
        {
            let pluginsNode = node.getNode("ametys-internal:plugins")
            if (pluginsNode.hasNode("survey"))
            {
                let surveysNode = pluginsNode.getNode("survey")
                surveysNode.remove();
                count++;
            }
        }
    }
    
    s.save();
    logger.info(`Old surveys have been removed for ${count}/${among} project(s) in workspace ${s.getWorkspace().getName()}`);
}
