<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
    exclude-result-prefixes="ametys project">
    
    <xsl:template name="common-workspaces-js">   
        <xsl:variable name="vue">
            <xsl:choose>
                <xsl:when test="not(ametys:requestParameter('vueserve'))">vue.runtime.global.prod.js</xsl:when>
                <xsl:otherwise>vue.runtime.global.js</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
    
        <script type="text/javascript" src="{ametys:pluginResourceURL('vuejs', concat('js/', $vue))}"/>   
        <script type="text/javascript" src="{ametys:pluginResourceURL('vuetify', 'js/vuetify.js')}"/>
        <script type="text/javascript" src="{ametys:pluginResourceURL('pinia', 'js/pinia.iife.prod.js')}"/>
        
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/workspaces/applicationv2/WorkspacesI18n.', ametys:lang(), '.js'))}"/>
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/WorkspacesUtils.', ametys:lang(), '.js'))}"></script>
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/AmetysRouter.', ametys:lang(), '.js'))}"></script>
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', 'js/truncate.js')}"></script>
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/basic-messages.', ametys:lang(), '.js'))}"></script>
        
        <script type="text/javascript">
            AmetysFront.setAppParameter('projectName', '<xsl:value-of select="project:project()" />');
        </script>
    </xsl:template>
    
    <xsl:template name="common-workspaces-css">   
        
        <link rel="stylesheet" href="{ametys:pluginResourceURL('fontawesome6-free', 'css/all.css')}" />
        <xsl:if test="ametys:isPluginEnabled('fontawesome6')">
            <link rel="stylesheet" href="{ametys:pluginResourceURL('fontawesome6', 'css/all.css')}" />
        </xsl:if>
            
        <link rel="stylesheet" href="{ametys:pluginResourceURL('workspaces', 'css/vendor/font-poppins/font-poppins.css')}" />
        <link rel="stylesheet" href="{ametys:pluginResourceURL('workspaces', 'css/vendor/font-materialicons/stylesheet.css')}" />
        <link rel="stylesheet" href="{ametys:pluginResourceURL('workspaces', 'css/vendor/font-materialdesignicons/css/materialdesignicons.css')}" />
        <link rel="stylesheet" href="{ametys:pluginResourceURL('workspaces', 'css/truncate.css')}" />
        <link rel="stylesheet" href="{ametys:pluginResourceURL('workspaces', 'css/basic-messages.css')}" />
            
        <link rel="stylesheet" data-donotminimize="true" href="{ametys:pluginResourceURL('vuetify', 'css/vuetify.css')}"/>
		
        <!-- Should be loaded here, but let the skin load its own bootstrap version --> 
		<!-- <link href="resources/css/vendor/bootstrap/bootstrap.css" rel="stylesheet" /> -->
    </xsl:template>
</xsl:stylesheet>