<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:escape="org.apache.commons.lang.StringEscapeUtils"
                xmlns:math="java.lang.Math"
                xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:uriutils="org.ametys.core.util.URIUtils"
                extension-element-prefixes="ametys escape math user resolver">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">project-members</xsl:variable>
    <xsl:variable name="common-service-name">project-members</xsl:variable>
    
    <!-- +
         | HEAD
         + -->   
    <!-- Used by common -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <!-- title is inserted below in the content --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="managers" />
        <xsl:call-template name="members" />
        
        <xsl:call-template name="members-page" />
    </xsl:template>
    
    <xsl:template name="managers-title">
        <xsl:variable name="raw-is-title-visible">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
        </xsl:variable>
        <xsl:variable name="level">
            <xsl:choose>
                <xsl:when test="string-length($raw-is-title-visible) &gt; 0">2</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable> 
        
        <xsl:element name="h{$level}">
            <xsl:attribute name="managers-title"></xsl:attribute>
            <xsl:choose>
                <xsl:when test="count(/project/managers/manager) = 1">
                    <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_DISPLAY_MEMBERS_XSLT_MANAGER_TITLE" i18n:catalogue="plugin.workspaces"/>
                </xsl:when>
                <xsl:otherwise>
                    <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_DISPLAY_MEMBERS_XSLT_MANAGERS_TITLE" i18n:catalogue="plugin.workspaces"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element> 
    </xsl:template>    
    
    <xsl:template name="managers">
        <xsl:if test="/project/member[@manager = 'true']">
            <xsl:call-template name="managers-title" />
            <ul class="manager-list">
                <xsl:apply-templates select="/project/member[@manager = 'true']">
                    <xsl:sort select="@managerPosition"/>
                </xsl:apply-templates>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="members-title">
        <xsl:variable name="raw-is-title-visible">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
        </xsl:variable>
        <xsl:variable name="level">
            <xsl:choose>
                <xsl:when test="string-length($raw-is-title-visible) &gt; 0">2</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable> 
        
        <xsl:element name="h{$level}">
            <xsl:attribute name="managers-title"></xsl:attribute>
            <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_DISPLAY_MEMBERS_XSLT_MEMBERS_TITLE" i18n:catalogue="plugin.workspaces"/>
        </xsl:element>
    </xsl:template>    

    <xsl:template name="members">
        <xsl:if test="/project/member[@manager != 'true']">
            <xsl:call-template name="members-title" />
            <ul class="member-list">
                <xsl:apply-templates select="/project/member[@manager != 'true']"/>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="member">
        <li>
            <xsl:apply-templates select="user"/>
        </li>
    </xsl:template>
    
    <xsl:template match="user">
        <xsl:call-template name="user-image"/>
        <xsl:call-template name="user-name"/>
    </xsl:template>
    
    <xsl:template name="user-image">
        <span class="member-img"><img src="{$site-uri-prefix}/_plugins/core-ui/user/{info/@population}/{uriutils:encodePath(info/@login)}/image_26" alt="" title="{info/fullname}"/></span>
    </xsl:template>
    
    <xsl:template name="user-name">
        <span class="member-name">
            <xsl:choose>
                <xsl:when test="content/@id">
                    <xsl:call-template name="user-page">
                      <xsl:with-param name="title" select="info/fullname" />
                      <xsl:with-param name="contentId" select="content/@id" />
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="info/fullname" />
                </xsl:otherwise>
            </xsl:choose>
        </span>
    </xsl:template>
    
    <xsl:template name="user-page">
        <xsl:param name="title" />
        <xsl:param name="contentId" />
    
        <xsl:variable name="page-id"><xsl:value-of select="user:getUserPage($contentId, /project/@userDirectorySiteName)"/></xsl:variable>
	    <xsl:choose>
	       <xsl:when test="$page-id != ''">
	           <a class="user-link" href="{resolver:resolve('page', $page-id, false)}"><xsl:value-of select="$title" /></a>
	       </xsl:when>
	       <xsl:otherwise>
	           <xsl:value-of select="$title" />
	       </xsl:otherwise>
	    </xsl:choose>
    </xsl:template>
    
    <xsl:template name="members-page">
        <xsl:choose>
            <xsl:when test="/project/@memberPageId">
                <a class="nb-members link-members" href="{resolver:resolve('page', /project/@memberPageId)}"><xsl:call-template name="nb-members" /></a>
            </xsl:when>
            <xsl:otherwise>
                <span class="nb-members"><xsl:call-template name="nb-members" /></span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="nb-members">
        <xsl:choose>
            <xsl:when test="/project/@nbMembers &lt; 2">
                <i18n:translate>
                    <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_DISPLAY_MEMBERS_XSLT_MEMBER" i18n:catalogue="plugin.workspaces"/>
                    <i18n:param><xsl:value-of select="/project/@nbMembers"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:key="PLUGINS_WORKSPACES_PROJECT_SERVICE_DISPLAY_MEMBERS_XSLT_MEMBERS" i18n:catalogue="plugin.workspaces"/>
                    <i18n:param><xsl:value-of select="/project/@nbMembers"/></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
