<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2025 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                extension-element-prefixes="resolver">
    
    <xsl:import href="common.xsl"/>
    
    <xsl:template match="hit">
        <div class="ametys-search-item" data-module-hit="true">
            <p>
                <a href="{resolver:resolve('page', page)}"><xsl:value-of select="attributes/title"/></a>
                <br/>
                <xsl:choose>
                    <xsl:when test="project">
                        <em><xsl:value-of select="project/title"/></em>
                    </xsl:when>
                    <xsl:when test="category">
                        <em><xsl:value-of select="category/title"/></em>
                    </xsl:when>
                </xsl:choose>
            </p>
        </div>
    </xsl:template> 
    
</xsl:stylesheet>