<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:import href="about.xsl"/>

    <xsl:variable name="common-content-css-class-name">about view-main</xsl:variable>     

    <xsl:template name="common-content-head-title-content">
        <xsl:param name="title" select="metadata/title"/>

        <title><xsl:value-of select="$title"/></title>
    </xsl:template>

    <!-- Vue main -->
    <xsl:template name="common-content-body-title-content">
        <xsl:param name="title" select="metadata/title"/>
        <xsl:param name="subtitle" select="metadata/document-subtitle"/>
        
        <h1>
            <span data-ametys-metadata="{@id};title" class="content-title"><xsl:value-of select="$title"/></span>
        </h1>
    </xsl:template>
    
    <xsl:template name="common-content-body-content">

        <xsl:choose>
            <xsl:when test="metadata/content">
                <div data-ametys-metadata="{@id};content">
                    <xsl:call-template name="common-content-body-content-rich">
                        <xsl:with-param name="content" select="metadata/content"/>
                    </xsl:call-template>
                </div>
            </xsl:when>

            <xsl:otherwise>
                <div data-ametys-metadata="{@id};content" class="editionfo-content-placeholder">
                    <p>&#160;</p>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


</xsl:stylesheet>
