<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:exslt="http://exslt.org/common"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    
    <xsl:template name="footer-logo-href">
        <xsl:attribute name="href"><xsl:value-of select="$catalogHomeUrl"/></xsl:attribute>
    </xsl:template>
    
    <!-- Override to add user preference link from tagged page -->
    <xsl:template name="footer-inner-content">
        <xsl:call-template name="footer-text-product"/>
                        
        <xsl:call-template name="footer-userprefs-link"/>     
    </xsl:template>
    
    <xsl:template name="footer-userprefs-link">
    
        <xsl:variable name="availableLanguages" select="ametys:siteLanguages($catalogSiteName)"/>
        
        <xsl:variable name="rawPrefPages">
            <xsl:for-each select="$availableLanguages">
                <xsl:variable name="prefsPage" select="ametys:findPagesIdsByTag($catalogSiteName, text(), 'WORKSPACES_PREFERENCES')"/>
                <xsl:if test="$prefsPage/@id">
                    <xsl:element name="{text()}"><xsl:value-of select="$prefsPage/@id"/></xsl:element>
                </xsl:if>
            </xsl:for-each>
       </xsl:variable> 
       <xsl:variable name="prefPages" select="exslt:node-set($rawPrefPages)"/>
            
       <xsl:variable name="prefPageId">
            <xsl:choose>
                <xsl:when test="$prefPages/*[local-name() = $lang]"><xsl:value-of select="$prefPages/*[local-name() = $lang]"/></xsl:when>
                <xsl:when test="$prefPages/*[local-name() = 'en']"><xsl:value-of select="$prefPages/*[local-name() = 'en']"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$prefPages/*[1]"/></xsl:otherwise><!-- first available language -->
            </xsl:choose>
       </xsl:variable>
            
       <xsl:if test="$prefPageId">
            <xsl:call-template name="footer-link">
                <xsl:with-param name="url" select="resolver:resolve('page', $prefPageId)"/>
                <xsl:with-param name="text"><i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_FOOTER_MANAGE_NOTIFICATION" i18n:catalog="plugin.workspaces"/></xsl:with-param>
                <xsl:with-param name="imgPluginName">core-ui</xsl:with-param>
                <xsl:with-param name="imgPath">img/mail/icon-letter.png</xsl:with-param>
            </xsl:call-template>
       </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>