<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:avatar="org.ametys.plugins.core.ui.user.ProfileImageResolverHelper">
                              
    <!-- 
    <item type="forum">
        <title>foo</title>
        <date>yyyy-MM-dd'T'HH:mm:ss.SSSXXX</date>
        <eventType>FORUMTHREAD_CREATED|FORUMTHREAD_COMMENTED|...</eventType>
        <author>
            <login/>
            <populationId/>
            <fullname/>
            <firstname/>
            <email/>
            ...
        </author>
        <multiple>true|false</multiple>
        <comments>
            <comment>
                <content>Lorem ipsum sit amet</content>
                <datetime>yyyy-MM-dd'T'HH:mm:ss.SSSXXX</datetime>
                <author>
                    <login/>
                    <populationId/>
                    <fullname/>
                    <firstname/>
                    <email/>
                    ...
                </author>
            </comment>
        </comments>
    <item>
     -->
     
    <xsl:template match="item[@type='forum']" mode="item-icon">
        <div style="width: 30px; height: 30px; display: inline-block;">
            <xsl:variable name="iconName">    
                <xsl:choose>
                    <xsl:when test="threadCategory = 'DISCUSSION'">icon-discussions</xsl:when>
                    <xsl:otherwise>questions-icon</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <img width="30" height="30" src="{ametys:pluginImageBase64('workspaces', concat('img/mail/', $iconName, '.png'))}" alt="" style="display: block; border: 0; outline: none; text-decoration: none;"></img>
        </div>
    </xsl:template>
     
    <!-- no separator for thread with comments -->
    <xsl:template match="item[@type='forum'][comments/comment]" mode="item-separator-style"/>
        
    <xsl:template match="item[@type='forum']" mode="item-additional-content">
        <xsl:param name="isLast"/>
        
        <!-- We stick the comment inside the element -->
        <xsl:apply-templates select="comments/comment"/>
    </xsl:template>
   
    <!-- no separator for thread items -->
    <xsl:template match="item[@type='comment']" mode="item-separator-style"/>
    
    <!-- Specific template for previous comments -->
    <xsl:template match="item[@type='comment']" mode="item-content">
        <table id="item[@type=" align="left" border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse: collapse; border-spacing: 0px; width: 100%;">
            <tbody>
                <tr>
                    <td width="40" style="padding: 0px; direction: ltr; font-size: 0px; word-break: break-word;" valign="top">
                        <div style="width: 30px; height: 30px; display: inline-block;">
                            <xsl:variable name="lang"><xsl:value-of select="ametys:lang()"/></xsl:variable>
                            <img width="30" height="30" src="{avatar:resolveAsBase64(author/login, author/populationId, 34, $lang)}" alt="{author/fullname}"  style="display: block; border: solid 3px #fff; border-radius: 50%; outline: none; text-decoration: none;"></img>
                        </div>
                    </td>
                    <xsl:call-template name="row-horizontal-spacer">
                        <xsl:with-param name="width">10</xsl:with-param>
                    </xsl:call-template>
                    <td style="direction: ltr; font-size: 0px; padding: 0px; word-break: break-word;">
                        <!-- Author -->
                        <div style="font-weight: 700; font-size: 12px; line-height: 1.6; color: {$text-color-dark}; font-family: {$font-family};">
                            <xsl:value-of select="author/fullname"/>
                        </div>
                        <!-- Date -->
                        <xsl:variable name="i18nparam"><param/></xsl:variable>
                        <xsl:variable name="date-format" select="ametys:translate('plugin.workspaces:PROJECT_MAIL_NOTIFICATION_FORUMTHREAD_COMMENTED_LAST_MODIFIED_DATE_FORMAT', $lang, $i18nparam)"></xsl:variable>
                        <div style="font-weight: 300; font-style: italic; font-size: 12px; line-height: 1.6; color: {$text-color-dark}; font-family: {$font-family};">
                            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-format}"><xsl:value-of select="datetime"/></i18n:date>
                        </div>
                        <!-- Content -->
                        <div style="font-weight: 300; font-style: italic; font-size: 12px; line-height: 1.6; color: {$text-color}; font-family: {$font-family};">
                            <xsl:copy-of select="content"/>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </xsl:template>
</xsl:stylesheet>