/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import { useLocale, useTheme } from 'vuetify';

export function initVuetify() {
    const { themes } = useTheme();

    themes.value.light.colors.primary = "#9575CD";
    themes.value.dark.colors.primary = "#9575CD";
    
    themes.value.light.colors.background = "#f7f8fa";
    themes.value.dark.colors.background = "#f7f8fa";
    
    themes.value.light.colors.error = "#ff5252";
    themes.value.dark.colors.error = "#ff5252";

    const { current } = useLocale()
    current.value = window.AmetysFront.getAppParameter('sitemapLanguage');
}
