/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import Debouncer from '@common/helper/Debouncer.js'
import { useEventFiltersStore } from '@/stores/eventFilters'
import { useCalendarsStore } from '@/stores/calendars'
import { useEventsStore } from '@/stores/events'
import { mapState, mapActions } from 'pinia'

export default {
  computed: {

    ...mapState(useEventFiltersStore, ['filterByCalendar', 'filterByName', 'start', 'end', 'filterByResourceCalendar']),
    ...mapState(useCalendarsStore, {
      calendarType: 'getCalendarType'
    }),
  },

  methods: {
    ...mapActions(useEventsStore, ['loadEvents'])
  },

  created() {
    this.loadEventsMixin = Debouncer((cb = null) => {

      this.loadEvents(this.start, this.end).finally(() => {
        if (cb) cb()
      })
    }, 400)
  },
}
