/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import { createApp } from 'vue'
import { createVuetify } from 'vuetify'

import { createPinia } from 'pinia'

import App from '@/MembersModule.vue';

// Translations provided by Vuetify
import { fr, en } from 'vuetify/locale'

import { fa } from 'vuetify/iconsets/fa'
import { md } from 'vuetify/iconsets/md'

window['vue-members-run'] = function (selector) {
    
    
    const vuetify = createVuetify({
    	icons: {
            defaultSet: 'fa',
            sets: {
              fa,
              md
            },
        },
        locale: {
            messages: {
                fr: fr,
                en: en
            },
        },
    });

    const app = createApp(App);
    
    const pinia = createPinia()
    app.use(pinia);
    app.use(vuetify);
    
    app.mount(selector);
};

